/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.altar.AltarInfusionRecipe;
import iskallia.vault.block.entity.VaultAltarTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.world.data.PlayerVaultAltarData;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class VaultAltarBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public VaultAltarBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76367_).m_60913_(3.0f, 3600000.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<A> type) {
        return BlockHelper.getTicker(type, ModBlocks.VAULT_ALTAR_TILE_ENTITY, VaultAltarTileEntity::tick);
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.FALSE);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public void m_7100_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (!(tileEntity instanceof VaultAltarTileEntity)) {
            return;
        }
        VaultAltarTileEntity altarTileEntity = (VaultAltarTileEntity)tileEntity;
        AltarInfusionRecipe recipe = altarTileEntity.getRecipe();
        if (recipe == null || !recipe.isPogInfused()) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pos.m_123341_() + rand.nextDouble();
            double d1 = (double)pos.m_123342_() + rand.nextDouble();
            double d2 = (double)pos.m_123343_() + rand.nextDouble();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (!world.m_8055_(pos.m_142125_()).m_60713_((Block)this) && !world.m_8055_(pos.m_142126_()).m_60713_((Block)this)) {
                d0 = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            world.m_7106_((ParticleOptions)ParticleTypes.f_123771_, d0, d1, d2, d3, d4, d5);
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ModBlocks.VAULT_ALTAR_TILE_ENTITY.m_155264_(pos, state);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ServerPlayer serverPlayer;
        block8: {
            block7: {
                if (world.f_46443_ || hand != InteractionHand.MAIN_HAND || !(player instanceof ServerPlayer)) break block7;
                serverPlayer = (ServerPlayer)player;
                if (!(player instanceof FakePlayer)) break block8;
            }
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = serverPlayer.m_183503_();
        ItemStack heldItem = player.m_21205_();
        VaultAltarTileEntity altar = this.getAltarTileEntity(world, pos);
        if (altar == null) {
            return InteractionResult.SUCCESS;
        }
        if (altar.getAltarState() == VaultAltarTileEntity.AltarState.IDLE) {
            if (heldItem.m_41720_() == ModItems.VAULT_ROCK) {
                return altar.onAddVaultRock(serverPlayer, heldItem);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && (altar.getAltarState() == VaultAltarTileEntity.AltarState.ACCEPTING || altar.getAltarState() == VaultAltarTileEntity.AltarState.COMPLETE)) {
            InteractionResult result = altar.onRemoveVaultRock(serverPlayer.m_142081_());
            PlayerVaultAltarData.get(serverLevel).m_77762_();
            return result;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6861_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block neighborBlock, @NotNull BlockPos neighborPos, boolean isMoving) {
        VaultAltarTileEntity altar;
        if (level.f_46443_) {
            return;
        }
        boolean powered = level.m_46753_(pos);
        if (powered != (Boolean)state.m_61143_((Property)POWERED) && powered && (altar = this.getAltarTileEntity(level, pos)) != null) {
            altar.onAltarPowered();
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    private VaultAltarTileEntity getAltarTileEntity(Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (!(te instanceof VaultAltarTileEntity)) {
            return null;
        }
        VaultAltarTileEntity tile = (VaultAltarTileEntity)te;
        return tile;
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        ItemEntity entity;
        VaultAltarTileEntity altar = this.getAltarTileEntity(level, pos);
        if (altar == null) {
            return;
        }
        if (newState.m_60734_() != Blocks.f_50016_) {
            return;
        }
        if (altar.getAltarState() == VaultAltarTileEntity.AltarState.ACCEPTING || altar.getAltarState() == VaultAltarTileEntity.AltarState.COMPLETE) {
            entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ModItems.VAULT_ROCK));
            level.m_7967_((Entity)entity);
        }
        entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ModBlocks.VAULT_ALTAR));
        level.m_7967_((Entity)entity);
        PlayerVaultAltarData.get((ServerLevel)level).removeAltar(altar.getOwner(), pos);
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void m_6402_(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        if (level.f_46443_) {
            return;
        }
        VaultAltarTileEntity altar = (VaultAltarTileEntity)level.m_7702_(pos);
        if (altar == null || !(placer instanceof Player)) {
            return;
        }
        altar.setOwner(placer.m_142081_());
        altar.setAltarState(VaultAltarTileEntity.AltarState.IDLE);
        altar.sendUpdates();
        PlayerVaultAltarData.get((ServerLevel)level).addAltar(placer.m_142081_(), pos);
        super.m_6402_(level, pos, state, placer, stack);
    }
}

