/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.VaultCrateTileEntity;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModSounds;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VaultCrateBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty HORIZONTAL_FACING = DirectionProperty.m_61546_((String)"horizontal_facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public VaultCrateBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(2.0f, 3600000.0f).m_60918_(SoundType.f_56743_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    public static ItemStack getCrateWithLoot(Type type, NonNullList<ItemStack> items) {
        VaultCrateBlock block;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BOSS: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE;
                break;
            }
            case SCAVENGER: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE_SCAVENGER;
                break;
            }
            case CAKE: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE_CAKE;
                break;
            }
            case ARENA: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE_ARENA;
                break;
            }
            case CHAMPION: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE_CHAMPION;
                break;
            }
            case BOUNTY: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE_BOUNTY;
                break;
            }
            case MONOLITH: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE_MONOLITH;
                break;
            }
            case ELIXIR: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE_ELIXIR;
                break;
            }
            case PARADOX: {
                VaultCrateBlock vaultCrateBlock = block = ModBlocks.VAULT_CRATE_PARADOX;
            }
        }
        if (items.size() > 54) {
            VaultMod.LOGGER.error("Attempted to get a crate with more than 54 items. Check crate loot table.");
            items = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])((ItemStack[])items.stream().limit(54L).toArray(ItemStack[]::new)));
        }
        ItemStack crate = new ItemStack((ItemLike)block);
        CompoundTag nbt = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)nbt, items);
        if (!nbt.m_128456_()) {
            crate.m_41700_("BlockEntityTag", (Tag)nbt);
        }
        return crate;
    }

    public static ItemStack getCrateWithLootOversized(Type type, NonNullList<OverSizedItemStack> items) {
        VaultCrateBlock block;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BOSS: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE;
                break;
            }
            case SCAVENGER: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE_SCAVENGER;
                break;
            }
            case CAKE: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE_CAKE;
                break;
            }
            case ARENA: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE_ARENA;
                break;
            }
            case CHAMPION: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE_CHAMPION;
                break;
            }
            case BOUNTY: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE_BOUNTY;
                break;
            }
            case MONOLITH: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE_MONOLITH;
                break;
            }
            case ELIXIR: {
                VaultCrateBlock vaultCrateBlock = ModBlocks.VAULT_CRATE_ELIXIR;
                break;
            }
            case PARADOX: {
                VaultCrateBlock vaultCrateBlock = block = ModBlocks.VAULT_CRATE_PARADOX;
            }
        }
        if (items.size() > 54) {
            VaultMod.LOGGER.error("Attempted to get a crate with more than 54 items. Check crate loot table.");
            items = NonNullList.m_122783_((Object)OverSizedItemStack.EMPTY, (Object[])((OverSizedItemStack[])items.stream().limit(54L).toArray(OverSizedItemStack[]::new)));
        }
        ItemStack crate = new ItemStack((ItemLike)block);
        CompoundTag nbt = new CompoundTag();
        NBTHelper.writeCollection(nbt, "items", items, CompoundTag.class, OverSizedItemStack::serialize);
        if (!nbt.m_128456_()) {
            crate.m_41700_("BlockEntityTag", (Tag)nbt);
        }
        return crate;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.VAULT_CRATE_TILE_ENTITY.m_155264_(pPos, pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HORIZONTAL_FACING, FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_6144_() && !world.f_46443_) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof VaultCrateTileEntity) {
                VaultCrateTileEntity crate = (VaultCrateTileEntity)blockEntity;
                crate.getItems().forEach(oversizedStack -> oversizedStack.splitByStackSize().forEach(split -> VaultCrateBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)split)));
                crate.getItems().clear();
            }
            world.m_7471_(pos, false);
            Vec3 vec3 = new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f));
            world.m_6263_(null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, ModSounds.CRATE_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
            BlockParticleOption particle = new BlockParticleOption(ParticleTypes.f_123794_, state);
            ((ServerLevel)world).m_8767_((ParticleOptions)particle, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 400, 1.0, 1.0, 1.0, 0.5);
            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_175831_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 50, 1.0, 1.0, 1.0, 0.5);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(world, pos, state, player);
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof VaultCrateTileEntity) {
            VaultCrateTileEntity crate = (VaultCrateTileEntity)tileentity;
            ItemStack itemstack = new ItemStack((ItemLike)this);
            CompoundTag compoundnbt = crate.m_187482_();
            if (!compoundnbt.m_128456_()) {
                itemstack.m_41700_("BlockEntityTag", (Tag)compoundnbt);
            }
            ItemEntity itementity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
            itementity.m_32060_();
            world.m_7967_((Entity)itementity);
        }
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction placeDir = context.m_7820_().m_122424_();
        Direction horizontalDir = Direction.NORTH;
        if (placeDir.m_122434_().m_122478_()) {
            for (Direction direction : context.m_6232_()) {
                if (!direction.m_122434_().m_122479_()) continue;
                horizontalDir = direction;
                break;
            }
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeDir)).m_61124_((Property)HORIZONTAL_FACING, (Comparable)horizontalDir);
    }

    private VaultCrateTileEntity getCrateTileEntity(Level worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (!(blockEntity instanceof VaultCrateTileEntity)) {
            return null;
        }
        VaultCrateTileEntity tile = (VaultCrateTileEntity)blockEntity;
        return tile;
    }

    public static enum Type {
        BOSS,
        SCAVENGER,
        CAKE,
        ARENA,
        CHAMPION,
        BOUNTY,
        MONOLITH,
        ELIXIR,
        PARADOX;

    }
}

