/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import com.google.common.base.Functions;
import iskallia.vault.block.item.VaultOreBlockItem;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.tool.ToolItem;
import iskallia.vault.util.calc.CopiousHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.OreBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;

public class VaultOreBlock
extends OreBlock {
    public static final List<VaultOreBlock> ALL = new ArrayList<VaultOreBlock>();
    private static final ItemPredicate HAS_SILK_TOUCH = ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))).m_45077_();
    public static final BooleanProperty GENERATED = BooleanProperty.m_61465_((String)"generated");
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);
    private final Item associatedGem;

    public VaultOreBlock(@Nonnull Item associatedGem) {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76367_).m_60999_().m_60953_(state -> 9).m_60913_(4.6f, 3.0f).m_60918_((SoundType)ModSounds.VAULT_GET_SOUND_TYPE));
        this.associatedGem = associatedGem;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)GENERATED, (Comparable)Boolean.valueOf(false))).m_61124_(TYPE, (Comparable)((Object)Type.STONE)));
        ALL.add(this);
    }

    @Nonnull
    public Item getAssociatedGem() {
        return this.associatedGem;
    }

    public int getExpDrop(BlockState state, LevelReader reader, BlockPos pos, int fortune, int silktouch) {
        if (!((Boolean)state.m_61143_((Property)GENERATED)).booleanValue() && silktouch > 0) {
            return 0;
        }
        return Mth.m_14072_((Random)this.RANDOM, (int)3, (int)7);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{GENERATED}).m_61104_(new Property[]{TYPE});
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack stack = (ItemStack)builder.m_78982_(LootContextParams.f_81463_);
        if (stack != null && HAS_SILK_TOUCH.m_45049_(stack)) {
            drops.add(VaultOreBlockItem.fromType((Block)this, (Type)((Object)state.m_61143_(TYPE))));
        } else {
            drops = super.m_7381_(state, builder);
        }
        if (((Boolean)state.m_61143_((Property)GENERATED)).booleanValue()) {
            ArrayList<ItemStack> copy = new ArrayList<ItemStack>(drops);
            for (float chance = VaultOreBlock.getCopiouslyChance(builder); chance > 0.0f && this.RANDOM.nextFloat() < chance; chance -= 1.0f) {
                Item item;
                Entity player = (Entity)builder.m_78982_(LootContextParams.f_81455_);
                BlockPos pos = new BlockPos(player.m_146903_(), player.m_146904_(), player.m_146907_());
                player.f_19853_.m_5594_(null, pos, ModSounds.VAULT_CHEST_OMEGA_OPEN, SoundSource.BLOCKS, 0.1f, 0.85f);
                drops.addAll(copy);
                if (stack == null || !((item = stack.m_41720_()) instanceof ToolItem)) continue;
                ToolItem tool = (ToolItem)item;
                Entity entity = (Entity)builder.m_78982_(LootContextParams.f_81455_);
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                tool.hurt(stack, (Level)builder.m_78962_(), livingEntity, 6.0);
            }
        }
        ToolItem.handleLoot(builder, drops);
        return drops;
    }

    private static float getCopiouslyChance(LootContext.Builder ctx) {
        float chance = 0.0f;
        Object object = ctx.m_78982_(LootContextParams.f_81455_);
        if (object instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)object;
            chance += CopiousHelper.getCopiousChance(entity);
        }
        return chance;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Type type;
        BlockState blockState = this.m_49966_();
        CompoundTag nbt = context.m_43722_().m_41783_();
        if (nbt != null && (type = Type.fromString(nbt.m_128461_("type"))) != null) {
            blockState = (BlockState)blockState.m_61124_(TYPE, (Comparable)((Object)type));
        }
        return blockState;
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        for (Type type : Type.values()) {
            items.add((Object)VaultOreBlockItem.fromType((Block)this, type));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack itemStack = super.getCloneItemStack(state, target, level, pos, player);
        itemStack.m_41784_().m_128359_("type", ((Type)((Object)state.m_61143_(TYPE))).m_7912_());
        return itemStack;
    }

    public static enum Type implements StringRepresentable
    {
        STONE,
        VAULT_STONE,
        WHITE;

        private static final Map<String, Type> NAME_TO_TYPE;

        public static Type fromString(String name) {
            return NAME_TO_TYPE.get(name.toLowerCase(Locale.ROOT));
        }

        @Nonnull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            NAME_TO_TYPE = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::m_7912_, Functions.identity()));
        }
    }
}

