/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.WardrobeTileEntity;
import iskallia.vault.container.WardrobeContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class WardrobeBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0);

    public WardrobeBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.5f, 6.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WardrobeTileEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WardrobeTileEntity) {
            WardrobeTileEntity wardrobeTile = (WardrobeTileEntity)blockEntity;
            if (placer != null) {
                wardrobeTile.setOwner(placer.m_142081_());
            }
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof WardrobeTileEntity) {
                WardrobeTileEntity wardrobeTile = (WardrobeTileEntity)blockEntity;
                wardrobeTile.getEquipmentSlots().values().forEach(stack -> WardrobeBlock.dropStack(level, pos, stack));
                wardrobeTile.getCuriosItems().values().forEach(stacks -> stacks.values().forEach(stack -> WardrobeBlock.dropStack(level, pos, stack)));
                for (int slot = 0; slot < wardrobeTile.getHotbarItems().getSlots(); ++slot) {
                    ItemStack stackInSlot = wardrobeTile.getHotbarItems().getStackInSlot(slot);
                    if (stackInSlot.m_41619_()) continue;
                    WardrobeBlock.dropStack(level, pos, stackInSlot);
                }
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    private static void dropStack(Level level, BlockPos pos, ItemStack stack) {
        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack.m_41777_());
    }

    @SubscribeEvent
    public static void onInteractWithWardrobe(PlayerInteractEvent.RightClickBlock event) {
        ServerPlayer player;
        Entity entity;
        block3: {
            block2: {
                entity = event.getEntity();
                if (!(entity instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)entity;
                if (event.getHand() == InteractionHand.OFF_HAND && player.m_6144_() && !player.m_21120_(InteractionHand.OFF_HAND).m_41619_() && (entity = player.m_183503_().m_7702_(event.getPos())) instanceof WardrobeTileEntity) break block3;
            }
            return;
        }
        WardrobeTileEntity wardrobeTile = (WardrobeTileEntity)entity;
        wardrobeTile.swap((Player)player, false);
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof WardrobeTileEntity)) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        WardrobeTileEntity wardrobeTile = (WardrobeTileEntity)be;
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_()) {
            wardrobeTile.swap(player, false);
        } else {
            this.openGui(pos, (ServerPlayer)player);
        }
        return InteractionResult.SUCCESS;
    }

    private void openGui(final BlockPos pos, ServerPlayer player) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return WardrobeBlock.this.m_49954_();
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                return new WardrobeContainer.Gear(windowId, inventory, pos);
            }
        }, (BlockPos)pos);
    }
}

