/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.base;

import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.block.base.GodAltarTileEntity;
import iskallia.vault.block.item.GodAltarBlockItem;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModParticles;
import iskallia.vault.util.BlockHelper;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class GodAltarBlock
extends FacedBlock
implements EntityBlock {
    public static final EnumProperty<VaultGod> GOD = EnumProperty.m_61587_((String)"god", VaultGod.class);
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public GodAltarBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(-1.0f, 3600000.0f).m_60993_().m_60955_());
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{GOD});
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public ParticleOptions getFlameParticle(BlockState state) {
        return switch ((VaultGod)((Object)state.m_61143_(GOD))) {
            default -> throw new IncompatibleClassChangeError();
            case VaultGod.VELARA -> (SimpleParticleType)ModParticles.GREEN_FLAME.get();
            case VaultGod.TENOS -> (SimpleParticleType)ModParticles.YELLOW_FLAME.get();
            case VaultGod.WENDARR -> (SimpleParticleType)ModParticles.BLUE_FLAME.get();
            case VaultGod.IDONA -> (SimpleParticleType)ModParticles.RED_FLAME.get();
        };
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        VaultGod god;
        BlockState state = super.m_5573_(context);
        CompoundTag nbt = context.m_43722_().m_41783_();
        if (nbt != null && (god = VaultGod.fromName(nbt.m_128461_("god"))) != null) {
            state = (BlockState)state.m_61124_(GOD, (Comparable)((Object)god));
        }
        return state;
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        for (VaultGod god : VaultGod.values()) {
            items.add((Object)GodAltarBlockItem.fromType(god));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack itemStack = super.getCloneItemStack(state, target, level, pos, player);
        itemStack.m_41784_().m_128359_("god", ((VaultGod)((Object)state.m_61143_(GOD))).m_7912_());
        return itemStack;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof GodAltarTileEntity) {
            GodAltarTileEntity altar = (GodAltarTileEntity)blockEntity;
            altar.onClick((ServerLevel)world, (ServerPlayer)player);
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level world, BlockPos pos, Random rand) {
        GodAltarTileEntity godAltarTileEntity;
        Direction facing = (Direction)stateIn.m_61143_((Property)FACING);
        Direction rightDirection = facing.m_122427_();
        Direction leftDirection = rightDirection.m_122424_();
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof GodAltarTileEntity && !(godAltarTileEntity = (GodAltarTileEntity)tileEntity).isCompleted()) {
            for (int i = 0; i < 2; ++i) {
                if (stateIn.m_61143_(GOD) == VaultGod.VELARA) {
                    this.addFlameParticle(world, pos, 8.0 - (double)rightDirection.m_122429_() * 6.25 - (double)facing.m_122429_() * 4.5, 7.0, 8.0 - (double)rightDirection.m_122431_() * 6.25 - (double)facing.m_122431_() * 4.5);
                    this.addFlameParticle(world, pos, 8.0 - (double)rightDirection.m_122429_() * 6.5 - (double)facing.m_122429_() * 2.5, 6.0, 8.0 - (double)rightDirection.m_122431_() * 6.5 - (double)facing.m_122431_() * 2.5);
                    this.addFlameParticle(world, pos, 8.0 - (double)rightDirection.m_122429_() * 5.5 - (double)facing.m_122429_() * 6.5, 6.0, 8.0 - (double)rightDirection.m_122431_() * 5.5 - (double)facing.m_122431_() * 6.5);
                    this.addFlameParticle(world, pos, 8.0 - (double)rightDirection.m_122429_() * 4.5 - (double)facing.m_122429_() * 1.5, 8.0, 8.0 - (double)rightDirection.m_122431_() * 4.5 - (double)facing.m_122431_() * 1.5);
                    this.addFlameParticle(world, pos, 8.0 - (double)leftDirection.m_122429_() * 6.25 - (double)facing.m_122429_() * 4.5, 7.0, 8.0 - (double)leftDirection.m_122431_() * 6.25 - (double)facing.m_122431_() * 4.5);
                    this.addFlameParticle(world, pos, 8.0 - (double)leftDirection.m_122429_() * 6.5 - (double)facing.m_122429_() * 2.5, 6.0, 8.0 - (double)leftDirection.m_122431_() * 6.5 - (double)facing.m_122431_() * 2.5);
                    this.addFlameParticle(world, pos, 8.0 - (double)leftDirection.m_122429_() * 5.5 - (double)facing.m_122429_() * 6.5, 6.0, 8.0 - (double)leftDirection.m_122431_() * 5.5 - (double)facing.m_122431_() * 6.5);
                    this.addFlameParticle(world, pos, 8.0 - (double)leftDirection.m_122429_() * 4.5 - (double)facing.m_122429_() * 1.5, 8.0, 8.0 - (double)leftDirection.m_122431_() * 4.5 - (double)facing.m_122431_() * 1.5);
                    continue;
                }
                this.addFlameParticle(world, pos, 8.0 - (double)rightDirection.m_122429_() * 5.5 - (double)facing.m_122429_() * 4.5, 6.5, 8.0 - (double)rightDirection.m_122431_() * 5.5 - (double)facing.m_122431_() * 4.5);
                this.addFlameParticle(world, pos, 8.0 - (double)rightDirection.m_122429_() * 6.5 - (double)facing.m_122429_() * 2.5, 6.0, 8.0 - (double)rightDirection.m_122431_() * 6.5 - (double)facing.m_122431_() * 2.5);
                this.addFlameParticle(world, pos, 8.0 - (double)rightDirection.m_122429_() * 6.5 - (double)facing.m_122429_() * 6.5, 6.0, 8.0 - (double)rightDirection.m_122431_() * 6.5 - (double)facing.m_122431_() * 6.5);
                this.addFlameParticle(world, pos, 8.0 - (double)leftDirection.m_122429_() * 5.5 - (double)facing.m_122429_() * 4.5, 6.5, 8.0 - (double)leftDirection.m_122431_() * 5.5 - (double)facing.m_122431_() * 4.5);
                this.addFlameParticle(world, pos, 8.0 - (double)leftDirection.m_122429_() * 6.5 - (double)facing.m_122429_() * 2.5, 6.0, 8.0 - (double)leftDirection.m_122431_() * 6.5 - (double)facing.m_122431_() * 2.5);
                this.addFlameParticle(world, pos, 8.0 - (double)leftDirection.m_122429_() * 6.5 - (double)facing.m_122429_() * 6.5, 6.0, 8.0 - (double)leftDirection.m_122431_() * 6.5 - (double)facing.m_122431_() * 6.5);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFlameParticle(Level world, BlockPos pos, double xOffset, double yOffset, double zOffset) {
        double x = (double)pos.m_123341_() + xOffset / 16.0;
        double y = (double)pos.m_123342_() + yOffset / 16.0;
        double z = (double)pos.m_123343_() + zOffset / 16.0;
        world.m_7106_(this.getFlameParticle(world.m_8055_(pos)), x, y, z, 0.0, 0.0, 0.0);
    }

    public static void snuffCandles(BlockState stateIn, Level world, BlockPos pos) {
        Direction facing = (Direction)stateIn.m_61143_((Property)FACING);
        Direction rightDirection = facing.m_122427_();
        Direction leftDirection = rightDirection.m_122424_();
        for (int i = 0; i < 2; ++i) {
            if (stateIn.m_61143_(GOD) == VaultGod.VELARA) {
                GodAltarBlock.addSmokeParticle(world, pos, 8.0 - (double)rightDirection.m_122429_() * 6.25 - (double)facing.m_122429_() * 4.5, 7.0, 8.0 - (double)rightDirection.m_122431_() * 6.25 - (double)facing.m_122431_() * 4.5);
                GodAltarBlock.addSmokeParticle(world, pos, 8.0 - (double)rightDirection.m_122429_() * 6.5 - (double)facing.m_122429_() * 2.5, 6.0, 8.0 - (double)rightDirection.m_122431_() * 6.5 - (double)facing.m_122431_() * 2.5);
                GodAltarBlock.addSmokeParticle(world, pos, 8.0 - (double)rightDirection.m_122429_() * 5.5 - (double)facing.m_122429_() * 6.5, 6.0, 8.0 - (double)rightDirection.m_122431_() * 5.5 - (double)facing.m_122431_() * 6.5);
                GodAltarBlock.addSmokeParticle(world, pos, 8.0 - (double)rightDirection.m_122429_() * 4.5 - (double)facing.m_122429_() * 1.5, 8.0, 8.0 - (double)rightDirection.m_122431_() * 4.5 - (double)facing.m_122431_() * 1.5);
                GodAltarBlock.addSmokeParticle(world, pos, 8.0 - (double)leftDirection.m_122429_() * 6.25 - (double)facing.m_122429_() * 4.5, 7.0, 8.0 - (double)leftDirection.m_122431_() * 6.25 - (double)facing.m_122431_() * 4.5);
                GodAltarBlock.addSmokeParticle(world, pos, 8.0 - (double)leftDirection.m_122429_() * 6.5 - (double)facing.m_122429_() * 2.5, 6.0, 8.0 - (double)leftDirection.m_122431_() * 6.5 - (double)facing.m_122431_() * 2.5);
                GodAltarBlock.addSmokeParticle(world, pos, 8.0 - (double)leftDirection.m_122429_() * 5.5 - (double)facing.m_122429_() * 6.5, 6.0, 8.0 - (double)leftDirection.m_122431_() * 5.5 - (double)facing.m_122431_() * 6.5);
                GodAltarBlock.addSmokeParticle(world, pos, 8.0 - (double)leftDirection.m_122429_() * 4.5 - (double)facing.m_122429_() * 1.5, 8.0, 8.0 - (double)leftDirection.m_122431_() * 4.5 - (double)facing.m_122431_() * 1.5);
                continue;
            }
            GodAltarBlock.addSmokeParticle(world, pos, 8.0 - (double)rightDirection.m_122429_() * 5.5 - (double)facing.m_122429_() * 4.5, 6.5, 8.0 - (double)rightDirection.m_122431_() * 5.5 - (double)facing.m_122431_() * 4.5);
            GodAltarBlock.addSmokeParticle(world, pos, 8.0 - (double)rightDirection.m_122429_() * 6.5 - (double)facing.m_122429_() * 2.5, 6.0, 8.0 - (double)rightDirection.m_122431_() * 6.5 - (double)facing.m_122431_() * 2.5);
            GodAltarBlock.addSmokeParticle(world, pos, 8.0 - (double)rightDirection.m_122429_() * 6.5 - (double)facing.m_122429_() * 6.5, 6.0, 8.0 - (double)rightDirection.m_122431_() * 6.5 - (double)facing.m_122431_() * 6.5);
            GodAltarBlock.addSmokeParticle(world, pos, 8.0 - (double)leftDirection.m_122429_() * 5.5 - (double)facing.m_122429_() * 4.5, 6.5, 8.0 - (double)leftDirection.m_122431_() * 5.5 - (double)facing.m_122431_() * 4.5);
            GodAltarBlock.addSmokeParticle(world, pos, 8.0 - (double)leftDirection.m_122429_() * 6.5 - (double)facing.m_122429_() * 2.5, 6.0, 8.0 - (double)leftDirection.m_122431_() * 6.5 - (double)facing.m_122431_() * 2.5);
            GodAltarBlock.addSmokeParticle(world, pos, 8.0 - (double)leftDirection.m_122429_() * 6.5 - (double)facing.m_122429_() * 6.5, 6.0, 8.0 - (double)leftDirection.m_122431_() * 6.5 - (double)facing.m_122431_() * 6.5);
        }
    }

    public static void addSmokeParticle(Level world, BlockPos pos, double xOffset, double yOffset, double zOffset) {
        double x = (double)pos.m_123341_() + xOffset / 16.0;
        double y = (double)pos.m_123342_() + yOffset / 16.0;
        double z = (double)pos.m_123343_() + zOffset / 16.0;
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 3, 0.0, (double)0.15f, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GodAltarTileEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockHelper.getTicker(type, ModBlocks.GOD_ALTAR_TILE_ENTITY, GodAltarTileEntity::tick);
    }
}

