/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.base;

import iskallia.vault.VaultMod;
import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.block.base.GodAltarBlock;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.core.Version;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.core.world.loot.LootPool;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.entity.entity.FloatingGodAltarItemEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.gear.DataInitializationItem;
import iskallia.vault.item.gear.DataTransferItem;
import iskallia.vault.item.gear.VaultLevelItem;
import iskallia.vault.task.CompleteGodAltarTask;
import iskallia.vault.task.FailGodAltarTask;
import iskallia.vault.task.KillEntityTask;
import iskallia.vault.task.NodeTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TimedTask;
import iskallia.vault.task.renderer.GodAltarRenderer;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.world.VaultDifficulty;
import iskallia.vault.world.data.GodAltarData;
import iskallia.vault.world.data.ServerVaults;
import iskallia.vault.world.data.WorldSettings;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GodAltarTileEntity
extends BlockEntity {
    protected UUID uuid;
    protected Task task;
    protected ItemStack loot;
    protected Task taskPool = new KillEntityTask(new KillEntityTask.Config(EntityPredicate.of("@the_vault:zombie", true).orElse(EntityPredicate.FALSE), IntRoll.ofUniform(1, 5))).add(new GodAltarRenderer.Base("Kill Zombies", "${current}/${target}"));
    protected ResourceLocation modifierCompletionPool = VaultMod.id("default");
    protected ResourceLocation modifierFailurePool = VaultMod.id("default");
    protected Map<VaultDifficulty, IntRoll> timePool = new HashMap<VaultDifficulty, IntRoll>();
    protected LootPool lootPool;

    public GodAltarTileEntity(BlockPos pos, BlockState state) {
        this(ModBlocks.GOD_ALTAR_TILE_ENTITY, pos, state);
    }

    public GodAltarTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        for (VaultDifficulty difficulty : VaultDifficulty.values()) {
            this.timePool.put(difficulty, IntRoll.ofConstant(1200));
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Task getTask() {
        return this.task;
    }

    public ItemStack getLoot() {
        return this.loot;
    }

    public LootPool getLootPool() {
        return this.lootPool;
    }

    public boolean isCompleted() {
        return this.task == null && this.uuid != null;
    }

    public void setTask(Task task) {
        this.task = task;
        this.sendUpdates();
    }

    public void fetchTask() {
        if (this.uuid != null) {
            this.setTask(GodAltarData.get(this.uuid).map(GodAltarData.Entry::getTask).orElse(null));
            return;
        }
        this.setTask(null);
    }

    public void setLoot(ItemStack loot) {
        this.loot = loot;
        this.sendUpdates();
    }

    public void onClick(ServerLevel world, ServerPlayer player) {
        UUID vaultUuid;
        this.fetchTask();
        if (this.task != null || this.isCompleted() || GodAltarData.contains((Entity)player)) {
            return;
        }
        ChunkRandom random = ChunkRandom.any();
        Vault vault = ServerVaults.get((Level)world).orElse(null);
        UUID uUID = vaultUuid = vault == null ? null : (UUID)vault.getOr(Vault.ID, null);
        if (vault != null) {
            random.setBlockSeed(vault.get(Vault.SEED), this.f_58858_, 1876541L);
        } else {
            random.setSeed(JavaRandom.ofNanoTime().getSeed());
        }
        VaultDifficulty difficulty = WorldSettings.get((Level)world).getPlayerDifficulty(player.m_142081_());
        VaultGod god = (VaultGod)((Object)world.m_8055_(this.f_58858_).m_61143_(GodAltarBlock.GOD));
        this.uuid = UUID.randomUUID();
        Object completion = new CompleteGodAltarTask(this.uuid, this.modifierCompletionPool, false).add(new GodAltarRenderer.Complete());
        FailGodAltarTask failure = new FailGodAltarTask(vaultUuid, player.m_142081_(), this.uuid, this.modifierFailurePool);
        Object task = new NodeTask((Task)new TimedTask(this.timePool.get((Object)difficulty).get(random)).add(new GodAltarRenderer.Timed()), new NodeTask((Task)this.taskPool.copy(), new NodeTask((Task)completion, new NodeTask[0])), new NodeTask(failure, new NodeTask[0])).add(new GodAltarRenderer.Node());
        GodAltarData.add(this.uuid, task, EntityTaskSource.of((RandomSource)random, new Entity[]{player}), god);
        this.fetchTask();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GodAltarTileEntity tile) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        if (tile.getUuid() != null) {
            tile.fetchTask();
        }
        if (tile.isCompleted() && tile.getLoot() == null) {
            tile.placeReward((Level)world, pos.m_7494_(), (VaultGod)((Object)world.m_8055_(pos).m_61143_(GodAltarBlock.GOD)));
        }
    }

    public void placeReward(Level world, BlockPos pos, VaultGod god) {
        RandomSource random = this.getRandom(world, 1876541);
        ItemStack stack = new ItemStack((ItemLike)ModItems.ERROR_ITEM);
        if (this.getLootPool() != null) {
            stack = this.getLootPool().getRandomFlat(Version.latest(), random).map(lootEntry -> lootEntry.getOverStack(random)).map(OverSizedItemStack::stack).orElse(stack);
        }
        Vault vault = ServerVaults.get(world).orElse(null);
        VaultLevelItem.doInitializeVaultLoot(stack, vault, null);
        stack = DataTransferItem.doConvertStack(stack);
        DataInitializationItem.doInitialize(stack);
        Direction facing = this.m_58900_().m_61138_((Property)FacedBlock.FACING) ? (Direction)this.m_58900_().m_61143_((Property)FacedBlock.FACING) : Direction.NORTH;
        FloatingGodAltarItemEntity floatingItemEntity = new FloatingGodAltarItemEntity(world, (double)pos.m_123341_() + 0.5 - (double)((float)facing.m_122436_().m_123341_() / 3.0f), (double)pos.m_123342_() + 0.5 - (double)((float)facing.m_122436_().m_123342_() / 3.0f), (double)pos.m_123343_() + 0.5 - (double)((float)facing.m_122436_().m_123343_() / 3.0f), stack);
        world.m_7967_((Entity)floatingItemEntity.setColor(god.getColor()));
        world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.8f, 0.2f);
        this.loot = stack;
    }

    public RandomSource getRandom(Level world, int salt) {
        ChunkRandom random = ChunkRandom.any();
        Vault vault = ServerVaults.get(world).orElse(null);
        if (vault != null) {
            random.setBlockSeed(vault.get(Vault.SEED), this.f_58858_, salt);
        } else {
            random.setSeed(JavaRandom.ofNanoTime().getSeed());
        }
        return random;
    }

    public void sendUpdates() {
        if (this.f_58857_ == null) {
            return;
        }
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        Adapters.UUID.writeNbt(this.uuid).ifPresent(task -> nbt.m_128365_("uuid", task));
        Adapters.TASK.writeNbt(this.task).ifPresent(task -> nbt.m_128365_("task", task));
        Adapters.ITEM_STACK.writeNbt(this.loot).ifPresent(task -> nbt.m_128365_("loot", task));
        Adapters.TASK.writeNbt(this.taskPool).ifPresent(task -> nbt.m_128365_("taskPool", task));
        Adapters.IDENTIFIER.writeNbt(this.modifierCompletionPool).ifPresent(task -> nbt.m_128365_("modifierCompletionPool", task));
        Adapters.IDENTIFIER.writeNbt(this.modifierFailurePool).ifPresent(task -> nbt.m_128365_("modifierFailurePool", task));
        CompoundTag timePool = new CompoundTag();
        for (VaultDifficulty difficulty : VaultDifficulty.values()) {
            Adapters.INT_ROLL.writeNbt(this.timePool.get((Object)difficulty)).ifPresent(task -> timePool.m_128365_(difficulty.name(), task));
        }
        nbt.m_128365_("timePool", (Tag)timePool);
        Adapters.LOOT_POOL.writeNbt(this.lootPool).ifPresent(task -> nbt.m_128365_("lootPool", (Tag)task));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.uuid = Adapters.UUID.readNbt(nbt.m_128423_("uuid")).orElse(null);
        this.task = Adapters.TASK.readNbt(nbt.m_128423_("task")).orElse(null);
        this.loot = Adapters.ITEM_STACK.readNbt(nbt.m_128423_("loot")).orElse(null);
        this.taskPool = Adapters.TASK.readNbt(nbt.m_128423_("taskPool")).orElse(this.taskPool);
        this.modifierCompletionPool = Adapters.IDENTIFIER.readNbt(nbt.m_128423_("modifierCompletionPool")).orElse(this.modifierCompletionPool);
        this.modifierFailurePool = Adapters.IDENTIFIER.readNbt(nbt.m_128423_("modifierFailurePool")).orElse(this.modifierFailurePool);
        CompoundTag timePool = nbt.m_128469_("timePool");
        for (VaultDifficulty difficulty : VaultDifficulty.values()) {
            Adapters.INT_ROLL.readNbt(timePool.m_128423_(difficulty.name())).ifPresent(roll -> this.timePool.put(difficulty, (IntRoll)roll));
        }
        this.lootPool = Adapters.LOOT_POOL.readNbt((ListTag)nbt.m_128423_("lootPool")).orElse(this.lootPool);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = this.m_187482_();
        nbt.m_128473_("taskPool");
        nbt.m_128473_("modifierCompletionPool");
        nbt.m_128473_("modifierFailurePool");
        nbt.m_128473_("timePool");
        nbt.m_128473_("lootPool");
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

