/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.config.AlchemyTableConfig;
import iskallia.vault.container.AlchemyArchiveContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.bottle.BottleItem;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.data.DiscoveredAlchemyEffectsData;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class AlchemyArchiveTileEntity
extends BlockEntity
implements MenuProvider {
    private static final int NUMBER_OF_EFFECTS_TO_CHOOSE_FROM = 3;
    private Set<UUID> usedPlayers = new HashSet<UUID>();
    private Map<UUID, List<String>> playerEffects = new HashMap<UUID, List<String>>();
    private static final Random bookRand = new Random();
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float rot;
    public float oRot;
    public float tRot;

    public AlchemyArchiveTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.ALCHEMY_ARCHIVE_TILE_ENTITY, pos, state);
    }

    public Set<UUID> getUsedPlayers() {
        return this.usedPlayers;
    }

    public boolean setUsedByPlayer(Player player) {
        if (this.usedPlayers.add(player.m_142081_())) {
            this.m_6596_();
            return true;
        }
        return false;
    }

    public boolean canBeUsed(Player player) {
        return !this.getUsedPlayers().contains(player.m_142081_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientBookTick(Level level, BlockPos pos, BlockState state, AlchemyArchiveTileEntity tile) {
        tile.oRot = tile.rot;
        Player player = level.m_45924_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 3.0, false);
        if (player != null) {
            double d0 = player.m_20185_() - ((double)pos.m_123341_() + 0.6);
            double d1 = player.m_20189_() - ((double)pos.m_123343_() + 0.4);
            tile.tRot = (float)Mth.m_14136_((double)d1, (double)d0);
            if (bookRand.nextInt(40) == 0) {
                float f1 = tile.flipT;
                do {
                    tile.flipT += (float)(bookRand.nextInt(4) - bookRand.nextInt(4));
                } while (f1 == tile.flipT);
            }
        } else {
            tile.tRot += 0.02f;
        }
        while ((double)tile.rot >= Math.PI) {
            tile.rot = (float)((double)tile.rot - Math.PI * 2);
        }
        while ((double)tile.rot < -Math.PI) {
            tile.rot = (float)((double)tile.rot + Math.PI * 2);
        }
        while ((double)tile.tRot >= Math.PI) {
            tile.tRot = (float)((double)tile.tRot - Math.PI * 2);
        }
        while ((double)tile.tRot < -Math.PI) {
            tile.tRot = (float)((double)tile.tRot + Math.PI * 2);
        }
        float f2 = tile.tRot - tile.rot;
        while ((double)f2 >= Math.PI) {
            f2 = (float)((double)f2 - Math.PI * 2);
        }
        while ((double)f2 < -Math.PI) {
            f2 = (float)((double)f2 + Math.PI * 2);
        }
        tile.rot += f2 * 0.4f;
        ++tile.time;
        tile.oFlip = tile.flip;
        float f = (tile.flipT - tile.flip) * 0.4f;
        f = Mth.m_14036_((float)f, (float)-0.2f, (float)0.2f);
        tile.flipA += (f - tile.flipA) * 0.9f;
        tile.flip += tile.flipA;
        if (bookRand.nextInt(5) != 0) {
            return;
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.6, (double)(pos.m_123342_() + 2), (double)pos.m_123343_() + 0.4, (double)(-1.0f + bookRand.nextFloat()) + 0.5, -1.0, (double)(-1.0f + bookRand.nextFloat()) + 0.5);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.usedPlayers = NBTHelper.readSet(tag, "players", StringTag.class, strTag -> UUID.fromString(strTag.m_7916_()));
        if (tag.m_128441_("playerEffects")) {
            this.playerEffects = NBTHelper.readMap(tag, "playerEffects", ListTag.class, AlchemyArchiveTileEntity::readEffects);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        NBTHelper.writeCollection(tag, "players", this.usedPlayers, StringTag.class, uuid -> StringTag.m_129297_((String)uuid.toString()));
        NBTHelper.writeMap(tag, "playerEffects", this.playerEffects, ListTag.class, AlchemyArchiveTileEntity::writeEffects);
    }

    public static List<String> readEffects(ListTag effectsTag) {
        return effectsTag.stream().map(Tag::m_7916_).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public static ListTag writeEffects(List<String> effects) {
        return effects.stream().map(StringTag::m_129297_).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll);
    }

    public boolean stillValid(Player player) {
        return this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) == this && !this.usedPlayers.contains(player.m_142081_());
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new AlchemyArchiveContainer(id, this.m_58904_(), this.m_58899_(), player, this.playerEffects.get(player.m_142081_()));
    }

    public void initPlayerEffects(Player player) {
        if (this.playerEffects.containsKey(player.m_142081_())) {
            return;
        }
        Level level = this.m_58904_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        DiscoveredAlchemyEffectsData discoveredEffectsData = DiscoveredAlchemyEffectsData.get(serverLevel);
        List<String> undiscoveredEffects = ModConfigs.VAULT_ALCHEMY_TABLE.getCraftableEffects().stream().filter(effectCfg -> effectCfg.getUnlockCategory() == AlchemyTableConfig.UnlockCategory.VAULT_DISCOVERY && !discoveredEffectsData.hasDiscoveredEffect(player, effectCfg.getEffectId())).map(AlchemyTableConfig.CraftableEffectConfig::getEffectId).toList();
        if (undiscoveredEffects.size() <= 3) {
            this.playerEffects.put(player.m_142081_(), undiscoveredEffects);
        } else {
            HashSet<Integer> selectedIndices = new HashSet<Integer>();
            while (selectedIndices.size() < 3) {
                int randomIndex = this.m_58904_().m_5822_().nextInt(undiscoveredEffects.size());
                if (selectedIndices.contains(randomIndex)) continue;
                selectedIndices.add(randomIndex);
                String randomElement = undiscoveredEffects.get(randomIndex);
                this.playerEffects.computeIfAbsent(player.m_142081_(), uuid -> new ArrayList()).add(randomElement);
            }
        }
        this.m_6596_();
    }

    public void use(ServerPlayer player) {
        this.initPlayerEffects((Player)player);
        List<String> effects = this.playerEffects.get(player.m_142081_());
        if (effects.isEmpty()) {
            player.m_6352_((Component)new TextComponent("No effects left to discover").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return;
        }
        if (effects.size() == 1) {
            this.discoverEffect(player, effects.get(0));
            return;
        }
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)this, buffer -> {
            buffer.m_130064_(this.m_58899_());
            CompoundTag effectTag = new CompoundTag();
            effectTag.m_128365_("effects", (Tag)AlchemyArchiveTileEntity.writeEffects(effects));
            buffer.m_130079_(effectTag);
        });
    }

    public void discoverEffect(ServerPlayer player, String effectId) {
        this.setUsedByPlayer((Player)player);
        DiscoveredAlchemyEffectsData discoveredEffectsData = DiscoveredAlchemyEffectsData.get(player.m_183503_());
        if (!discoveredEffectsData.compoundDiscoverEffect(player, effectId)) {
            return;
        }
        AlchemyTableConfig cfg = ModConfigs.VAULT_ALCHEMY_TABLE;
        AlchemyTableConfig.CraftableEffectConfig effectCfg = cfg.getConfig(effectId);
        if (effectCfg == null) {
            return;
        }
        ItemStack stack = BottleItem.create(null, null);
        MutableComponent cmp = new TextComponent("").m_7220_(player.m_5446_()).m_130946_(" discovered the ").m_7220_(stack.m_41786_()).m_130946_(" effect: ").m_130946_(effectCfg.getEffectName());
        MiscUtils.broadcast((Component)cmp);
    }
}

