/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.VaultArtifactBlock;
import iskallia.vault.client.particles.ArtifactProjectorParticleOptions;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModParticles;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.ClientboundTESyncMessage;
import iskallia.vault.world.data.PlayerGreedData;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ArtifactProjectorTileEntity
extends BlockEntity {
    private static final Random RANDOM = new Random();
    private UUID owner;
    public int ticksToConsume = 80;
    public boolean consuming = false;
    public boolean completed = false;
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    public float tRot;

    public ArtifactProjectorTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModBlocks.ARTIFACT_PROJECTOR_ENTITY, pWorldPosition, pBlockState);
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82400_(6.0);
    }

    public void consume(Player pPlayer) {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sWorld = (ServerLevel)level;
        if (!pPlayer.m_142081_().toString().equals(this.getOwner().toString())) {
            return;
        }
        BlockState state = sWorld.m_8055_(this.f_58858_.m_6630_(3));
        if (!this.completed) {
            if (!state.m_61138_((Property)VaultArtifactBlock.ORDER_PROPERTY)) {
                return;
            }
            if (!state.m_61138_((Property)HorizontalDirectionalBlock.f_54117_) || state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) != this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)) {
                return;
            }
            List<BlockPos> validPositions = VaultArtifactBlock.isValidArtifactSetup(sWorld, this.f_58858_.m_6630_(3), sWorld.m_8055_(this.f_58858_.m_6630_(3)));
            if (!validPositions.isEmpty()) {
                validPositions.forEach(at -> sWorld.m_7471_(at, false));
                PlayerGreedData.get().onArtifactCompleted(pPlayer.m_142081_());
                this.completed = true;
                this.consuming = true;
                this.ticksToConsume = 80;
                CompoundTag saveTag = new CompoundTag();
                this.m_183515_(saveTag);
                ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundTESyncMessage(this.f_58858_, saveTag));
                sWorld.m_5594_(null, this.f_58858_.m_6630_(3), ModSounds.ARTIFACT_COMPLETE, SoundSource.BLOCKS, 1.0f, 0.6f);
            }
        } else {
            PlayerGreedData.get().onArtifactCompleted(pPlayer.m_142081_());
            this.consuming = true;
            this.ticksToConsume = 80;
            CompoundTag saveTag = new CompoundTag();
            this.m_183515_(saveTag);
            ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundTESyncMessage(this.f_58858_, saveTag));
            sWorld.m_5594_(null, this.f_58858_.m_6630_(3), ModSounds.ARTIFACT_COMPLETE, SoundSource.BLOCKS, 1.0f, 0.6f);
        }
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.owner = tag.m_128342_("owner");
        this.ticksToConsume = tag.m_128451_("ticksToConsume");
        this.consuming = tag.m_128471_("consuming");
        this.completed = tag.m_128471_("completed");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128362_("owner", this.owner);
        tag.m_128405_("ticksToConsume", this.ticksToConsume);
        tag.m_128379_("consuming", this.consuming);
        tag.m_128379_("completed", this.completed);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public static void tickClient(Level world, BlockPos pos, BlockState state, ArtifactProjectorTileEntity tile) {
        float f2;
        if (tile.consuming) {
            --tile.ticksToConsume;
            if (tile.ticksToConsume >= 40) {
                Random rand = new Random();
                for (int i = 0; i < 5; ++i) {
                    world.m_6493_((ParticleOptions)new ArtifactProjectorParticleOptions((ParticleType<ArtifactProjectorParticleOptions>)((ParticleType)ModParticles.ARTIFACT_PROJECTOR.get()), 40, ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_()), true, (double)pos.m_6630_(3).m_123341_() + 0.5, (double)pos.m_6630_(3).m_123342_() + 0.5, (double)pos.m_6630_(3).m_123343_() + 0.5, (double)(rand.nextFloat() * 3.0f), (double)rand.nextInt(360), (double)(rand.nextFloat() + 0.5f));
                }
            }
            if (tile.ticksToConsume <= 0) {
                tile.consuming = false;
            }
        }
        tile.oOpen = tile.open;
        tile.oRot = tile.rot;
        Player player = world.m_45924_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 6.0, false);
        if (player != null) {
            double d0 = player.m_20185_() - ((double)pos.m_123341_() + 0.5);
            double d1 = player.m_20189_() - ((double)pos.m_123343_() + 0.5);
            tile.tRot = (float)Mth.m_14136_((double)d1, (double)d0);
            tile.open += 0.1f;
            if (tile.open < 0.5f || RANDOM.nextInt(40) == 0) {
                float f1 = tile.flipT;
                do {
                    tile.flipT += (float)(RANDOM.nextInt(4) - RANDOM.nextInt(4));
                } while (f1 == tile.flipT);
            }
        } else {
            tile.tRot += 0.02f;
            tile.open -= 0.1f;
        }
        while (tile.rot >= (float)Math.PI) {
            tile.rot -= (float)Math.PI * 2;
        }
        while (tile.rot < (float)(-Math.PI)) {
            tile.rot += (float)Math.PI * 2;
        }
        while (tile.tRot >= (float)Math.PI) {
            tile.tRot -= (float)Math.PI * 2;
        }
        while (tile.tRot < (float)(-Math.PI)) {
            tile.tRot += (float)Math.PI * 2;
        }
        for (f2 = tile.tRot - tile.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        tile.rot += f2 * 0.4f;
        tile.open = Mth.m_14036_((float)tile.open, (float)0.0f, (float)1.1f);
        ++tile.time;
        tile.oFlip = tile.flip;
        float f = (tile.flipT - tile.flip) * 0.4f;
        float f3 = 0.2f;
        f = Mth.m_14036_((float)f, (float)-0.2f, (float)0.2f);
        tile.flipA += (f - tile.flipA) * 0.9f;
        tile.flip += tile.flipA;
    }

    public static void tickServer(Level sWorld, BlockPos pPos, BlockState state, ArtifactProjectorTileEntity tile) {
        if (tile.consuming) {
            --tile.ticksToConsume;
            if (tile.ticksToConsume <= 0) {
                ItemStack seal = new ItemStack((ItemLike)ModItems.CRYSTAL_SEAL_HERALD);
                if (!sWorld.f_46443_ && sWorld.m_46469_().m_46207_(GameRules.f_46136_) && !sWorld.restoringBlockSnapshots) {
                    BlockPos pos = pPos.m_6630_(3);
                    ItemEntity itementity = new ItemEntity(sWorld, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), seal);
                    itementity.m_20256_(new Vec3(0.0, 0.0, 0.0));
                    itementity.m_32060_();
                    sWorld.m_7967_((Entity)itementity);
                }
                sWorld.m_5594_(null, tile.f_58858_.m_6630_(3), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.6f, 0.9f);
                tile.consuming = false;
            }
        }
    }
}

