/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.BlackMarketBlock;
import iskallia.vault.client.ClientShardTradeData;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModParticles;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class BlackMarketTileEntity
extends BlockEntity {
    public BlackMarketTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.BLACK_MARKET_TILE_ENTITY, pos, state);
    }

    public static Vec3 getPointOnRectangleEdge(Vec3 center, double width, double height) {
        double halfWidth = width / 2.0;
        double halfHeight = height / 2.0;
        double angle = Math.PI * 2 * Math.random();
        double x = center.f_82479_ + halfWidth * Math.cos(angle);
        double y = center.f_82480_;
        double z = center.f_82481_ + halfHeight * Math.sin(angle);
        return new Vec3(x, y, z);
    }

    public static float[] interpolateColor(float r1, float g1, float b1, float r2, float g2, float b2, float t) {
        float[] interpolatedColor = new float[]{BlackMarketTileEntity.interpolateComponent(r1, r2, t), BlackMarketTileEntity.interpolateComponent(g1, g2, t), BlackMarketTileEntity.interpolateComponent(b1, b2, t)};
        return interpolatedColor;
    }

    public static float interpolateComponent(float c1, float c2, float t) {
        return c1 + (c2 - c1) * t;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlackMarketTileEntity tile) {
        if (level.f_46443_ && ClientShardTradeData.getAvailableTrades().containsKey(1)) {
            Random random = new Random();
            Direction dir = (Direction)state.m_61143_((Property)BlackMarketBlock.f_54117_);
            int rot = 0;
            if (dir == Direction.WEST) {
                rot = 90;
            }
            if (dir == Direction.SOUTH) {
                rot = 180;
            }
            if (dir == Direction.EAST) {
                rot = 270;
            }
            Vec3 offset = new Vec3(0.0, 0.0, (double)0.12f).m_82524_((float)Math.toRadians(rot));
            Vec3 offset2 = BlackMarketTileEntity.getPointOnRectangleEdge(offset, 0.35f, 0.35f);
            ParticleEngine pm = Minecraft.m_91087_().f_91061_;
            Particle particle = pm.m_107370_((ParticleOptions)ModParticles.ENDER_ANCHOR.get(), (double)((float)pos.m_123341_() + 0.5f) + offset.f_82479_ + offset2.f_82479_, (double)((float)pos.m_123342_() + 0.65f) + offset.f_82480_ + offset2.f_82480_, (double)((float)pos.m_123343_() + 0.5f) + offset.f_82481_ + offset2.f_82481_, 0.0, (double)Mth.m_144924_((Random)random, (float)0.001f, (float)0.02f), 0.0);
            if (particle != null) {
                float[] colors = BlackMarketTileEntity.interpolateColor(0.16796875f, 0.04296875f, 0.359375f, 0.51171875f, 0.08984375f, 0.80078125f, random.nextFloat());
                particle.m_107253_(colors[0], colors[1], colors[2]);
                particle.m_6569_(0.35f);
            }
        }
    }
}

