/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.BaseSpawnerTileEntity;
import iskallia.vault.config.CustomEntitySpawnerConfig;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.data.ServerVaults;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CustomEntitySpawnerTileEntity
extends BaseSpawnerTileEntity {
    private static final int MAX_PLAYER_CHECK_COOOLDOWN = 10;
    @Nullable
    private CustomEntitySpawnerConfig.SpawnerGroup spawnerGroup;
    private String spawnerGroupName;
    private int playerCheckCooldown = 0;
    private long lastCheckTime = -1L;

    public CustomEntitySpawnerTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.CUSTOM_ENTITY_SPAWNER_TILE_ENTITY, pos, state);
    }

    public static void tick(Level level, BlockPos blockPos, CustomEntitySpawnerTileEntity te) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        te.initSpawnerGroup();
        if (te.spawnerGroup == null) {
            VaultMod.LOGGER.warn("Custom Entity Spawner failed to spawn as there was no valid spawn group found in config");
            level.m_7471_(blockPos, false);
            return;
        }
        if (te.lastCheckTime + (long)te.playerCheckCooldown > level.m_46467_()) {
            return;
        }
        te.lastCheckTime = level.m_46467_();
        Player player = level.m_45924_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 100.0, true);
        if (player == null) {
            return;
        }
        double distSqr = player.m_20275_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
        CustomEntitySpawnerConfig.SpawnerGroup spawnerGroup = te.spawnerGroup;
        if ((double)(spawnerGroup.blockCheckRadius * spawnerGroup.blockCheckRadius) < distSqr) {
            return;
        }
        CustomEntitySpawnerTileEntity.spawnEntity(level, blockPos, serverLevel, spawnerGroup);
        level.m_7471_(blockPos, false);
    }

    private static void spawnEntity(Level level, BlockPos blockPos, ServerLevel serverLevel, CustomEntitySpawnerConfig.SpawnerGroup spawnerGroup) {
        CustomEntitySpawnerConfig.SpawnerEntity spawnerEntity = spawnerGroup.entities.getRandom(level.f_46441_);
        if (spawnerEntity == null) {
            VaultMod.LOGGER.warn("Custom Entity Spawner failed to spawn as there was no valid entity found in config for spawn group with minLevel {}", (Object)spawnerGroup.minLevel);
        } else {
            Entity entity = CustomEntitySpawnerTileEntity.spawnEntity(blockPos, serverLevel, spawnerEntity.type, spawnerEntity.nbt, false, () -> VaultMod.LOGGER.warn("Custom Entity Spawner failed to spawn \"{}\" as it does not exist in entityType registry", (Object)spawnerEntity.type));
            if (entity != null && spawnerEntity.randomMotion) {
                float pitch = (float)((double)level.f_46441_.nextFloat() * Math.PI * 2.0);
                float yaw = (float)((double)level.f_46441_.nextFloat() * Math.PI * 2.0);
                float xBaseMotion = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                float yBaseMotion = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
                float zBaseMotion = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
                float velocity = level.f_46441_.nextFloat() * 2.0f;
                Vec3 deltaMovement = new Vec3((double)xBaseMotion, (double)yBaseMotion, (double)zBaseMotion).m_82541_().m_82490_((double)velocity);
                entity.m_20256_(deltaMovement);
                if (entity instanceof AbstractHurtingProjectile) {
                    AbstractHurtingProjectile projectile = (AbstractHurtingProjectile)entity;
                    projectile.f_36813_ = deltaMovement.m_7096_();
                    projectile.f_36814_ = deltaMovement.m_7098_();
                    projectile.f_36815_ = deltaMovement.m_7094_();
                }
            }
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("spawnerGroupName", this.spawnerGroupName);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.spawnerGroupName = tag.m_128461_("spawnerGroupName");
    }

    private void initSpawnerGroup() {
        if (this.spawnerGroup == null) {
            int vaultLevel = ServerVaults.get(this.f_58857_).map(vault -> vault.get(Vault.LEVEL).get()).orElse(0);
            List<CustomEntitySpawnerConfig.SpawnerGroup> spawnerGroups = ModConfigs.CUSTOM_ENTITY_SPAWNER.spawnerGroups.get(this.spawnerGroupName);
            if (spawnerGroups == null) {
                return;
            }
            for (CustomEntitySpawnerConfig.SpawnerGroup sg : spawnerGroups) {
                if (sg.minLevel > vaultLevel || this.spawnerGroup != null && sg.minLevel <= this.spawnerGroup.minLevel) continue;
                this.spawnerGroup = sg;
            }
            if (this.spawnerGroup != null) {
                this.playerCheckCooldown = Math.min(this.spawnerGroup.blockCheckRadius / 4, 10);
            }
        }
    }

    public void setRandomSpawn() {
        String[] spawnerGroupNames = ModConfigs.CUSTOM_ENTITY_SPAWNER.spawnerGroups.keySet().toArray(new String[0]);
        this.spawnerGroupName = spawnerGroupNames[this.f_58857_.f_46441_.nextInt(spawnerGroupNames.length)];
        VaultMod.LOGGER.info("Placed Custom Entity Spawner had \"{}\" spawn group set", (Object)this.spawnerGroupName);
    }
}

