/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.math.Vector3f;
import iskallia.vault.block.DivineAltarBlock;
import iskallia.vault.block.entity.ScavengerAltarTileEntity;
import iskallia.vault.client.particles.AltarParticleOptions;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModParticles;
import iskallia.vault.network.message.DivineAltarConsumeMessage;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class DivineAltarTileEntity
extends ScavengerAltarTileEntity {
    protected DivineAltarTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.ticksToConsume = 40;
        this.consuming = false;
    }

    public DivineAltarTileEntity(BlockPos pos, BlockState state) {
        this(ModBlocks.DIVINE_ALTAR_TILE_ENTITY, pos, state);
    }

    public static void tickClient(Level world, BlockPos pos, BlockState state, DivineAltarTileEntity tile) {
        ScavengerAltarTileEntity.tickClient(world, pos, state, tile);
    }

    public static void tickServer(Level world, BlockPos pos, BlockState state, DivineAltarTileEntity tile) {
        ScavengerAltarTileEntity.tickServer(world, pos, state, tile);
    }

    @Override
    public void sendConsumeParticleMessage() {
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new DivineAltarConsumeMessage(this.m_58899_(), ((VaultGod)((Object)this.m_58900_().m_61143_(DivineAltarBlock.GOD))).getColor()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnConsumeParticles(BlockPos pos, int col) {
        Vec3 offset;
        Random random;
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        float r = (float)(col >> 16 & 0xFF) / 255.0f;
        float g = (float)(col >> 8 & 0xFF) / 255.0f;
        float b = (float)(col & 0xFF) / 255.0f;
        for (i = 0; i < 40; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)new AltarParticleOptions((ParticleType<AltarParticleOptions>)((ParticleType)ModParticles.DIVINE_ALTAR_CONSUME.get()), new Vector3f(r, g, b)), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + 0.25, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 2.0, random.nextDouble() * 0.1 + 0.1, offset.f_82481_ / 2.0);
        }
        for (i = 0; i < 30; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)new AltarParticleOptions((ParticleType<AltarParticleOptions>)((ParticleType)ModParticles.DIVINE_ALTAR_CONSUME.get()), new Vector3f(r, g, b)), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_7494_().m_123342_() + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 20.0, random.nextDouble() * 0.2 + 0.2, offset.f_82481_ / 20.0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void playEffects(Level level) {
        int particleSpeed;
        if (!level.f_46443_) {
            return;
        }
        BlockPos pos = this.m_58899_().m_7494_();
        Vec3 vec3 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        int n = particleSpeed = this.consuming && (float)this.ticksToConsume > 32.0f ? 5 : 40;
        if (this.m_58900_().m_61138_(DivineAltarBlock.GOD)) {
            int col = ((VaultGod)((Object)this.m_58900_().m_61143_(DivineAltarBlock.GOD))).getColor();
            float r = (float)(col >> 16 & 0xFF) / 255.0f;
            float g = (float)(col >> 8 & 0xFF) / 255.0f;
            float b = (float)(col & 0xFF) / 255.0f;
            for (BlockPos blockpos : list) {
                float f2;
                float f1;
                float f;
                if (rand.nextInt(particleSpeed) == 0) {
                    f = -0.5f + rand.nextFloat() + (float)blockpos.m_7494_().m_123341_();
                    f1 = -2.0f + rand.nextFloat() + (float)blockpos.m_7494_().m_123342_() + 0.75f;
                    f2 = -0.5f + rand.nextFloat() + (float)blockpos.m_7494_().m_123343_();
                    level.m_7106_((ParticleOptions)new AltarParticleOptions((ParticleType<AltarParticleOptions>)((ParticleType)ModParticles.DIVINE_ALTAR.get()), new Vector3f(r, g, b)), vec3.f_82479_, vec3.f_82480_ + 0.25, vec3.f_82481_, (double)f, (double)f1 + 0.5, (double)f2);
                }
                if (rand.nextInt(particleSpeed) == 0) {
                    f = -0.5f + rand.nextFloat() + (float)blockpos.m_7494_().m_7494_().m_123341_();
                    f1 = -2.0f + rand.nextFloat() + (float)blockpos.m_7494_().m_7494_().m_123342_();
                    f2 = -0.5f + rand.nextFloat() + (float)blockpos.m_7494_().m_7494_().m_123343_();
                    level.m_7106_((ParticleOptions)new AltarParticleOptions((ParticleType<AltarParticleOptions>)((ParticleType)ModParticles.DIVINE_ALTAR.get()), new Vector3f(r, g, b)), vec3.f_82479_, vec3.f_82480_ + 0.25, vec3.f_82481_, (double)f, (double)f1 + 0.5, (double)f2);
                }
                if (rand.nextInt(particleSpeed) != 0) continue;
                f = -0.5f + rand.nextFloat() + (float)blockpos.m_7494_().m_7494_().m_7494_().m_123341_();
                f1 = -2.0f + rand.nextFloat() + (float)blockpos.m_7494_().m_7494_().m_7494_().m_123342_() - 0.75f;
                f2 = -0.5f + rand.nextFloat() + (float)blockpos.m_7494_().m_7494_().m_7494_().m_123343_();
                level.m_7106_((ParticleOptions)new AltarParticleOptions((ParticleType<AltarParticleOptions>)((ParticleType)ModParticles.DIVINE_ALTAR.get()), new Vector3f(r, g, b)), vec3.f_82479_, vec3.f_82480_ + 0.25, vec3.f_82481_, (double)f, (double)f1 + 0.5, (double)f2);
            }
        }
    }
}

