/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.block.entity.TreasureDoorTileEntity;
import iskallia.vault.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class DungeonDoorTileEntity
extends TreasureDoorTileEntity {
    private Difficulty difficulty;

    public DungeonDoorTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.DUNGEON_DOOR_TILE_ENTITY, pos, state);
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_("Difficulty", 10)) {
            this.difficulty = Difficulty.fromNBT(nbt.m_128469_("Difficulty"));
        }
    }

    @Override
    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.difficulty != null) {
            nbt.m_128365_("Difficulty", (Tag)this.difficulty.toNBT());
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DungeonDoorTileEntity tile) {
        TreasureDoorTileEntity.tick(level, pos, state, tile);
    }

    public static class Difficulty {
        public String name;
        public int color;

        public Difficulty(String name, int color) {
            this.name = name;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public int getColor() {
            return this.color;
        }

        public CompoundTag toNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("Name", this.name);
            nbt.m_128405_("Color", this.color);
            return nbt;
        }

        public static Difficulty fromNBT(CompoundTag nbt) {
            return new Difficulty(nbt.m_128461_("Name"), nbt.m_128451_("Color"));
        }

        public Component getDisplay() {
            return new TextComponent("Difficulty: %s".formatted(this.getName())).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)this.getColor())));
        }
    }
}

