/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.entity.entity.EtchingVendorEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModEntities;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class EtchingVendorControllerTileEntity
extends BlockEntity {
    private int monitoredEntityId = -1;
    private final List<EtchingTrade> trades = new ArrayList<EtchingTrade>();

    public EtchingVendorControllerTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.ETCHING_CONTROLLER_TILE_ENTITY, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EtchingVendorControllerTileEntity tile) {
        Entity monitoredEntity;
        if (level.m_5776_()) {
            return;
        }
        if (tile.trades.isEmpty()) {
            tile.sendUpdates();
        }
        if (tile.monitoredEntityId == -1) {
            monitoredEntity = tile.createVendor();
        } else {
            monitoredEntity = level.m_6815_(tile.monitoredEntityId);
            if (monitoredEntity == null) {
                monitoredEntity = tile.createVendor();
            }
        }
        monitoredEntity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
    }

    private Entity createVendor() {
        ServerLevel sWorld = (ServerLevel)this.m_58904_();
        EtchingVendorEntity vendor = (EtchingVendorEntity)ModEntities.ETCHING_VENDOR.m_20655_(sWorld, null, null, null, this.m_58899_(), MobSpawnType.STRUCTURE, false, false);
        vendor.setVendorPos(this.m_58899_());
        sWorld.m_7967_((Entity)vendor);
        this.monitoredEntityId = vendor.m_142049_();
        return vendor;
    }

    public int getMonitoredEntityId() {
        return this.monitoredEntityId;
    }

    public void setMonitoredEntityId(int id) {
        if (this.monitoredEntityId == -1) {
            this.monitoredEntityId = id;
        }
    }

    @Nullable
    public EtchingTrade getTrade(int id) {
        if (id < 0 || id >= this.trades.size()) {
            return null;
        }
        return this.trades.get(id);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        ListTag trades = nbt.m_128437_("trades", 10);
        for (int i = 0; i < trades.size(); ++i) {
            CompoundTag tradeTag = trades.m_128728_(i);
            this.trades.add(EtchingTrade.deserialize(tradeTag));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        ListTag trades = new ListTag();
        for (EtchingTrade trade : this.trades) {
            trades.add((Object)trade.serialize());
        }
        pTag.m_128365_("trades", (Tag)trades);
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void sendUpdates() {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 11);
        this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        this.m_6596_();
    }

    public static class EtchingTrade {
        private final ItemStack soldEtching;
        private final int requiredPlatinum;
        private boolean sold;

        public EtchingTrade(ItemStack soldEtching, int requiredPlatinum, boolean sold) {
            this.soldEtching = soldEtching;
            this.requiredPlatinum = requiredPlatinum;
            this.sold = sold;
        }

        public ItemStack getSoldEtching() {
            return this.soldEtching;
        }

        public int getRequiredPlatinum() {
            return this.requiredPlatinum;
        }

        public void setSold(boolean sold) {
            this.sold = sold;
        }

        public boolean isSold() {
            return this.sold;
        }

        public CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("stack", (Tag)this.soldEtching.serializeNBT());
            nbt.m_128405_("amount", this.requiredPlatinum);
            nbt.m_128379_("sold", this.sold);
            return nbt;
        }

        public static EtchingTrade deserialize(CompoundTag nbt) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("stack"));
            int amount = nbt.m_128451_("amount");
            boolean sold = nbt.m_128471_("sold");
            return new EtchingTrade(stack, amount, sold);
        }
    }
}

