/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class HourglassTileEntity
extends BlockEntity {
    private UUID ownerUUID;
    private String ownerPlayerName = "Unknown";
    private int currentSand = 0;
    private int totalSand = -1;

    public HourglassTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.HOURGLASS_TILE_ENTITY, pos, state);
    }

    public void setOwner(@Nonnull UUID ownerUUID, @Nonnull String playerName) {
        this.ownerUUID = ownerUUID;
        this.ownerPlayerName = playerName;
    }

    @Nonnull
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Nonnull
    public String getOwnerPlayerName() {
        return this.ownerPlayerName;
    }

    public void setTotalSand(int totalSand) {
        this.totalSand = totalSand;
        if (this.totalSand != this.totalSand) {
            this.markForUpdate();
        }
    }

    public boolean addSand(Player player, int amount) {
        int total;
        int n = total = this.totalSand <= 0 ? ModConfigs.SAND_EVENT.getTotalSandRequired(player) : this.totalSand;
        if (this.currentSand >= total) {
            return false;
        }
        if (this.ownerUUID != null && !player.m_142081_().equals(this.getOwnerUUID())) {
            return false;
        }
        this.currentSand += amount;
        this.markForUpdate();
        return true;
    }

    public float getFilledPercentage() {
        return Mth.m_14036_((float)((float)this.currentSand / (float)this.totalSand), (float)0.0f, (float)1.0f);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (this.ownerUUID != null) {
            pTag.m_128362_("ownerUUID", this.ownerUUID);
        }
        pTag.m_128359_("ownerPlayerName", this.ownerPlayerName);
        pTag.m_128405_("currentSand", this.currentSand);
        pTag.m_128405_("totalSand", this.totalSand);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.ownerUUID = pTag.m_128425_("ownerUUID", 11) ? pTag.m_128342_("ownerUUID") : null;
        this.ownerPlayerName = pTag.m_128461_("ownerPlayerName");
        this.currentSand = pTag.m_128451_("currentSand");
        this.totalSand = pTag.m_128451_("totalSand");
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void markForUpdate() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
            this.m_6596_();
        }
    }
}

