/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.config.gear.VaultGearWorkbenchConfig;
import iskallia.vault.container.ModifierDiscoveryContainer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.gear.IdolItem;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.data.DiscoveredWorkbenchModifiersData;
import iskallia.vault.world.data.ServerVaults;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ModifierDiscoveryTileEntity
extends BlockEntity
implements MenuProvider {
    private static final int NUMBER_OF_MODIFIERS_TO_CHOOSE_FROM = 3;
    private Set<UUID> usedPlayers = new HashSet<UUID>();
    private Map<UUID, List<Tuple<Item, ResourceLocation>>> playerGearModifiers = new HashMap<UUID, List<Tuple<Item, ResourceLocation>>>();
    private static final Random bookRand = new Random();
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float rot;
    public float oRot;
    public float tRot;

    public ModifierDiscoveryTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.MODIFIER_DISCOVERY_ENTITY, pos, state);
    }

    public Set<UUID> getUsedPlayers() {
        return this.usedPlayers;
    }

    public boolean setUsedByPlayer(Player player) {
        if (this.usedPlayers.add(player.m_142081_())) {
            this.m_6596_();
            return true;
        }
        return false;
    }

    public boolean canBeUsed(Player player) {
        return !this.getUsedPlayers().contains(player.m_142081_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientBookTick(Level level, BlockPos pos, BlockState state, ModifierDiscoveryTileEntity tile) {
        tile.oRot = tile.rot;
        Player player = level.m_45924_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 3.0, false);
        if (player != null) {
            double d0 = player.m_20185_() - ((double)pos.m_123341_() + 0.5);
            double d1 = player.m_20189_() - ((double)pos.m_123343_() + 0.5);
            tile.tRot = (float)Mth.m_14136_((double)d1, (double)d0);
            if (bookRand.nextInt(40) == 0) {
                float f1 = tile.flipT;
                do {
                    tile.flipT += (float)(bookRand.nextInt(4) - bookRand.nextInt(4));
                } while (f1 == tile.flipT);
            }
        } else {
            tile.tRot += 0.02f;
        }
        while ((double)tile.rot >= Math.PI) {
            tile.rot = (float)((double)tile.rot - Math.PI * 2);
        }
        while ((double)tile.rot < -Math.PI) {
            tile.rot = (float)((double)tile.rot + Math.PI * 2);
        }
        while ((double)tile.tRot >= Math.PI) {
            tile.tRot = (float)((double)tile.tRot - Math.PI * 2);
        }
        while ((double)tile.tRot < -Math.PI) {
            tile.tRot = (float)((double)tile.tRot + Math.PI * 2);
        }
        float f2 = tile.tRot - tile.rot;
        while ((double)f2 >= Math.PI) {
            f2 = (float)((double)f2 - Math.PI * 2);
        }
        while ((double)f2 < -Math.PI) {
            f2 = (float)((double)f2 + Math.PI * 2);
        }
        tile.rot += f2 * 0.4f;
        ++tile.time;
        tile.oFlip = tile.flip;
        float f = (tile.flipT - tile.flip) * 0.4f;
        f = Mth.m_14036_((float)f, (float)-0.2f, (float)0.2f);
        tile.flipA += (f - tile.flipA) * 0.9f;
        tile.flip += tile.flipA;
        if (bookRand.nextInt(5) != 0) {
            return;
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 2), (double)pos.m_123343_() + 0.5, (double)(-1.0f + bookRand.nextFloat()) + 0.5, -1.0, (double)(-1.0f + bookRand.nextFloat()) + 0.5);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.usedPlayers = NBTHelper.readSet(tag, "players", StringTag.class, strTag -> UUID.fromString(strTag.m_7916_()));
        if (tag.m_128441_("playerGearModifiers")) {
            this.playerGearModifiers = NBTHelper.readMap(tag, "playerGearModifiers", ListTag.class, ModifierDiscoveryTileEntity::readGearModifiers);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        NBTHelper.writeCollection(tag, "players", this.usedPlayers, StringTag.class, uuid -> StringTag.m_129297_((String)uuid.toString()));
        NBTHelper.writeMap(tag, "playerGearModifiers", this.playerGearModifiers, ListTag.class, ModifierDiscoveryTileEntity::writeGearModifiers);
    }

    public static List<Tuple<Item, ResourceLocation>> readGearModifiers(ListTag gearModifiersTag) {
        return gearModifiersTag.stream().map(tag -> {
            CompoundTag compoundTag;
            String itemRegistryName;
            Item item;
            if (tag instanceof CompoundTag && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemRegistryName = (compoundTag = (CompoundTag)tag).m_128461_("item")))) != null) {
                ResourceLocation modifier = new ResourceLocation(compoundTag.m_128461_("modifier"));
                return Optional.of(new Tuple((Object)item, (Object)modifier));
            }
            return Optional.empty();
        }).filter(Optional::isPresent).map(Optional::get).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public static ListTag writeGearModifiers(List<Tuple<Item, ResourceLocation>> gearModifiers) {
        return gearModifiers.stream().map(gearModifier -> {
            CompoundTag gmNbt = new CompoundTag();
            gmNbt.m_128359_("item", ((Item)gearModifier.m_14418_()).getRegistryName().toString());
            gmNbt.m_128359_("modifier", ((ResourceLocation)gearModifier.m_14419_()).toString());
            return gmNbt;
        }).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll);
    }

    public boolean stillValid(Player player) {
        return this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) == this && !this.usedPlayers.contains(player.m_142081_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new ModifierDiscoveryContainer(id, this.m_58904_(), this.m_58899_(), player, this.playerGearModifiers.get(player.m_142081_()));
    }

    public void initPlayerGearModifiers(Player player) {
        if (this.playerGearModifiers.containsKey(player.m_142081_())) {
            return;
        }
        Level level = this.m_58904_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Map<Item, HashMap<ResourceLocation, ArrayList<ResourceLocation>>> undiscovered = ModifierDiscoveryTileEntity.getUndiscoveredGearModifiers(player, serverLevel);
        int combinations = 0;
        for (Map.Entry<Item, HashMap<ResourceLocation, ArrayList<ResourceLocation>>> entry2 : undiscovered.entrySet()) {
            combinations += entry2.getValue().size();
        }
        if (combinations <= 3) {
            this.playerGearModifiers.put(player.m_142081_(), undiscovered.entrySet().stream().flatMap(entry -> ((HashMap)entry.getValue()).values().stream().flatMap(innerEntry -> innerEntry.stream().map(modifier -> new Tuple((Object)((Item)entry.getKey()), modifier)))).toList());
            return;
        }
        this.selectRandomModifiers(player, combinations, undiscovered);
        this.m_6596_();
    }

    private void selectRandomModifiers(Player player, int combinations, Map<Item, HashMap<ResourceLocation, ArrayList<ResourceLocation>>> undiscovered) {
        HashSet<Integer> selectedIndices = new HashSet<Integer>();
        while (selectedIndices.size() < 3) {
            int randomIndex = this.m_58904_().m_5822_().nextInt(combinations);
            if (selectedIndices.contains(randomIndex)) continue;
            selectedIndices.add(randomIndex);
            this.addGearModifierAtIndex(player, undiscovered, randomIndex);
        }
    }

    private void addGearModifierAtIndex(Player player, Map<Item, HashMap<ResourceLocation, ArrayList<ResourceLocation>>> undiscovered, int randomIndex) {
        int currentIndex = 0;
        for (Map.Entry<Item, HashMap<ResourceLocation, ArrayList<ResourceLocation>>> entry : undiscovered.entrySet()) {
            for (Map.Entry<ResourceLocation, ArrayList<ResourceLocation>> innerEntry : entry.getValue().entrySet()) {
                for (ResourceLocation modifier : innerEntry.getValue()) {
                    if (currentIndex == randomIndex) {
                        this.playerGearModifiers.computeIfAbsent(player.m_142081_(), uuid -> new ArrayList()).add(new Tuple((Object)entry.getKey(), (Object)modifier));
                        return;
                    }
                    ++currentIndex;
                }
            }
        }
    }

    private static Map<Item, HashMap<ResourceLocation, ArrayList<ResourceLocation>>> getUndiscoveredGearModifiers(Player player, ServerLevel serverLevel) {
        Vault vault = ServerVaults.get((Level)serverLevel).orElse(null);
        int vaultLevel = vault.has(Vault.LEVEL) ? vault.get(Vault.LEVEL).get() : 0;
        HashMap<Item, HashMap<ResourceLocation, ArrayList<ResourceLocation>>> itemCfg = new HashMap<Item, HashMap<ResourceLocation, ArrayList<ResourceLocation>>>();
        HashSet<ResourceLocation> availableIdolCraftIds = new HashSet<ResourceLocation>();
        DiscoveredWorkbenchModifiersData discoveredModifiers = DiscoveredWorkbenchModifiersData.get(serverLevel);
        for (VaultGearWorkbenchConfig config : ModConfigs.VAULT_GEAR_WORKBENCH_CONFIG.values()) {
            Item item2 = config.getGearItem();
            for (VaultGearWorkbenchConfig.CraftableModifierConfig cfg : config.getAllCraftableModifiers()) {
                HashMap<ResourceLocation, ArrayList<ResourceLocation>> hashmap;
                ResourceLocation key;
                if (cfg.getUnlockCategory() != VaultGearWorkbenchConfig.UnlockCategory.VAULT_DISCOVERY || discoveredModifiers.hasDiscoveredCraft(player, item2, key = cfg.getWorkbenchCraftIdentifier()) || cfg.getMinLevel() > vaultLevel) continue;
                if (item2 instanceof IdolItem) {
                    availableIdolCraftIds.add(key);
                    if (itemCfg.containsKey(ModItems.IDOL_BENEVOLENT)) {
                        if (((HashMap)itemCfg.get(ModItems.IDOL_BENEVOLENT)).containsKey(cfg.getModifierIdentifier())) {
                            ((ArrayList)((HashMap)itemCfg.get(ModItems.IDOL_BENEVOLENT)).get(cfg.getModifierIdentifier())).add(cfg.getWorkbenchCraftIdentifier());
                            continue;
                        }
                        ((HashMap)itemCfg.get(ModItems.IDOL_BENEVOLENT)).put(cfg.getModifierIdentifier(), new ArrayList<ResourceLocation>(List.of(cfg.getWorkbenchCraftIdentifier())));
                        continue;
                    }
                    hashmap = new HashMap();
                    hashmap.put(cfg.getModifierIdentifier(), new ArrayList<ResourceLocation>(List.of(cfg.getWorkbenchCraftIdentifier())));
                    itemCfg.put(ModItems.IDOL_BENEVOLENT, hashmap);
                    continue;
                }
                if (itemCfg.containsKey(item2)) {
                    if (((HashMap)itemCfg.get(item2)).containsKey(cfg.getModifierIdentifier())) {
                        ((ArrayList)((HashMap)itemCfg.get(item2)).get(cfg.getModifierIdentifier())).add(cfg.getWorkbenchCraftIdentifier());
                        continue;
                    }
                    ((HashMap)itemCfg.get(item2)).put(cfg.getModifierIdentifier(), new ArrayList<ResourceLocation>(List.of(cfg.getWorkbenchCraftIdentifier())));
                    continue;
                }
                hashmap = new HashMap<ResourceLocation, ArrayList<ResourceLocation>>();
                hashmap.put(cfg.getModifierIdentifier(), new ArrayList<ResourceLocation>(List.of(cfg.getWorkbenchCraftIdentifier())));
                itemCfg.put(item2, hashmap);
            }
        }
        itemCfg.forEach((item, map) -> map.forEach((modifier, list) -> {
            int minTier = Integer.MAX_VALUE;
            ResourceLocation minValue = null;
            for (ResourceLocation id : list) {
                VaultGearWorkbenchConfig.CraftableModifierConfig cfg = ModConfigs.VAULT_GEAR_WORKBENCH_CONFIG.get(item).getConfig(id);
                if (cfg == null || cfg.getModifierTier() >= minTier) continue;
                minTier = cfg.getModifierTier();
                minValue = id;
            }
            if (minValue != null) {
                list.clear();
                list.add(minValue);
            }
        }));
        return itemCfg;
    }

    public void use(ServerPlayer player) {
        this.initPlayerGearModifiers((Player)player);
        List<Tuple<Item, ResourceLocation>> gearModifiers = this.playerGearModifiers.get(player.m_142081_());
        if (gearModifiers.isEmpty()) {
            player.m_6352_((Component)new TextComponent("No modifiers left to discover").m_130940_(ChatFormatting.RED), Util.f_137441_);
            return;
        }
        if (gearModifiers.size() == 1) {
            this.discoverGearModifier(player, gearModifiers.get(0));
            return;
        }
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)this, buffer -> {
            buffer.m_130064_(this.m_58899_());
            CompoundTag gearModifiersTag = new CompoundTag();
            gearModifiersTag.m_128365_("gearModifiers", (Tag)ModifierDiscoveryTileEntity.writeGearModifiers(gearModifiers));
            buffer.m_130079_(gearModifiersTag);
        });
    }

    public void discoverGearModifier(ServerPlayer player, Tuple<Item, ResourceLocation> gearModifier) {
        this.setUsedByPlayer((Player)player);
        DiscoveredWorkbenchModifiersData discoveredModifiers = DiscoveredWorkbenchModifiersData.get(player.m_183503_());
        if (!discoveredModifiers.compoundDiscoverWorkbenchCraft(player, (Item)gearModifier.m_14418_(), (ResourceLocation)gearModifier.m_14419_())) {
            return;
        }
        VaultGearWorkbenchConfig.getConfig((Item)gearModifier.m_14418_()).ifPresent(cfg -> {
            VaultGearWorkbenchConfig.CraftableModifierConfig modifierCfg = cfg.getConfig((ResourceLocation)gearModifier.m_14419_());
            if (modifierCfg == null) {
                return;
            }
            modifierCfg.createModifier().ifPresent(modifier -> {
                ItemStack stack = new ItemStack((ItemLike)gearModifier.m_14418_());
                if (stack.m_41720_() instanceof VaultGearItem) {
                    VaultGearData vgData = VaultGearData.read(stack);
                    vgData.setState(VaultGearState.IDENTIFIED);
                    vgData.setRarity(VaultGearRarity.COMMON);
                    vgData.write(stack);
                }
                modifier.getConfigDisplay(stack).ifPresent(configDisplay -> {
                    MutableComponent cmp = new TextComponent("").m_7220_(player.m_5446_()).m_130946_(" discovered the ").m_7220_(stack.m_41786_()).m_130946_(" modifier: ").m_7220_((Component)configDisplay);
                    MiscUtils.broadcast((Component)cmp);
                });
            });
        });
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }
}

