/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.random.JavaRandom;
import iskallia.vault.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class ShopPedestalBlockTile
extends BlockEntity {
    private boolean initialized = false;
    private ItemStack offer = ItemStack.f_41583_;
    private OverSizedItemStack currency = OverSizedItemStack.EMPTY;

    public ShopPedestalBlockTile(BlockPos pos, BlockState state) {
        super(ModBlocks.SHOP_PEDESTAL_TILE_ENTITY, pos, state);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 2, 1));
    }

    public static void tick(Level world, BlockPos pos, BlockState state, ShopPedestalBlockTile tile) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        if (tile.initialized) {
            return;
        }
        CommonEvents.SHOP_PEDESTAL_LOOT_GENERATION.invoke(serverLevel, state, pos, tile, JavaRandom.ofNanoTime());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.initialized = tag.m_128471_("initialized");
        this.offer = ItemStack.m_41712_((CompoundTag)tag.m_128469_("offerStack"));
        this.currency = OverSizedItemStack.deserialize(tag.m_128469_("currencyStack"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("initialized", this.initialized);
        tag.m_128365_("offerStack", (Tag)this.offer.serializeNBT());
        tag.m_128365_("currencyStack", (Tag)this.currency.serialize());
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public ItemStack getOfferStack() {
        return this.offer.m_41777_();
    }

    public ItemStack getCurrencyStack() {
        return this.currency.overSizedStack().m_41777_();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void clear() {
        this.initialized = false;
        this.offer = ItemStack.f_41583_;
        this.currency = OverSizedItemStack.EMPTY;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void setOffer(ItemStack offer, OverSizedItemStack currency) {
        this.initialized = true;
        this.offer = offer;
        this.currency = currency;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }
}

