/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.authlib.GameProfile;
import iskallia.vault.config.SpiritConfig;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.entity.IPlayerSkinHolder;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.item.tool.JewelItem;
import iskallia.vault.item.tool.ToolItem;
import iskallia.vault.item.tool.ToolMaterial;
import iskallia.vault.util.InventoryUtil;
import iskallia.vault.world.data.InventorySnapshot;
import iskallia.vault.world.data.PlayerSpiritRecoveryData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class SpiritExtractorTileEntity
extends BlockEntity
implements IPlayerSkinHolder {
    private static final String OWNER_PROFILE_TAG = "ownerProfile";
    private static final String ITEMS_TAG = "items";
    private static final String PAYMENT_STACK_TAG = "paymentStack";
    private static final String RECOVERY_COST_TAG = "recoveryCost";
    private static final String RECYCLABLE_TAG = "recyclable";
    @Nullable
    private GameProfile gameProfile;
    @Deprecated
    private final NonNullList<ItemStack> items = NonNullList.m_122779_();
    @Nullable
    private InventorySnapshot inventorySnapshot = null;
    private int vaultLevel;
    private int playerLevel;
    private RecoveryCost recoveryCost = new RecoveryCost();
    private final OverSizedInventory paymentInventory = new OverSizedInventory(1, () -> ((SpiritExtractorTileEntity)this).m_6596_(), player -> true){

        public boolean m_7013_(int pIndex, ItemStack pStack) {
            return SpiritExtractorTileEntity.this.getRecoveryCost().getTotalCost().m_41720_() == pStack.m_41720_();
        }

        @Override
        public int m_6893_() {
            return SpiritExtractorTileEntity.this.getRecoveryCost().getTotalCost().m_41613_();
        }
    };
    private boolean spewingItems;
    private int itemsPerDrop;
    private long spewingCooldownTime;
    private ResourceLocation skinLocation = null;
    private boolean updatingSkin = false;
    private boolean slimSkin = false;
    private boolean recyclable = false;
    private float rescuedBonus = 0.0f;

    public SpiritExtractorTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.SPIRIT_EXTRACTOR_TILE_ENTITY, pos, state);
    }

    public RecoveryCost getRecoveryCost() {
        if (!this.spewingItems && this.recoveryCost.isEmpty()) {
            this.recalculateCost();
        }
        return this.recoveryCost;
    }

    public void recalculateCost() {
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.gameProfile != null) {
            PlayerSpiritRecoveryData data = PlayerSpiritRecoveryData.get(serverLevel);
            this.recoveryCost.calculate(data.getSpiritRecoveryMultiplier(this.gameProfile.getId()), this.playerLevel, (List<ItemStack>)this.items, this.inventorySnapshot, data.getHeroDiscount(this.gameProfile.getId()), this.rescuedBonus);
        }
    }

    public OverSizedInventory getPaymentInventory() {
        return this.paymentInventory;
    }

    public void setVaultLevel(int vaultLevel) {
        this.vaultLevel = vaultLevel;
        this.m_6596_();
    }

    public void setPlayerLevel(int playerLevel) {
        this.playerLevel = playerLevel;
        this.m_6596_();
    }

    public void setRescuedBonus(float rescuedBonus) {
        this.rescuedBonus = rescuedBonus;
        this.m_6596_();
    }

    public float getRescuedBonus() {
        return this.rescuedBonus;
    }

    @Override
    public void setGameProfile(GameProfile gameProfile) {
        if (gameProfile == null || !gameProfile.equals((Object)this.gameProfile)) {
            this.gameProfile = gameProfile;
            this.skinLocation = null;
        }
        this.m_6596_();
    }

    public void setRecyclable(boolean recyclable) {
        this.recyclable = recyclable;
        this.m_6596_();
    }

    @Override
    public Optional<ResourceLocation> getSkinLocation() {
        return Optional.ofNullable(this.skinLocation);
    }

    @Override
    public boolean isUpdatingSkin() {
        return this.updatingSkin;
    }

    @Override
    public void setSkinLocation(ResourceLocation skinLocation) {
        this.skinLocation = skinLocation;
    }

    @Override
    public void startUpdatingSkin() {
        this.updatingSkin = true;
    }

    @Override
    public void stopUpdatingSkin() {
        this.updatingSkin = false;
    }

    @Override
    public boolean hasSlimSkin() {
        return this.slimSkin;
    }

    @Override
    public void setSlimSkin(boolean slimSkin) {
        this.slimSkin = slimSkin;
    }

    @Override
    public Optional<GameProfile> getGameProfile() {
        return Optional.ofNullable(this.gameProfile);
    }

    public void setItems(List<ItemStack> items) {
        this.items.clear();
        this.items.addAll(items);
        this.itemsPerDrop = this.calculateItemsPerDrop();
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, blockEntity -> this.addSpiritRecoveryData(blockEntity.m_5995_()));
    }

    private CompoundTag addSpiritRecoveryData(CompoundTag tag) {
        tag.m_128365_(RECOVERY_COST_TAG, (Tag)this.recoveryCost.serialize());
        return tag;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    protected void m_183515_(CompoundTag tag) {
        ItemStack goldStack;
        super.m_183515_(tag);
        if (this.gameProfile != null) {
            tag.m_128365_(OWNER_PROFILE_TAG, (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.gameProfile));
        }
        tag.m_128405_("vaultLevel", this.vaultLevel);
        tag.m_128405_("playerLevel", this.playerLevel);
        ListTag itemList = new ListTag();
        for (ItemStack item : this.items) {
            itemList.add((Object)item.m_41739_(new CompoundTag()));
        }
        tag.m_128365_(ITEMS_TAG, (Tag)itemList);
        if (this.inventorySnapshot != null) {
            tag.m_128365_("inventorySnapshot", (Tag)this.inventorySnapshot.serializeNBT());
        }
        if (!(goldStack = this.paymentInventory.m_8020_(0)).m_41619_()) {
            tag.m_128365_(PAYMENT_STACK_TAG, (Tag)OverSizedItemStack.of(goldStack).serialize());
        }
        tag.m_128379_("spewingItems", this.spewingItems);
        tag.m_128379_(RECYCLABLE_TAG, this.recyclable);
        tag.m_128350_("rescuedBonus", this.rescuedBonus);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.setGameProfile(tag.m_128441_(OWNER_PROFILE_TAG) ? NbtUtils.m_129228_((CompoundTag)tag.m_128469_(OWNER_PROFILE_TAG)) : null);
        if (tag.m_128441_(ITEMS_TAG)) {
            this.items.clear();
            for (Tag itemTag : tag.m_128437_(ITEMS_TAG, 10)) {
                this.items.add((Object)ItemStack.m_41712_((CompoundTag)((CompoundTag)itemTag)));
            }
            this.itemsPerDrop = this.calculateItemsPerDrop();
        }
        if (tag.m_128441_("inventorySnapshot")) {
            this.inventorySnapshot = new InventorySnapshot(false, false);
            this.inventorySnapshot.deserializeNBT(tag.m_128469_("inventorySnapshot"));
        } else {
            this.inventorySnapshot = null;
        }
        this.vaultLevel = tag.m_128451_("vaultLevel");
        int n = this.playerLevel = tag.m_128441_("playerLevel") ? tag.m_128451_("playerLevel") : this.vaultLevel;
        if (tag.m_128441_(PAYMENT_STACK_TAG)) {
            this.paymentInventory.setOverSizedStack(0, OverSizedItemStack.deserialize(tag.m_128469_(PAYMENT_STACK_TAG)));
        }
        this.spewingItems = tag.m_128471_("spewingItems");
        if (tag.m_128425_(RECOVERY_COST_TAG, 10)) {
            this.recoveryCost.deserialize(tag.m_128469_(RECOVERY_COST_TAG));
        }
        this.recyclable = !tag.m_128441_(RECYCLABLE_TAG) || tag.m_128471_(RECYCLABLE_TAG);
        this.rescuedBonus = tag.m_128457_("rescuedBonus");
    }

    private int calculateItemsPerDrop() {
        return this.items.size() <= 20 ? 1 : this.items.size() / 20;
    }

    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82363_(0.0, 2.0, 0.0);
    }

    public List<ItemStack> getStoredItems() {
        if (!this.items.isEmpty()) {
            return this.items;
        }
        return this.inventorySnapshot != null ? this.inventorySnapshot.getItems() : Collections.emptyList();
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void spewItems(Player player) {
        if (!this.spewingItems && this.coinsCoverTotalCost()) {
            if (this.f_58857_.m_5776_()) {
                this.spawnParticles();
            } else {
                Level level = this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.gameProfile != null) {
                        PlayerSpiritRecoveryData data = PlayerSpiritRecoveryData.get(serverLevel);
                        data.increaseMultiplierOnRecovery(this.gameProfile.getId());
                        data.removeHeroDiscount(this.gameProfile.getId());
                    }
                }
                this.paymentInventory.m_6836_(0, ItemStack.f_41583_);
                this.rescuedBonus = 0.0f;
                this.recoveryCost = new RecoveryCost();
                if (this.inventorySnapshot != null && !this.inventorySnapshot.getItems().isEmpty()) {
                    this.inventorySnapshot.apply(player);
                    this.inventorySnapshot = null;
                    this.removeSpirit();
                } else {
                    this.spewingItems = true;
                    this.spewingCooldownTime = this.f_58857_.m_46467_() + 20L;
                }
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 0.5f);
            }
        }
    }

    public boolean coinsCoverTotalCost() {
        int totalCost = this.getRecoveryCost().getTotalCost().m_41613_();
        return totalCost > 0 && this.paymentInventory.m_8020_(0).m_41613_() >= totalCost;
    }

    private void spawnParticles() {
        int numberOfParticles = 15;
        for (int i = 0; i < numberOfParticles; ++i) {
            double x = (double)this.m_58899_().m_123341_() + this.f_58857_.f_46441_.nextDouble();
            double y = (double)this.m_58899_().m_123342_() + 0.5 + this.f_58857_.f_46441_.nextDouble() * 0.5;
            double z = (double)this.m_58899_().m_123343_() + this.f_58857_.f_46441_.nextDouble();
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, this.f_58857_.f_46441_.nextGaussian() * 0.02, this.f_58857_.f_46441_.nextGaussian() * 0.02, this.f_58857_.f_46441_.nextGaussian() * 0.02);
        }
    }

    public boolean isSpewingItems() {
        return this.spewingItems;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SpiritExtractorTileEntity e) {
        if (!level.m_5776_() && e.spewingItems && e.spewingCooldownTime < level.m_46467_()) {
            if (e.items.isEmpty()) {
                e.spewingItems = false;
                e.spewingCooldownTime = 0L;
                e.removeSpirit();
                return;
            }
            for (int i = 0; i < e.itemsPerDrop && !e.items.isEmpty(); ++i) {
                int itemIndex = level.f_46441_.nextInt(e.items.size());
                Containers.m_18992_((Level)level, (double)((double)pos.m_123341_() + 0.5), (double)(pos.m_123342_() + 1), (double)((double)pos.m_123343_() + 0.5), (ItemStack)((ItemStack)e.items.remove(itemIndex)));
            }
            e.spewingCooldownTime = level.m_46467_() + 2L;
            e.m_6596_();
        }
    }

    public int getVaultLevel() {
        return this.vaultLevel;
    }

    public int getPlayerLevel() {
        return this.playerLevel;
    }

    public void removeSpirit() {
        this.items.clear();
        this.inventorySnapshot = null;
        this.gameProfile = null;
        this.itemsPerDrop = 0;
        this.vaultLevel = 0;
        this.playerLevel = 0;
        this.rescuedBonus = 0.0f;
        this.recoveryCost = new RecoveryCost();
        this.dropPaymentInventory();
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    private void dropPaymentInventory() {
        BlockPos pos = this.m_58899_();
        Containers.m_18992_((Level)this.f_58857_, (double)((double)pos.m_123341_() + 0.5), (double)(pos.m_123342_() + 1), (double)((double)pos.m_123343_() + 0.5), (ItemStack)this.paymentInventory.m_8020_(0));
        this.paymentInventory.m_6836_(0, ItemStack.f_41583_);
    }

    public void recycle() {
        if (this.gameProfile == null || this.isSpewingItems()) {
            return;
        }
        if (this.recyclable) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
            CrystalData crystal = CrystalData.read(stack);
            crystal.setLevel(this.vaultLevel);
            crystal.write(stack);
            BlockPos pos = this.m_58899_();
            Containers.m_18992_((Level)this.f_58857_, (double)((double)pos.m_123341_() + 0.5), (double)(pos.m_123342_() + 1), (double)((double)pos.m_123343_() + 0.5), (ItemStack)stack);
        }
        this.items.clear();
        this.inventorySnapshot = null;
        this.removeSpirit();
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11738_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public boolean isRecyclable() {
        return this.recyclable;
    }

    public void setInventorySnapshot(InventorySnapshot inventorySnapshot) {
        this.inventorySnapshot = inventorySnapshot;
    }

    public InventorySnapshot getInventorySnapshot() {
        return this.inventorySnapshot;
    }

    public static class RecoveryCost {
        private OverSizedItemStack totalCost = OverSizedItemStack.EMPTY;
        private float baseCount = 0.0f;
        private List<Tuple<ItemStack, Integer>> stackCost = new ArrayList<Tuple<ItemStack, Integer>>();

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("totalCost", (Tag)this.totalCost.serialize());
            tag.m_128350_("baseCount", this.baseCount);
            if (!this.stackCost.isEmpty()) {
                ListTag stackCostTag = new ListTag();
                this.stackCost.forEach(t -> {
                    CompoundTag singleStackTag = new CompoundTag();
                    singleStackTag.m_128365_("stack", (Tag)((ItemStack)t.m_14418_()).m_41739_(new CompoundTag()));
                    singleStackTag.m_128405_("cost", ((Integer)t.m_14419_()).intValue());
                    stackCostTag.add((Object)singleStackTag);
                });
                tag.m_128365_("stackCost", (Tag)stackCostTag);
            }
            return tag;
        }

        public void deserialize(CompoundTag tag) {
            this.totalCost = tag.m_128425_("totalCost", 10) ? OverSizedItemStack.deserialize(tag.m_128469_("totalCost")) : OverSizedItemStack.EMPTY;
            this.baseCount = tag.m_128425_("baseCost", 10) ? (float)OverSizedItemStack.deserialize(tag.m_128469_("baseCost")).amount() : tag.m_128457_("baseCount");
            this.stackCost.clear();
            if (tag.m_128425_("stackCost", 9)) {
                tag.m_128437_("stackCost", 10).forEach(t -> {
                    CompoundTag singleStackCostTag = (CompoundTag)t;
                    this.stackCost.add((Tuple<ItemStack, Integer>)new Tuple((Object)ItemStack.m_41712_((CompoundTag)singleStackCostTag.m_128469_("stack")), (Object)singleStackCostTag.m_128451_("cost")));
                });
            }
        }

        public boolean isEmpty() {
            return this.totalCost.overSizedStack().m_41619_();
        }

        public void calculate(float multiplier, int vaultLevel, List<ItemStack> items, @Nullable InventorySnapshot inventorySnapshot, float heroDiscount, float rescuedBonus) {
            this.getLevelCost(vaultLevel).ifPresent(cost -> {
                this.baseCount = cost.count;
                int totalCost = (int)Math.ceil(cost.count * (float)Math.max(1, vaultLevel) + 1.0f);
                this.stackCost.clear();
                totalCost += this.getItemsCost((SpiritConfig.LevelCost)cost, items, inventorySnapshot);
                totalCost = (int)((float)totalCost * multiplier * (1.0f - heroDiscount) * (1.0f - rescuedBonus));
                totalCost = Math.max(1, totalCost);
                this.totalCost = new OverSizedItemStack(new ItemStack((ItemLike)cost.item, totalCost), totalCost);
            });
        }

        private int getItemsCost(SpiritConfig.LevelCost cost, List<ItemStack> items, @Nullable InventorySnapshot inventorySnapshot) {
            int itemCost;
            int totalItemCost = 0;
            for (ItemStack foundItem : InventoryUtil.findAllItems(items)) {
                itemCost = this.getItemCost(cost, foundItem);
                if (itemCost <= 0) continue;
                totalItemCost += itemCost;
            }
            if (inventorySnapshot != null) {
                for (ItemStack foundItem : InventoryUtil.findAllItems(inventorySnapshot.getItems())) {
                    itemCost = this.getItemCost(cost, foundItem);
                    if (itemCost <= 0) continue;
                    totalItemCost += itemCost;
                }
            }
            return totalItemCost;
        }

        private int getItemCost(SpiritConfig.LevelCost cost, ItemStack item) {
            if (this.isSoulbound(item)) {
                return 0;
            }
            int itemCost = 0;
            if (item.m_41720_() instanceof TrinketItem && TrinketItem.hasUsesLeft(item)) {
                this.addItemCost(item.m_41777_(), cost.trinketCost);
                itemCost = cost.trinketCost;
            } else if (item.m_41720_() instanceof VaultGearItem && !(item.m_41720_() instanceof JewelItem) && !(item.m_41720_() instanceof ToolItem)) {
                VaultGearData data = VaultGearData.read(item);
                if (cost.gearRarityCost.containsKey((Object)data.getRarity())) {
                    int gearCost = cost.gearRarityCost.get((Object)data.getRarity());
                    this.addItemCost(item.m_41777_(), gearCost);
                    itemCost = gearCost;
                }
            } else if (item.m_41720_() instanceof ToolItem) {
                ToolMaterial material = ToolItem.getMaterial(item);
                if (cost.toolMaterialCost.containsKey((Object)material)) {
                    int toolCost = cost.toolMaterialCost.get((Object)material);
                    this.addItemCost(item.m_41777_(), toolCost);
                    itemCost = toolCost;
                }
            } else {
                itemCost = cost.getStackCost(item);
                this.addItemCost(item, itemCost);
            }
            return itemCost;
        }

        private void addItemCost(ItemStack item, int itemCost) {
            if (itemCost != 0) {
                this.stackCost.add((Tuple<ItemStack, Integer>)new Tuple((Object)item.m_41777_(), (Object)itemCost));
            }
        }

        private boolean isSoulbound(ItemStack stack) {
            return ((AttributeGearData)((Object)AttributeGearData.read(stack))).get(ModGearAttributes.SOULBOUND, VaultGearAttributeTypeMerger.anyTrue());
        }

        private Optional<SpiritConfig.LevelCost> getLevelCost(int vaultLevel) {
            SpiritConfig.LevelCost ret = null;
            for (SpiritConfig.LevelCost levelCost : ModConfigs.SPIRIT.levelCosts) {
                if (levelCost.minLevel > vaultLevel || ret != null && ret.minLevel >= levelCost.minLevel) continue;
                ret = levelCost;
            }
            return Optional.ofNullable(ret);
        }

        public ItemStack getTotalCost() {
            return this.totalCost.overSizedStack();
        }

        public float getBaseCount() {
            return this.baseCount;
        }

        public List<Tuple<ItemStack, Integer>> getStackCost() {
            return this.stackCost;
        }
    }
}

