/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.mojang.math.Vector3f;
import iskallia.vault.block.entity.TotemTileEntity;
import iskallia.vault.client.particles.ColoredParticleOptions;
import iskallia.vault.client.particles.SphericalParticleOptions;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModParticles;
import iskallia.vault.skill.ability.effect.TotemPlayerDamageAbility;
import iskallia.vault.util.MathUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TotemPlayerDamageTileEntity
extends TotemTileEntity {
    private float playerDamageIncrease;
    private final List<Player> playerList = new ArrayList<Player>();
    public static final Vector3f PARTICLE_EFFECT_COLOR = new Vector3f(0.924f, 0.265f, 0.058f);
    private static final String TAG_PLAYER_DAMAGE_INCREASE = "playerDamageIncrease";

    public TotemPlayerDamageTileEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlocks.TOTEM_PLAYER_DAMAGE_TILE_ENTITY, blockPos, blockState);
    }

    public void initialize(UUID playerUUID, int durationTicks, float effectRadius, float playerDamageIncrease) {
        super.initialize(playerUUID, durationTicks, effectRadius);
        this.playerDamageIncrease = playerDamageIncrease;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TotemPlayerDamageTileEntity tile) {
        tile.serverTick();
    }

    @Override
    protected boolean serverTick() {
        if (!super.serverTick()) {
            this.playerList.clear();
            return false;
        }
        this.getPlayersInRange(this.getEffectBounds(), this.getEffectOrigin(), this.getEffectRadius(), this.playerList);
        this.updatePlayerEffect(this.playerList);
        this.playerList.clear();
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.getRemainingDurationTicks() % 5 == 0 && (double)serverLevel.f_46441_.nextFloat() < 0.25 || this.getRemainingDurationTicks() % 20 == 0) {
            BlockPos blockPos = this.m_58899_();
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175834_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.34375, (double)blockPos.m_123343_() + 0.6875, 1, 0.0125, 0.0, 0.0125, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175834_, (double)blockPos.m_123341_() + 0.65625, (double)blockPos.m_123342_() + 0.28125, (double)blockPos.m_123343_() + 0.75, 1, 0.0125, 0.0, 0.0125, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175834_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.34375, (double)blockPos.m_123343_() + 0.3125, 1, 0.0125, 0.0, 0.0125, 0.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175834_, (double)blockPos.m_123341_() + 0.34375, (double)blockPos.m_123342_() + 0.28125, (double)blockPos.m_123343_() + 0.25, 1, 0.0125, 0.0, 0.0125, 0.0);
        }
        return true;
    }

    private void updatePlayerEffect(List<Player> playerList) {
        for (Player player : playerList) {
            TotemPlayerDamageAbility.TotemPlayerDamageEffect.addTo((LivingEntity)player, this.playerDamageIncrease);
        }
    }

    private void getPlayersInRange(AABB area, Vec3 center, float range, List<Player> result) {
        if (this.f_58857_ == null) {
            return;
        }
        for (Player player : this.f_58857_.m_6907_()) {
            if (!area.m_82390_(player.m_20182_()) || !MathUtilities.isAABBIntersectingOrInsideSphere(player.m_142469_(), center, range)) continue;
            result.add(player);
        }
    }

    @Override
    public Vector3f getParticleEffectColor() {
        return PARTICLE_EFFECT_COLOR;
    }

    @Override
    protected ParticleOptions getFountainParticleOptions() {
        return new ColoredParticleOptions((ParticleType<ColoredParticleOptions>)((ParticleType)ModParticles.TOTEM_FOUNTAIN.get()), PARTICLE_EFFECT_COLOR);
    }

    @Override
    protected ParticleOptions getEffectRangeParticleOptions(float effectRadius) {
        return new SphericalParticleOptions((ParticleType<SphericalParticleOptions>)((ParticleType)ModParticles.TOTEM_EFFECT_RANGE.get()), effectRadius, PARTICLE_EFFECT_COLOR);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag tag) {
        this.playerDamageIncrease = tag.m_128457_(TAG_PLAYER_DAMAGE_INCREASE);
        super.m_142466_(tag);
    }

    @Override
    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_(TAG_PLAYER_DAMAGE_INCREASE, this.playerDamageIncrease);
    }
}

