/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import com.google.common.collect.Lists;
import iskallia.vault.VaultMod;
import iskallia.vault.container.VaultDiffuserUpgradedContainer;
import iskallia.vault.container.base.SimpleSidedContainer;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModParticles;
import iskallia.vault.network.message.ClientboundTESyncMessage;
import iskallia.vault.network.message.DiffuserUpgradedParticleMessage;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class VaultDiffuserUpgradedTileEntity
extends BlockEntity
implements MenuProvider {
    private static final Random rand = new Random();
    private static final BlockPos[] list = new BlockPos[]{BlockPos.f_121853_.m_142127_().m_142126_(), BlockPos.f_121853_.m_142127_().m_142125_(), BlockPos.f_121853_.m_142128_().m_142126_(), BlockPos.f_121853_.m_142128_().m_142125_()};
    private final DiffuserInput inputInv = new DiffuserInput();
    private final DiffuserOutput outputInv = new DiffuserOutput(1, this);
    private int processTick = 0;
    private int processTickLast = 0;
    private LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this.inputInv, (Direction[])new Direction[]{Direction.UP, Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH});
    private LazyOptional<? extends IItemHandler>[] outputHandlers = SidedInvWrapper.create((WorldlyContainer)this.outputInv, (Direction[])new Direction[]{Direction.DOWN});

    public VaultDiffuserUpgradedTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModBlocks.VAULT_HARVESTER_ENTITY, pWorldPosition, pBlockState);
    }

    public boolean stillValid(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return this.inputInv.m_6542_(player);
    }

    private static IntStream getSlots(Container p_59340_, Direction p_59341_) {
        return p_59340_ instanceof WorldlyContainer ? IntStream.of(((WorldlyContainer)p_59340_).m_7071_(p_59341_)) : IntStream.range(0, p_59340_.m_6643_());
    }

    private static boolean isEmptyContainer(Container pContainer, Direction pDirection) {
        return VaultDiffuserUpgradedTileEntity.getSlots(pContainer, pDirection).allMatch(p_59319_ -> pContainer.m_8020_(p_59319_).m_41619_());
    }

    private static boolean canTakeItemFromContainer(Container pContainer, ItemStack pStack, int pSlot, Direction pDirection) {
        return !(pContainer instanceof WorldlyContainer) || ((WorldlyContainer)pContainer).m_7157_(pSlot, pStack, pDirection);
    }

    public static boolean suckInItems(Level p_155553_, VaultDiffuserUpgradedTileEntity p_155554_) {
        Boolean ret = VaultDiffuserUpgradedTileEntity.extractHook(p_155553_, p_155554_);
        if (ret != null) {
            return ret;
        }
        Container container = VaultDiffuserUpgradedTileEntity.getSourceContainer(p_155553_, p_155554_.m_58899_());
        if (container != null) {
            Direction direction = Direction.DOWN;
            return !VaultDiffuserUpgradedTileEntity.isEmptyContainer(container, direction) && VaultDiffuserUpgradedTileEntity.getSlots(container, direction).anyMatch(p_59363_ -> VaultDiffuserUpgradedTileEntity.tryTakeInItemFromSlot(p_155554_, container, p_59363_, direction));
        }
        return false;
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.m_41619_() && stackInSlot.m_41613_() >= itemHandler.getSlotLimit(slot)) continue;
            return false;
        }
        return true;
    }

    private static ItemStack putStackInInventoryAllSlots(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.m_41619_(); ++slot) {
            stack = VaultDiffuserUpgradedTileEntity.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private static ItemStack insertStack(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack itemstack = destInventory.getStackInSlot(slot);
        if (destInventory.insertItem(slot, stack, true).m_41613_() != 64) {
            boolean insertedItem = false;
            boolean inventoryWasEmpty = VaultDiffuserUpgradedTileEntity.isEmpty(destInventory);
            if (itemstack.m_41619_()) {
                destInventory.insertItem(slot, stack, false);
                stack = ItemStack.f_41583_;
                insertedItem = true;
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)itemstack, (ItemStack)stack)) {
                int originalSize = stack.m_41613_();
                insertedItem = originalSize < (stack = destInventory.insertItem(slot, stack, false)).m_41613_();
            }
        }
        return stack;
    }

    private static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.m_41613_() <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean insertHook(VaultDiffuserUpgradedTileEntity diffuser) {
        return VaultDiffuserUpgradedTileEntity.getItemHandler(diffuser.m_58904_(), diffuser, Direction.DOWN).map(destinationResult -> {
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            Object destination = destinationResult.getValue();
            if (VaultDiffuserUpgradedTileEntity.isFull(itemHandler)) {
                return false;
            }
            if (!diffuser.outputInv.m_8020_(0).m_41619_()) {
                ItemStack originalSlotContents = diffuser.outputInv.m_8020_(0).m_41777_();
                ItemStack insertStack = diffuser.outputInv.m_7407_(0, 64);
                ItemStack remainder = VaultDiffuserUpgradedTileEntity.putStackInInventoryAllSlots(diffuser, destination, itemHandler, insertStack);
                if (remainder.m_41613_() != 64) {
                    originalSlotContents.m_41764_(originalSlotContents.m_41613_() - 64 + remainder.m_41613_());
                    diffuser.outputInv.m_6836_(0, originalSlotContents);
                    return true;
                }
                diffuser.outputInv.m_6836_(0, originalSlotContents);
            }
            return false;
        }).orElse(false);
    }

    @Nullable
    public static Boolean extractHook(Level level, VaultDiffuserUpgradedTileEntity dest) {
        return VaultDiffuserUpgradedTileEntity.getItemHandler(level, dest, Direction.UP).map(itemHandlerResult -> {
            IItemHandler handler = (IItemHandler)itemHandlerResult.getKey();
            for (int i = 0; i < handler.getSlots(); ++i) {
                int count = Math.min(64, handler.getStackInSlot(i).m_41613_());
                ItemStack extractItem = handler.extractItem(i, count, true);
                if (extractItem.m_41619_()) continue;
                for (int j = 0; j < dest.inputInv.m_6643_(); ++j) {
                    ItemStack destStack = dest.inputInv.m_8020_(j);
                    if (!dest.inputInv.m_7013_(j, extractItem) || !destStack.m_41619_() && (destStack.m_41613_() >= destStack.m_41741_() || destStack.m_41613_() >= dest.inputInv.m_6893_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)extractItem, (ItemStack)destStack))) continue;
                    extractItem = handler.extractItem(i, count, false);
                    if (destStack.m_41619_()) {
                        dest.inputInv.m_6836_(j, extractItem);
                    } else {
                        destStack.m_41769_(count);
                        dest.inputInv.m_6836_(j, destStack);
                    }
                    dest.m_6596_();
                    return true;
                }
            }
            return false;
        }).orElse(null);
    }

    private static Optional<Pair<IItemHandler, Object>> getItemHandler(Level level, VaultDiffuserUpgradedTileEntity diffuser, Direction diffuserFacing) {
        double x = (double)diffuser.m_58899_().m_123341_() + (double)diffuserFacing.m_122429_();
        double y = (double)diffuser.m_58899_().m_123342_() + (double)diffuserFacing.m_122430_();
        double z = (double)diffuser.m_58899_().m_123343_() + (double)diffuserFacing.m_122431_();
        return VaultDiffuserUpgradedTileEntity.getItemHandler(level, x, y, z, diffuserFacing.m_122424_());
    }

    public static Optional<Pair<IItemHandler, Object>> getItemHandler(Level worldIn, double x, double y, double z, Direction side) {
        BlockEntity blockEntity;
        int k;
        int j;
        int i = Mth.m_14107_((double)x);
        BlockPos blockpos = new BlockPos(i, j = Mth.m_14107_((double)y), k = Mth.m_14107_((double)z));
        BlockState state = worldIn.m_8055_(blockpos);
        if (state.m_155947_() && (blockEntity = worldIn.m_7702_(blockpos)) != null) {
            return blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(capability -> ImmutablePair.of((Object)capability, (Object)blockEntity));
        }
        return Optional.empty();
    }

    public static boolean addItem(Container p_59332_, ItemEntity p_59333_) {
        boolean flag = false;
        ItemStack itemstack = p_59333_.m_32055_().m_41777_();
        ItemStack itemstack1 = VaultDiffuserUpgradedTileEntity.addItem(null, p_59332_, itemstack, null);
        if (itemstack1.m_41619_()) {
            flag = true;
            p_59333_.m_146870_();
        } else {
            p_59333_.m_32045_(itemstack1);
        }
        return flag;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static ItemStack addItem(@Nullable Container pSource, Container pDestination, ItemStack pStack, @Nullable Direction pDirection) {
        if (pDestination instanceof WorldlyContainer) {
            WorldlyContainer worldlycontainer = (WorldlyContainer)pDestination;
            if (pDirection != null) {
                int[] aint = worldlycontainer.m_7071_(pDirection);
                int k = 0;
                while (k < aint.length) {
                    if (pStack.m_41619_()) return pStack;
                    pStack = VaultDiffuserUpgradedTileEntity.tryMoveInItem(pSource, pDestination, pStack, aint[k], pDirection);
                    ++k;
                }
                return pStack;
            }
        }
        int i = pDestination.m_6643_();
        int j = 0;
        while (j < i) {
            if (pStack.m_41619_()) return pStack;
            pStack = VaultDiffuserUpgradedTileEntity.tryMoveInItem(pSource, pDestination, pStack, j, pDirection);
            ++j;
        }
        return pStack;
    }

    private static boolean canPlaceItemInContainer(Container pContainer, ItemStack pStack, int pSlot, @Nullable Direction pDirection) {
        if (!pContainer.m_7013_(pSlot, pStack)) {
            return false;
        }
        return !(pContainer instanceof WorldlyContainer) || ((WorldlyContainer)pContainer).m_7155_(pSlot, pStack, pDirection);
    }

    private static boolean canMergeItems(ItemStack pStack1, ItemStack pStack2) {
        if (!pStack1.m_150930_(pStack2.m_41720_())) {
            return false;
        }
        if (pStack1.m_41773_() != pStack2.m_41773_()) {
            return false;
        }
        if (pStack1.m_41613_() > pStack1.m_41741_()) {
            return false;
        }
        return ItemStack.m_41658_((ItemStack)pStack1, (ItemStack)pStack2);
    }

    private static ItemStack tryMoveInItem(@Nullable Container pSource, Container pDestination, ItemStack pStack, int pSlot, @Nullable Direction pDirection) {
        ItemStack itemstack = pDestination.m_8020_(pSlot);
        if (VaultDiffuserUpgradedTileEntity.canPlaceItemInContainer(pDestination, pStack, pSlot, pDirection)) {
            boolean flag = false;
            if (itemstack.m_41619_()) {
                pDestination.m_6836_(pSlot, pStack);
                pStack = ItemStack.f_41583_;
                flag = true;
            } else if (VaultDiffuserUpgradedTileEntity.canMergeItems(itemstack, pStack)) {
                int i = pStack.m_41741_() - itemstack.m_41613_();
                int j = Math.min(pStack.m_41613_(), i);
                pStack.m_41774_(j);
                itemstack.m_41769_(j);
                boolean bl = flag = j > 0;
            }
            if (flag) {
                pDestination.m_6596_();
            }
        }
        return pStack;
    }

    private static boolean tryTakeInItemFromSlot(VaultDiffuserUpgradedTileEntity diffuser, Container pContainer, int pSlot, Direction pDirection) {
        ItemStack itemstack = pContainer.m_8020_(pSlot);
        if (!itemstack.m_41619_() && VaultDiffuserUpgradedTileEntity.canTakeItemFromContainer(pContainer, itemstack, pSlot, pDirection)) {
            ItemStack itemstack1 = itemstack.m_41777_();
            ItemStack stack = pContainer.m_8020_(pSlot);
            ItemStack itemstack2 = VaultDiffuserUpgradedTileEntity.addItem(pContainer, (Container)diffuser.inputInv, pContainer.m_7407_(pSlot, Math.min(64, stack.m_41613_())), null);
            if (itemstack2.m_41619_()) {
                pContainer.m_6596_();
                return true;
            }
            pContainer.m_6836_(pSlot, itemstack1);
        }
        return false;
    }

    @Nullable
    private static Container getAttachedContainer(Level p_155593_, BlockPos p_155594_) {
        return VaultDiffuserUpgradedTileEntity.getContainerAt(p_155593_, p_155594_.m_142300_(Direction.DOWN));
    }

    @Nullable
    private static Container getSourceContainer(Level p_155593_, BlockPos p_155594_) {
        return VaultDiffuserUpgradedTileEntity.getContainerAt(p_155593_, p_155594_.m_142300_(Direction.UP));
    }

    @Nullable
    public static Container getContainerAt(Level p_59391_, BlockPos p_59392_) {
        return VaultDiffuserUpgradedTileEntity.getContainerAt(p_59391_, (double)p_59392_.m_123341_() + 0.5, (double)p_59392_.m_123342_() + 0.5, (double)p_59392_.m_123343_() + 0.5);
    }

    @Nullable
    private static Container getContainerAt(Level pLevel, double pX, double pY, double pZ) {
        List list;
        BlockEntity blockentity;
        WorldlyContainer container = null;
        BlockPos blockpos = new BlockPos(pX, pY, pZ);
        BlockState blockstate = pLevel.m_8055_(blockpos);
        Block block = blockstate.m_60734_();
        if (block instanceof WorldlyContainerHolder) {
            container = ((WorldlyContainerHolder)block).m_5840_(blockstate, (LevelAccessor)pLevel, blockpos);
        } else if (blockstate.m_155947_() && (blockentity = pLevel.m_7702_(blockpos)) instanceof Container && (container = (Container)blockentity) instanceof ChestBlockEntity && block instanceof ChestBlock) {
            container = ChestBlock.m_51511_((ChestBlock)((ChestBlock)block), (BlockState)blockstate, (Level)pLevel, (BlockPos)blockpos, (boolean)true);
        }
        if (container == null && !(list = pLevel.m_6249_((Entity)null, new AABB(pX - 0.5, pY - 0.5, pZ - 0.5, pX + 0.5, pY + 0.5, pZ + 0.5), EntitySelector.f_20405_)).isEmpty()) {
            container = (Container)list.get(pLevel.f_46441_.nextInt(list.size()));
        }
        return container;
    }

    private static boolean tryMoveItems(Level pLevel, BlockPos pBlockPos, BlockState pBlockState, VaultDiffuserUpgradedTileEntity diffuser, BooleanSupplier pB) {
        if (pLevel.f_46443_) {
            return false;
        }
        boolean flag = false;
        if (!diffuser.outputInv.m_7983_()) {
            flag = VaultDiffuserUpgradedTileEntity.ejectItems(pLevel, pBlockPos, pBlockState, diffuser);
        }
        if (diffuser.outputInv.m_7983_()) {
            diffuser.sync();
        }
        if (flag |= pB.getAsBoolean()) {
            VaultDiffuserUpgradedTileEntity.m_155232_((Level)pLevel, (BlockPos)pBlockPos, (BlockState)pBlockState);
            return true;
        }
        return false;
    }

    private static boolean ejectItems(Level pLevel, BlockPos pPos, BlockState pState, VaultDiffuserUpgradedTileEntity diffuser) {
        if (VaultDiffuserUpgradedTileEntity.insertHook(diffuser)) {
            return true;
        }
        Container container = VaultDiffuserUpgradedTileEntity.getAttachedContainer(pLevel, pPos);
        if (container == null) {
            return false;
        }
        if (VaultDiffuserUpgradedTileEntity.isFullContainer(container, Direction.DOWN)) {
            return false;
        }
        for (int i = 0; i < diffuser.outputInv.m_6643_(); ++i) {
            if (diffuser.outputInv.m_8020_(i).m_41619_()) continue;
            ItemStack itemstack = diffuser.outputInv.m_8020_(i).m_41777_();
            ItemStack itemstack1 = VaultDiffuserUpgradedTileEntity.addItem(diffuser.outputInv, container, diffuser.outputInv.m_7407_(i, 64), Direction.DOWN);
            if (itemstack1.m_41613_() != 64) {
                itemstack.m_41764_(itemstack.m_41613_() - 64 + itemstack1.m_41613_());
                diffuser.outputInv.m_6836_(0, itemstack);
                container.m_6596_();
                return true;
            }
            diffuser.outputInv.m_6836_(i, itemstack);
        }
        return false;
    }

    private static boolean isFullContainer(Container pContainer, Direction pDirection) {
        return VaultDiffuserUpgradedTileEntity.getSlots(pContainer, pDirection).allMatch(slot -> {
            ItemStack itemstack = pContainer.m_8020_(slot);
            return itemstack.m_41613_() >= itemstack.m_41741_();
        });
    }

    public static void tick(Level world, BlockPos pos, BlockState state, VaultDiffuserUpgradedTileEntity tile) {
        tile.processTickLast = tile.processTick;
        if (world.m_5776_()) {
            float f2;
            float f1;
            float f;
            Vec3 vec3;
            if (tile.getProgressPercent() > 0.0f && tile.getProgressPercent() < 0.3f) {
                vec3 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.65, (double)pos.m_123343_() + 0.5);
                for (BlockPos blockpos : list) {
                    f = (float)blockpos.m_123341_() / 3.5f;
                    f1 = 0.5f;
                    f2 = (float)blockpos.m_123343_() / 3.5f;
                    world.m_7106_((ParticleOptions)ModParticles.REVERSE_DIFFUSER_UPGRADED.get(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)f, (double)f1, (double)f2);
                }
            }
            if (tile.getProgressPercent() > 0.6f && tile.getProgressPercent() < 0.9f) {
                vec3 = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.75, (double)pos.m_123343_() + 0.5);
                for (BlockPos blockpos : list) {
                    f = (float)blockpos.m_123341_() / 2.5f;
                    f1 = -0.5f;
                    f2 = (float)blockpos.m_123343_() / 2.5f;
                    world.m_7106_((ParticleOptions)ModParticles.DIFFUSER_UPGRADED.get(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)f, (double)f1, (double)f2);
                }
            }
        }
        if (world.m_5776_()) {
            return;
        }
        boolean bool = VaultDiffuserUpgradedTileEntity.tryMoveItems(world, tile.m_58899_(), tile.m_58900_(), tile, () -> VaultDiffuserUpgradedTileEntity.suckInItems(world, tile));
        if (!tile.canCraft()) {
            tile.resetProcess(world);
            return;
        }
        if (tile.processTick == 0 && tile.f_58857_ != null) {
            tile.f_58857_.m_5594_(null, tile.m_58899_(), SoundEvents.f_11767_, SoundSource.BLOCKS, 0.15f + new Random().nextFloat() * 0.05f, 0.85f + new Random().nextFloat() * 0.05f);
        }
        ++tile.processTick;
        if (tile.processTick >= ModConfigs.VAULT_DIFFUSER.getProcessingTickTime()) {
            tile.finishCraft();
        }
        tile.m_6596_();
        tile.sync();
    }

    private void finishCraft() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11739_, SoundSource.BLOCKS, 0.15f + new Random().nextFloat() * 0.05f, 0.85f + new Random().nextFloat() * 0.05f);
        }
        this.processTick = 0;
        for (int i = 0; i < this.inputInv.m_6643_(); ++i) {
            int output = this.getRecipeOutput(i);
            if (output == 0) continue;
            int count = this.inputInv.m_8020_(i).m_41613_();
            this.inputInv.m_7407_(i, count);
            List<ItemStack> stacksToAdd = this.getUseRelatedOutput(ModConfigs.VAULT_DIFFUSER.generateOutput(output * count));
            if (this.outputInv.m_8020_(0).m_41619_()) {
                this.outputInv.setOverSizedStack(0, new OverSizedItemStack(stacksToAdd.get(0), output * count));
            } else {
                this.outputInv.setOverSizedStack(0, ((OverSizedItemStack)this.outputInv.getOverSizedContents().get(0)).addCopy(output * count));
            }
            this.outputInv.m_6596_();
        }
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new DiffuserUpgradedParticleMessage(this.m_58899_()));
    }

    private List<ItemStack> getUseRelatedOutput(List<ItemStack> output) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        output.forEach(stack -> {
            float out = stack.m_41613_();
            int resultCount = Mth.m_14143_((float)out);
            if (resultCount < 1 && out > 0.0f && rand.nextFloat() < out) {
                ++resultCount;
            }
            ItemStack copyOut = stack.m_41777_();
            copyOut.m_41764_(resultCount);
            list.add(copyOut);
        });
        return list;
    }

    private boolean canCraft() {
        for (int i = 0; i < this.inputInv.m_6643_(); ++i) {
            int output = this.getRecipeOutput(i);
            if (output == 0) continue;
            return this.canAddItem();
        }
        return false;
    }

    private boolean canAddItem() {
        ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ModConfigs.VAULT_DIFFUSER.getOutputItem()));
        ItemStack slotItem = this.outputInv.m_8020_(0);
        return slotItem.m_41619_() || ItemStack.m_150942_((ItemStack)slotItem, (ItemStack)stack);
    }

    @Nullable
    private int getRecipeOutput(int index) {
        ItemStack input = this.inputInv.m_8020_(index);
        if (!this.isValidInput(input)) {
            return 0;
        }
        int output = ModConfigs.VAULT_DIFFUSER.getDiffuserOutputMap().containsKey(input.m_41720_().getRegistryName()) ? ModConfigs.VAULT_DIFFUSER.getDiffuserOutputMap().get(input.m_41720_().getRegistryName()).intValue() : ModConfigs.VAULT_DIFFUSER.getDiffuserOutputMap().get(VaultMod.id("default")).intValue();
        return output;
    }

    private void triggerItemChange() {
        if (this.canCraft() && this.processTick == 0) {
            this.startProcess(null);
        }
    }

    public boolean isValidInput(ItemStack input) {
        if (input.m_41619_()) {
            return false;
        }
        return ModConfigs.VAULT_DIFFUSER.getDiffuserOutputMap().containsKey(input.m_41720_().getRegistryName());
    }

    public void sync() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            CompoundTag saveTag = new CompoundTag();
            this.m_183515_(saveTag);
            ModNetwork.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new ClientboundTESyncMessage(this.f_58858_, saveTag));
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
        }
    }

    private void resetProcess(@Nullable Level world) {
        this.startProcess(world);
    }

    private void startProcess(@Nullable Level world) {
        int prevTick = this.processTick;
        this.processTick = 0;
        this.m_6596_();
        if (prevTick != this.processTick) {
            this.sync();
        }
    }

    public float getProgressPercent() {
        return (float)this.processTick / (float)ModConfigs.VAULT_DIFFUSER.getProcessingTickTime();
    }

    public float getProgressLastPercent() {
        return (float)this.processTickLast / (float)ModConfigs.VAULT_DIFFUSER.getProcessingTickTime();
    }

    public DiffuserInput getInputInv() {
        return this.inputInv;
    }

    public DiffuserOutput getOutputInv() {
        return this.outputInv;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.outputInv.load(tag.m_128469_("output"));
        NBTHelper.deserializeSimpleContainer(this.inputInv, tag.m_128437_("inventory", 10));
        this.processTick = tag.m_128451_("processTick");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag output = new CompoundTag();
        this.outputInv.save(output);
        tag.m_128365_("output", (Tag)output);
        tag.m_128365_("inventory", (Tag)NBTHelper.serializeSimpleContainer(this.inputInv));
        tag.m_128405_("processTick", this.processTick);
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inv, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new VaultDiffuserUpgradedContainer(containerId, this.m_58904_(), this.m_58899_(), inv);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.EAST) {
                return this.handlers[1].cast();
            }
            if (facing == Direction.NORTH) {
                return this.handlers[2].cast();
            }
            if (facing == Direction.WEST) {
                return this.handlers[3].cast();
            }
            if (facing == Direction.SOUTH) {
                return this.handlers[4].cast();
            }
            if (facing == Direction.DOWN) {
                return this.outputHandlers[0].cast();
            }
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        Arrays.stream(this.handlers).forEach(LazyOptional::invalidate);
        Arrays.stream(this.outputHandlers).forEach(LazyOptional::invalidate);
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this.inputInv, (Direction[])new Direction[]{Direction.UP, Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH});
        this.outputHandlers = SidedInvWrapper.create((WorldlyContainer)this.outputInv, (Direction[])new Direction[]{Direction.DOWN});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnDiffuserParticles(BlockPos pos) {
        Vec3 offset;
        float length;
        float rotation;
        Random random;
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (i = 0; i < 40; ++i) {
            random = level.m_5822_();
            rotation = random.nextFloat() * 360.0f;
            length = random.nextFloat() / 10.0f + 0.1f;
            offset = new Vec3(Math.cos(rotation) * (double)length, 0.0, Math.sin(rotation) * (double)length);
            level.m_6493_((ParticleOptions)ModParticles.DIFFUSER_COMPLETE.get(), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_ / 20.0, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + (double)0.8f, (double)pos.m_123343_() + 0.5 + offset.f_82481_ / 20.0, offset.f_82479_ * 2.0, 0.01, offset.f_82481_ * 2.0);
        }
        for (i = 0; i < 20; ++i) {
            random = level.m_5822_();
            rotation = random.nextFloat() * 360.0f;
            length = random.nextFloat() / 10.0f + 0.1f;
            offset = new Vec3(Math.cos(rotation) * (double)length, 0.0, Math.sin(rotation) * (double)length);
            level.m_6493_((ParticleOptions)ModParticles.DIFFUSER_COMPLETE.get(), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_ / 20.0, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + (double)0.8f, (double)pos.m_123343_() + 0.5 + offset.f_82481_ / 20.0, offset.f_82479_ * 3.0, 0.01, offset.f_82481_ * 3.0);
        }
    }

    public class DiffuserInput
    extends SimpleSidedContainer {
        public DiffuserInput() {
            super(9);
        }

        @Override
        public List<Direction> getAccessibleSlots(int slot) {
            if (slot == 0) {
                return Lists.newArrayList((Object[])new Direction[]{Direction.UP, Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH});
            }
            return Lists.newArrayList((Object[])new Direction[]{Direction.DOWN});
        }

        public boolean m_7013_(int slot, ItemStack stack) {
            return ModConfigs.VAULT_DIFFUSER.contains(stack);
        }

        public void m_6596_() {
            super.m_6596_();
            VaultDiffuserUpgradedTileEntity.this.m_6596_();
            VaultDiffuserUpgradedTileEntity.this.triggerItemChange();
        }

        public ItemStack m_19173_(ItemStack pStack) {
            ItemStack $$1 = pStack.m_41777_();
            this.moveItemToOccupiedSlotsWithSameType($$1);
            if ($$1.m_41619_()) {
                return ItemStack.f_41583_;
            }
            this.moveItemToEmptySlots($$1);
            return $$1.m_41619_() ? ItemStack.f_41583_ : $$1;
        }

        private void moveItemToEmptySlots(ItemStack pStack) {
            for (int $$1 = 1; $$1 < this.m_6643_(); ++$$1) {
                ItemStack $$2 = this.m_8020_($$1);
                if (!$$2.m_41619_()) continue;
                this.m_6836_($$1, pStack.m_41777_());
                pStack.m_41764_(0);
                return;
            }
        }

        private void moveItemToOccupiedSlotsWithSameType(ItemStack pStack) {
            for (int $$1 = 1; $$1 < this.m_6643_(); ++$$1) {
                ItemStack $$2 = this.m_8020_($$1);
                if (!ItemStack.m_150942_((ItemStack)$$2, (ItemStack)pStack)) continue;
                this.moveItemsBetweenStacks(pStack, $$2);
                if (!pStack.m_41619_()) continue;
                return;
            }
        }

        private void moveItemsBetweenStacks(ItemStack p_19186_, ItemStack p_19187_) {
            int $$2 = Math.min(this.m_6893_(), p_19187_.m_41741_());
            int $$3 = Math.min(p_19186_.m_41613_(), $$2 - p_19187_.m_41613_());
            if ($$3 > 0) {
                p_19187_.m_41769_($$3);
                p_19186_.m_41774_($$3);
                this.m_6596_();
            }
        }
    }

    public class DiffuserOutput
    extends OverSizedInventory
    implements WorldlyContainer {
        private final Map<Direction, Set<Integer>> cachedSidedSlots;

        public DiffuserOutput(int size, BlockEntity tile) {
            super(size, tile);
            this.cachedSidedSlots = new HashMap<Direction, Set<Integer>>();
            this.cacheSlots();
        }

        private void cacheSlots() {
            IntStream.range(0, this.m_6643_()).forEach(slot -> this.getAccessibleSlots(slot).forEach(dir -> this.cachedSidedSlots.computeIfAbsent((Direction)dir, side -> new HashSet()).add(slot)));
        }

        public List<Direction> getAccessibleSlots(int slot) {
            return Lists.newArrayList((Object[])new Direction[]{Direction.UP, Direction.EAST, Direction.NORTH, Direction.WEST, Direction.SOUTH, Direction.DOWN});
        }

        public int[] m_7071_(Direction side) {
            return Optional.ofNullable(this.cachedSidedSlots.get(side)).map(Collection::stream).orElse(Stream.empty()).mapToInt(Integer::intValue).toArray();
        }

        public boolean m_7013_(int pIndex, ItemStack pStack) {
            return false;
        }

        public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction side) {
            return false;
        }

        public boolean m_7157_(int slot, ItemStack stack, Direction side) {
            return this.cachedSidedSlots.getOrDefault(side, Collections.emptySet()).contains(slot);
        }
    }
}

