/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.container.VaultEnhancementAltarContainer;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.vault.enhancement.EnhancementData;
import iskallia.vault.core.vault.enhancement.EnhancementTask;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VaultEnhancementAltarTileEntity
extends BlockEntity
implements MenuProvider {
    private final SimpleContainer inventory = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            VaultEnhancementAltarTileEntity.this.m_6596_();
        }
    };
    private UUID uuid = UUID.randomUUID();
    private EnhancementTask.Config<?> config = null;
    private Map<UUID, EnhancementTask<?>> tasks = new HashMap();
    private List<UUID> usedPlayers = new ArrayList<UUID>();

    public VaultEnhancementAltarTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.ENHANCEMENT_ALTAR_TILE_ENTITY, pos, state);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public EnhancementTask.Config<?> getConfig() {
        return this.config;
    }

    public Map<UUID, EnhancementTask<?>> getTasks() {
        return this.tasks;
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, VaultEnhancementAltarTileEntity tile) {
        if (level.m_5776_()) {
            VaultEnhancementAltarTileEntity.spawnParticles(pos);
            return;
        }
        if (level.m_46467_() % 10L == 0L) {
            tile.tasks = EnhancementData.getForAltar(tile.uuid);
            tile.f_58857_.m_7260_(tile.f_58858_, tile.m_58900_(), tile.m_58900_(), 3);
            tile.f_58857_.m_46672_(tile.f_58858_, tile.m_58900_().m_60734_());
            tile.m_6596_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void spawnParticles(BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Random rand = level.f_46441_;
        if (rand.nextInt(3) != 0) {
            return;
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 2), (double)pos.m_123343_() + 0.5, (double)(-4.0f + rand.nextFloat() * 8.0f) + 0.5, (double)(rand.nextFloat() * 2.0f) - 2.5, (double)(-4.0f + rand.nextFloat() * 8.0f) + 0.5);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public List<UUID> getUsedPlayers() {
        return this.usedPlayers;
    }

    public void setUsedByPlayer(Player player) {
        this.usedPlayers.add(player.m_142081_());
        this.m_6596_();
    }

    public boolean canBeUsed(Player player) {
        ItemStack input = this.getInventory().m_8020_(0);
        if (input.m_41619_() || !input.m_150930_((Item)ModItems.HELMET)) {
            return false;
        }
        if (!AttributeGearData.hasData(input) || !((AttributeGearData)AttributeGearData.read(input)).isModifiable()) {
            return false;
        }
        return !this.getUsedPlayers().contains(player.m_142081_());
    }

    public boolean stillValid(Player player) {
        return this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) == this;
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        NBTHelper.deserializeSimpleContainer(this.inventory, nbt.m_128437_("inventory", 10));
        this.uuid = Adapters.UUID.readNbt(nbt.m_128423_("uuid")).orElse(UUID.randomUUID());
        this.config = Adapters.ENHANCEMENT_CONFIG.readNbt((Tag)nbt.m_128469_("config")).orElse(null);
        this.tasks = NBTHelper.readMap(nbt, "tasks", UUID::fromString, (key, tag) -> {
            Optional optional;
            if (tag instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)tag;
                optional = Adapters.ENHANCEMENT_TASK.readNbt((Tag)compound);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }).orElse(new HashMap());
        this.usedPlayers = NBTHelper.readList(nbt, "players", StringTag.class, strTag -> UUID.fromString(strTag.m_7916_()));
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("inventory", (Tag)NBTHelper.serializeSimpleContainer(this.inventory));
        Adapters.UUID.writeNbt(this.uuid).ifPresent(tag -> nbt.m_128365_("uuid", tag));
        Adapters.ENHANCEMENT_CONFIG.writeNbt(this.config).ifPresent(tag -> nbt.m_128365_("config", tag));
        NBTHelper.writeMap(nbt, "tasks", this.tasks, UUID::toString, t -> Adapters.ENHANCEMENT_TASK.writeNbt((EnhancementTask<?>)t).orElseThrow());
        NBTHelper.writeCollection(nbt, "players", this.usedPlayers, StringTag.class, uuid -> StringTag.m_129297_((String)uuid.toString()));
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new VaultEnhancementAltarContainer(id, this.m_58904_(), this.m_58899_(), inv);
    }
}

