/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.VaultMod;
import iskallia.vault.container.VaultJewelApplicationStationContainer;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.tool.JewelItem;
import iskallia.vault.item.tool.ToolItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class VaultJewelApplicationStationTileEntity
extends BlockEntity
implements MenuProvider {
    private int totalSizeInJewels = 0;
    private final OverSizedInventory inventory = new OverSizedInventory(61, this){

        @Override
        public void m_6596_() {
            super.m_6596_();
            ItemStack result = VaultJewelApplicationStationTileEntity.this.getToolItem().m_41777_();
            VaultJewelApplicationStationTileEntity.this.totalSizeInJewels = 0;
            for (int i = 0; i < 60; ++i) {
                VaultGearData data;
                Iterator<VaultGearAttributeInstance<Integer>> iterator;
                if (!(VaultJewelApplicationStationTileEntity.this.getJewelItem(i).m_41720_() instanceof JewelItem)) continue;
                if (result.m_41720_() instanceof ToolItem) {
                    VaultJewelApplicationStationTileEntity.applyJewel(result, VaultJewelApplicationStationTileEntity.this.getJewelItem(i));
                }
                if (!(iterator = (data = VaultGearData.read(VaultJewelApplicationStationTileEntity.this.getJewelItem(i))).getModifiers(ModGearAttributes.JEWEL_SIZE, VaultGearData.Type.ALL_MODIFIERS).iterator()).hasNext()) continue;
                VaultGearAttributeInstance<Integer> sizeAttribute = iterator.next();
                VaultJewelApplicationStationTileEntity.this.totalSizeInJewels += sizeAttribute.getValue().intValue();
            }
            VaultJewelApplicationStationTileEntity.this.renderedTool = result.m_41777_();
        }
    };
    private ItemStack renderedTool = this.getToolItem();

    public int getTotalSizeInJewels() {
        return this.totalSizeInJewels;
    }

    public void applyJewels() {
        for (int i = 0; i < 60; ++i) {
            ItemStack result = this.getToolItem();
            if (this.getJewelItem(i).m_41720_() instanceof JewelItem && result.m_41720_() instanceof ToolItem && ToolItem.applyJewel(result, this.getJewelItem(i))) {
                this.setJewelItem(i, ItemStack.f_41583_);
            }
            this.getInventory().m_6836_(0, result);
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), ModSounds.ARTISAN_SMITHING, SoundSource.BLOCKS, 0.2f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
        }
    }

    public static boolean applyJewel(ItemStack tool, ItemStack jewel) {
        VaultGearData toolData = VaultGearData.read(tool);
        VaultGearData jewelData = VaultGearData.read(jewel);
        int capacity = toolData.getFirstValue(ModGearAttributes.TOOL_CAPACITY).orElse(0);
        int size = jewelData.getFirstValue(ModGearAttributes.JEWEL_SIZE).orElse(0);
        toolData.updateAttribute(ModGearAttributes.TOOL_CAPACITY, capacity - size);
        for (VaultGearModifier.AffixType affix : VaultGearModifier.AffixType.explicits()) {
            for (VaultGearModifier<?> jewelModifier : jewelData.getModifiers(affix)) {
                if (jewelModifier.getAttribute() == ModGearAttributes.HAMMER_SIZE && !toolData.get(ModGearAttributes.HAMMERING, VaultGearAttributeTypeMerger.anyTrue()).booleanValue()) continue;
                VaultJewelApplicationStationTileEntity.mergeModifier(affix, toolData, jewelModifier);
            }
        }
        for (VaultGearAttributeInstance vaultGearAttributeInstance : toolData.getModifiers(ModGearAttributes.HAMMER_SIZE, VaultGearData.Type.ALL_MODIFIERS)) {
            vaultGearAttributeInstance.setValue(Math.min((Integer)vaultGearAttributeInstance.getValue(), 7));
        }
        toolData.setItemLevel(Math.max(toolData.getItemLevel(), jewelData.getItemLevel()));
        toolData.write(tool);
        return true;
    }

    private static <T> void mergeModifier(VaultGearModifier.AffixType affix, VaultGearData targetData, VaultGearModifier<T> toAdd) {
        List matching = targetData.getModifiers(toAdd.getAttribute(), VaultGearData.Type.EXPLICIT_MODIFIERS);
        if (matching.isEmpty()) {
            targetData.addModifier(affix, new VaultGearModifier(toAdd.getAttribute(), toAdd.getValue()));
        } else {
            matching.stream().findFirst().ifPresent(current -> current.setValue(VaultJewelApplicationStationTileEntity.merge(current, toAdd.getValue())));
        }
    }

    private static <T> T merge(VaultGearAttributeInstance<T> attributeInstance, T toAdd) {
        VaultGearAttribute<T> attribute = attributeInstance.getAttribute();
        if (attribute.getAttributeComparator() != null) {
            return attribute.getAttributeComparator().merge(attributeInstance.getValue(), toAdd);
        }
        VaultMod.LOGGER.error("Unsupported merging on attribute " + attribute.getRegistryName(), (Throwable)new UnsupportedOperationException());
        return attributeInstance.getValue();
    }

    public boolean stillValid(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return this.inventory.m_6542_(player);
    }

    public VaultJewelApplicationStationTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.VAULT_JEWEL_APPLICATION_STATION_ENTITY, pos, state);
    }

    public OverSizedInventory getInventory() {
        return this.inventory;
    }

    public ItemStack getToolItem() {
        return this.inventory.m_8020_(0);
    }

    public ItemStack getRenderedTool() {
        return this.renderedTool;
    }

    public ItemStack getJewelItem(int i) {
        i = Mth.m_14045_((int)i, (int)0, (int)60);
        return this.inventory.m_8020_(i + 1);
    }

    public void setJewelItem(int i, ItemStack stack) {
        i = Mth.m_14045_((int)i, (int)0, (int)60);
        this.inventory.m_6836_(i + 1, stack);
    }

    public List<ItemStack> getJewels() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 60; ++i) {
            stacks.add(this.inventory.m_8020_(i + 1));
        }
        return stacks;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.renderedTool = ItemStack.m_41712_((CompoundTag)tag.m_128469_("renderedItem"));
        this.totalSizeInJewels = tag.m_128451_("size");
        this.inventory.load(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("renderedItem", (Tag)this.renderedTool.m_41739_(new CompoundTag()));
        tag.m_128405_("size", this.totalSizeInJewels);
        this.inventory.save(tag);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inv, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new VaultJewelApplicationStationContainer(containerId, this.m_58904_(), this.m_58899_(), inv);
    }
}

