/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity;

import iskallia.vault.config.VaultJewelCuttingConfig;
import iskallia.vault.container.VaultJewelCuttingStationContainer;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.gear.attribute.VaultGearModifier;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.JewelCuttingParticleMessage;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.expertise.type.JewelExpertise;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.world.data.PlayerExpertisesData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class VaultJewelCuttingStationTileEntity
extends BlockEntity
implements MenuProvider {
    private final OverSizedInventory inventory = new OverSizedInventory(12, this){

        public boolean m_7013_(int pIndex, ItemStack pStack) {
            if (pIndex != 0 && pIndex != 1) {
                return false;
            }
            return super.m_7013_(pIndex, pStack);
        }
    };

    public boolean stillValid(Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return this.inventory.m_6542_(player);
    }

    public VaultJewelCuttingStationTileEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.VAULT_JEWEL_CUTTING_STATION_ENTITY, pos, state);
    }

    public OverSizedInventory getInventory() {
        return this.inventory;
    }

    public ItemStack getJewelInput() {
        return this.inventory.m_8020_(5);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory.load(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.inventory.save(tag);
    }

    public void cutJewel(VaultJewelCuttingStationContainer container, ServerPlayer player) {
        if (container.getJewelInputSlot() != null) {
            if (!this.canCraft()) {
                return;
            }
            ItemStack stack = container.getJewelInputSlot().m_7993_();
            if (!stack.m_41619_()) {
                VaultGearData data = VaultGearData.read(stack);
                Random random = new Random();
                boolean broken = false;
                boolean chipped = false;
                int freeCuts = 0;
                ExpertiseTree expertises = PlayerExpertisesData.get(player.m_183503_()).getExpertises((Player)player);
                for (JewelExpertise jewelExpertise : expertises.getAll(JewelExpertise.class, Skill::isUnlocked)) {
                    freeCuts = jewelExpertise.getNumberOfFreeCuts();
                }
                int sizeToRemove = this.getJewelCuttingRange().getRandom();
                for (VaultGearAttributeInstance<Integer> vaultGearAttributeInstance : data.getModifiers(ModGearAttributes.JEWEL_SIZE, VaultGearData.Type.ALL_MODIFIERS)) {
                    vaultGearAttributeInstance.setValue(Math.max(10, vaultGearAttributeInstance.getValue() - sizeToRemove));
                    data.write(stack);
                }
                if (freeCuts > 0 && stack.m_41784_().m_128441_("freeCuts") && stack.m_41784_().m_128451_("freeCuts") >= freeCuts || freeCuts == 0) {
                    ArrayList arrayList = new ArrayList(data.getModifiers(VaultGearModifier.AffixType.PREFIX));
                    ArrayList arrayList2 = new ArrayList(data.getModifiers(VaultGearModifier.AffixType.SUFFIX));
                    int affixSize = arrayList.size() + arrayList2.size();
                    if (affixSize > 1) {
                        Collections.shuffle(arrayList, random);
                        Collections.shuffle(arrayList2, random);
                        if (arrayList2.size() > 0 && arrayList.size() > 0) {
                            boolean removedAffix = false;
                            if (random.nextBoolean()) {
                                for (VaultGearModifier vaultGearModifier : arrayList) {
                                    if (!data.removeModifier(vaultGearModifier)) continue;
                                    data.updateAttribute(ModGearAttributes.PREFIXES, Math.max(0, data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0) - 1));
                                    data.setRarity(VaultJewelCuttingStationTileEntity.getNewRarity(affixSize - 1));
                                    removedAffix = true;
                                    break;
                                }
                            }
                            if (!removedAffix) {
                                for (VaultGearModifier vaultGearModifier : arrayList2) {
                                    if (!data.removeModifier(vaultGearModifier)) continue;
                                    data.updateAttribute(ModGearAttributes.SUFFIXES, Math.max(0, data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0) - 1));
                                    data.setRarity(VaultJewelCuttingStationTileEntity.getNewRarity(affixSize - 1));
                                    break;
                                }
                            }
                        } else if (arrayList2.size() > 0) {
                            for (VaultGearModifier vaultGearModifier : arrayList2) {
                                if (!data.removeModifier(vaultGearModifier)) continue;
                                data.updateAttribute(ModGearAttributes.SUFFIXES, Math.max(0, data.getFirstValue(ModGearAttributes.SUFFIXES).orElse(0) - 1));
                                data.setRarity(VaultJewelCuttingStationTileEntity.getNewRarity(affixSize - 1));
                                break;
                            }
                        } else {
                            for (VaultGearModifier vaultGearModifier : arrayList) {
                                if (!data.removeModifier(vaultGearModifier)) continue;
                                data.updateAttribute(ModGearAttributes.PREFIXES, Math.max(0, data.getFirstValue(ModGearAttributes.PREFIXES).orElse(0) - 1));
                                data.setRarity(VaultJewelCuttingStationTileEntity.getNewRarity(affixSize - 1));
                                break;
                            }
                        }
                        chipped = true;
                    } else {
                        this.breakJewel();
                        container.getJewelInputSlot().m_5852_(ItemStack.f_41583_);
                        broken = true;
                    }
                } else if (!(freeCuts <= 0 || stack.m_41784_().m_128441_("freeCuts") && stack.m_41784_().m_128451_("freeCuts") >= freeCuts)) {
                    stack.m_41784_().m_128405_("freeCuts", stack.m_41784_().m_128451_("freeCuts") + 1);
                }
                ItemStack itemStack = container.getScrapSlot().m_7993_();
                itemStack.m_41774_(this.getRecipeInput().getMainInput().m_41613_());
                container.getScrapSlot().m_5852_(itemStack);
                ItemStack itemStack2 = container.getBronzeSlot().m_7993_();
                itemStack2.m_41774_(this.getRecipeInput().getSecondInput().m_41613_());
                container.getBronzeSlot().m_5852_(itemStack2);
                Level level = this.m_58904_();
                if (level != null) {
                    if (broken) {
                        level.m_5594_(null, container.getTilePos(), ModSounds.JEWEL_CUT, SoundSource.BLOCKS, 0.8f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
                    } else {
                        if (chipped) {
                            level.m_5594_(null, container.getTilePos(), ModSounds.JEWEL_CUT, SoundSource.BLOCKS, 0.3f, level.f_46441_.nextFloat() * 0.1f + 0.7f);
                        } else {
                            level.m_5594_(null, container.getTilePos(), ModSounds.JEWEL_CUT, SoundSource.BLOCKS, 0.3f, level.f_46441_.nextFloat() * 0.1f + 0.7f);
                            level.m_5594_(null, container.getTilePos(), ModSounds.JEWEL_CUT_SUCCESS, SoundSource.BLOCKS, 0.2f, level.f_46441_.nextFloat() * 0.1f + 0.9f);
                        }
                        data.write(stack);
                        container.getJewelInputSlot().m_5852_(stack);
                    }
                }
            }
        }
    }

    public static VaultGearRarity getNewRarity(int size) {
        if (size == VaultGearRarity.SCRAPPY.getJewelModifierCount()) {
            return VaultGearRarity.SCRAPPY;
        }
        if (size == VaultGearRarity.COMMON.getJewelModifierCount()) {
            return VaultGearRarity.COMMON;
        }
        if (size == VaultGearRarity.EPIC.getJewelModifierCount()) {
            return VaultGearRarity.EPIC;
        }
        if (size == VaultGearRarity.RARE.getJewelModifierCount()) {
            return VaultGearRarity.RARE;
        }
        if (size == VaultGearRarity.OMEGA.getJewelModifierCount()) {
            return VaultGearRarity.OMEGA;
        }
        return VaultGearRarity.SCRAPPY;
    }

    private void breakJewel() {
        VaultJewelCuttingConfig.JewelCuttingOutput output = this.getRecipeOutput();
        if (output == null) {
            return;
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11914_, SoundSource.BLOCKS, 0.5f + new Random().nextFloat() * 0.25f, 0.75f + new Random().nextFloat() * 0.25f);
        }
        ItemStack input = this.inventory.m_8020_(0).m_41777_();
        VaultJewelCuttingStationTileEntity.addStackToSlot(this.inventory, 2, this.getUseRelatedOutput(input, output.generateMainOutput()));
        VaultJewelCuttingStationTileEntity.addStackToSlot(this.inventory, 3, this.getUseRelatedOutput(input, output.generateExtraOutput1()));
        VaultJewelCuttingStationTileEntity.addStackToSlot(this.inventory, 4, this.getUseRelatedOutput(input, output.generateExtraOutput2()));
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new JewelCuttingParticleMessage(this.m_58899_(), this.getJewelInput()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnBreakParticles(BlockPos pos, ItemStack stack) {
        Vec3 offset;
        Random random;
        int i;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (i = 0; i < 4; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.nextDouble() * (double)0.15f + 0.25, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 2.0, random.nextDouble() * 0.1, offset.f_82481_ / 2.0);
        }
        for (i = 0; i < 3; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_7494_().m_123342_() + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 20.0, random.nextDouble() * 0.2, offset.f_82481_ / 20.0);
        }
        for (i = 0; i < 3; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_7494_().m_123342_() + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 20.0, random.nextDouble() * 0.2, offset.f_82481_ / 20.0);
        }
        for (i = 0; i < 3; ++i) {
            random = level.m_5822_();
            offset = new Vec3(random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1));
            level.m_6493_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_7494_().m_123342_() + random.nextDouble() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 10.0, random.nextDouble() * 0.05, offset.f_82481_ / 10.0);
        }
    }

    public static void addStackToSlot(Container inventory, int slot, ItemStack toAdd) {
        if (toAdd.m_41619_()) {
            return;
        }
        ItemStack stack = inventory.m_8020_(slot);
        if (stack.m_41619_()) {
            inventory.m_6836_(slot, toAdd.m_41777_());
            return;
        }
        if (VaultJewelCuttingStationTileEntity.canMerge(stack, toAdd)) {
            stack.m_41769_(toAdd.m_41613_());
            inventory.m_6836_(slot, stack);
        }
    }

    public static boolean canMerge(ItemStack stack, ItemStack other) {
        return stack.m_41720_() == other.m_41720_() && ItemStack.m_41658_((ItemStack)stack, (ItemStack)other);
    }

    public boolean canCraft() {
        VaultJewelCuttingConfig.JewelCuttingOutput output = this.getRecipeOutput();
        VaultJewelCuttingConfig.JewelCuttingInput input = this.getRecipeInput();
        if (input == null || output == null) {
            return false;
        }
        if (this.inventory.m_8020_(0).m_41613_() < input.getMainInput().m_41613_() || !VaultJewelCuttingStationTileEntity.canMerge(this.inventory.m_8020_(0), input.getMainInput())) {
            return false;
        }
        if (this.inventory.m_8020_(1).m_41613_() < input.getSecondInput().m_41613_() || !VaultJewelCuttingStationTileEntity.canMerge(this.inventory.m_8020_(1), input.getSecondInput())) {
            return false;
        }
        if (!MiscUtils.canFullyMergeIntoSlot(this.inventory, 2, output.getMainOutputMatching())) {
            return false;
        }
        if (!MiscUtils.canFullyMergeIntoSlot(this.inventory, 3, output.getExtraOutput1Matching())) {
            return false;
        }
        return MiscUtils.canFullyMergeIntoSlot(this.inventory, 4, output.getExtraOutput2Matching());
    }

    public VaultJewelCuttingConfig.JewelCuttingOutput getRecipeOutput() {
        return ModConfigs.VAULT_JEWEL_CUTTING_CONFIG.getJewelCuttingOutput();
    }

    public VaultJewelCuttingConfig.JewelCuttingInput getRecipeInput() {
        return ModConfigs.VAULT_JEWEL_CUTTING_CONFIG.getJewelCuttingInput();
    }

    public VaultJewelCuttingConfig.JewelCuttingRange getJewelCuttingRange() {
        return ModConfigs.VAULT_JEWEL_CUTTING_CONFIG.getJewelCuttingRange();
    }

    public float getJewelCuttingModifierRemovalChance() {
        return ModConfigs.VAULT_JEWEL_CUTTING_CONFIG.getJewelCuttingModifierRemovalChance();
    }

    private ItemStack getUseRelatedOutput(ItemStack input, ItemStack output) {
        float out = output.m_41613_();
        int resultCount = Mth.m_14143_((float)out);
        if (resultCount < 1 && out > 0.0f) {
            Random random = new Random();
            if (random.nextFloat() < out) {
                ++resultCount;
            }
        }
        ItemStack copyOut = output.m_41777_();
        copyOut.m_41764_(resultCount);
        return copyOut;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inv, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return new VaultJewelCuttingStationContainer(containerId, this.m_58904_(), this.m_58899_(), inv);
    }
}

