/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.entity.base;

import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.config.recipe.ForgeRecipeType;
import iskallia.vault.container.oversized.OverSizedInventory;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ForgeRecipeTileEntity
extends BlockEntity
implements MenuProvider {
    private final OverSizedInventory inventory;
    private final ResultContainer output = new ResultContainer(){

        public void m_6596_() {
            super.m_6596_();
            ForgeRecipeTileEntity.this.m_6596_();
        }
    };
    private final ForgeRecipeType[] supportedRecipeTypes;

    public ForgeRecipeTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize, ForgeRecipeType ... supportedRecipeTypes) {
        super(type, pos, state);
        this.inventory = new OverSizedInventory(inventorySize, this);
        this.supportedRecipeTypes = supportedRecipeTypes;
    }

    public OverSizedInventory getInventory() {
        return this.inventory;
    }

    public ResultContainer getResultContainer() {
        return this.output;
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2);

    public ForgeRecipeType[] getSupportedRecipeTypes() {
        return this.supportedRecipeTypes;
    }

    public boolean stillValid(Player player) {
        if (this.m_58904_() == null || this.m_58904_().m_7702_(this.m_58899_()) != this) {
            return false;
        }
        return this.getInventory().m_6542_(player);
    }

    public Component m_5446_() {
        return this.m_58900_().m_60734_().m_49954_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        if (this.m_58904_() == null) {
            return null;
        }
        return this.createMenu(windowId, playerInventory);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.getInventory().load(tag);
        this.getResultContainer().m_6836_(0, ItemStack.m_41712_((CompoundTag)tag.m_128469_("result")));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.getInventory().save(tag);
        tag.m_128365_("result", (Tag)this.getResultContainer().m_8020_(0).serializeNBT());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnForgeParticles(BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            Random random = level.m_5822_();
            Direction direction = level.m_8055_(pos).m_61138_((Property)FacedBlock.FACING) ? (Direction)level.m_8055_(pos).m_61143_((Property)FacedBlock.FACING) : Direction.NORTH;
            Direction.Axis direction$axis = direction.m_122434_();
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            double d3 = -0.52;
            double d4 = random.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * d3 : d4;
            double d6 = random.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * d3 : d4;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + d5, y + d6, z + d7, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, x + d5, y + d6, z + d7, 0.0, 0.0, 0.0);
        }
    }
}

