/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.item;

import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LootStatueBlockItem
extends BlockItem {
    public LootStatueBlockItem(Block block) {
        super(block, new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> toolTip, TooltipFlag flagIn) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("BlockEntityTag", 10)) {
            this.addStatueInformation(nbt.m_128469_("BlockEntityTag"), toolTip);
        }
        super.m_7373_(stack, worldIn, toolTip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addStatueInformation(CompoundTag dataTag, List<Component> toolTip) {
        if (dataTag.m_128441_("PlayerNickname")) {
            String nickname = dataTag.m_128461_("PlayerNickname");
            toolTip.add((Component)new TextComponent("Player: "));
            toolTip.add((Component)new TextComponent("- ").m_7220_((Component)new TextComponent(nickname).m_130940_(ChatFormatting.GOLD)));
        }
        MutableComponent itemDescriptor = new TextComponent("NOT SELECTED").m_130940_(ChatFormatting.RED);
        if (dataTag.m_128441_("LootItem")) {
            ItemStack lootItem = ItemStack.m_41712_((CompoundTag)dataTag.m_128469_("LootItem"));
            itemDescriptor = new TextComponent(lootItem.m_41786_().getString()).m_130940_(ChatFormatting.GREEN);
        }
        toolTip.add(TextComponent.f_131282_);
        toolTip.add((Component)new TextComponent("Item: ").m_130940_(ChatFormatting.WHITE));
        toolTip.add((Component)new TextComponent("- ").m_7220_((Component)itemDescriptor));
    }

    public static ItemStack getStatueBlockItem(String nickname) {
        ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.LOOT_STATUE_ITEM);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("PlayerNickname", nickname);
        ItemStack loot = ModConfigs.STATUE_LOOT.randomLoot();
        nbt.m_128365_("LootItem", (Tag)loot.serializeNBT());
        CompoundTag stackNBT = new CompoundTag();
        stackNBT.m_128365_("BlockEntityTag", (Tag)nbt);
        itemStack.m_41751_(stackNBT);
        return itemStack;
    }

    public ItemStack m_7968_() {
        return LootStatueBlockItem.getStatueBlockItem("Steve");
    }

    protected boolean m_40610_(BlockPlaceContext pContext, BlockState pState) {
        return super.m_40610_(pContext, pState);
    }

    private boolean isInitialized(ItemStack stack) {
        return stack.m_41782_() && stack.m_41737_("BlockEntityTag") != null;
    }
}

