/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.item;

import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.WeekKey;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrophyStatueBlockItem
extends BlockItem {
    public TrophyStatueBlockItem(Block block) {
        super(block, new Item.Properties().m_41491_(ModItems.VAULT_MOD_GROUP).m_41487_(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> toolTip, TooltipFlag flagIn) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128425_("BlockEntityTag", 10)) {
            this.addStatueInformation(nbt.m_128469_("BlockEntityTag"), toolTip);
        }
        super.m_7373_(stack, worldIn, toolTip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addStatueInformation(CompoundTag dataTag, List<Component> toolTip) {
        WeekKey week = WeekKey.deserialize(dataTag.m_128469_("trophyWeek"));
        PlayerVaultStatsData.PlayerRecordEntry recordEntry = PlayerVaultStatsData.PlayerRecordEntry.deserialize(dataTag.m_128469_("recordEntry"));
        TextComponent weekCmp = new TextComponent(week.getWeek() + " / " + week.getYear());
        MutableComponent recordCmp = new TextComponent(UIHelper.formatTimeString(recordEntry.getTickCount())).m_130940_(ChatFormatting.GOLD);
        toolTip.add(TextComponent.f_131282_);
        toolTip.add((Component)new TextComponent("Week: ").m_7220_((Component)weekCmp));
        toolTip.add((Component)new TextComponent("Record: ").m_7220_((Component)recordCmp));
    }

    public static ItemStack getTrophy(ServerLevel serverWorld, WeekKey week) {
        PlayerVaultStatsData statsData = PlayerVaultStatsData.get(serverWorld);
        PlayerVaultStatsData.PlayerRecordEntry record = statsData.getFastestVaultTime(week);
        if (StringUtil.m_14408_((String)record.getPlayerName())) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.TROPHY_STATUE);
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("PlayerNickname", record.getPlayerName());
        nbt.m_128365_("TrophyWeek", (Tag)week.serialize());
        nbt.m_128365_("RecordEntry", (Tag)record.serialize());
        CompoundTag stackNBT = new CompoundTag();
        stackNBT.m_128365_("BlockEntityTag", (Tag)nbt);
        stack.m_41751_(stackNBT);
        return stack;
    }

    public ItemStack m_7968_() {
        return super.m_7968_();
    }

    protected boolean m_40610_(BlockPlaceContext ctx, BlockState state) {
        if (!ctx.m_43722_().m_41782_()) {
            return false;
        }
        CompoundTag tag = ctx.m_43722_().m_41784_();
        CompoundTag blockTag = tag.m_128469_("BlockEntityTag");
        if (!blockTag.m_128425_("PlayerNickname", 8) || !blockTag.m_128425_("StatueType", 3)) {
            return false;
        }
        return super.m_40610_(ctx, state);
    }
}

