/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.block.entity.AlchemyTableTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class AlchemyTableRenderer
implements BlockEntityRenderer<AlchemyTableTileEntity> {
    public AlchemyTableRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(AlchemyTableTileEntity table, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level world = table.m_58904_();
        if (world == null) {
            return;
        }
        ItemStack itemStack = table.getInventory().m_8020_(0).m_41777_();
        int craftingOutputCooldown = table.getCraftingOutputCooldown();
        if (table.isCrafting() && craftingOutputCooldown > 20) {
            itemStack = table.getFakeItemStack();
        }
        matrixStack.m_85836_();
        this.renderPotion(matrixStack, buffer, combinedLight, combinedOverlay, 0.725f, 0.45f, itemStack, table, partialTicks, craftingOutputCooldown);
        matrixStack.m_85849_();
    }

    private void renderPotion(PoseStack matrixStack, MultiBufferSource buffer, int lightLevel, int overlay, float yOffset, float scale, ItemStack itemStack, AlchemyTableTileEntity table, float partialTicks, int craftingOutputCooldown) {
        Minecraft minecraft = Minecraft.m_91087_();
        float extraDegrees = 0.0f;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, (double)yOffset, 0.5);
        if (craftingOutputCooldown > 0 && craftingOutputCooldown < AlchemyTableTileEntity.CRAFTING_COOLDOWN - 10) {
            float f = 1.0f - (float)craftingOutputCooldown / (float)(AlchemyTableTileEntity.CRAFTING_COOLDOWN - 10);
            f = AlchemyTableTileEntity.ease(f);
            matrixStack.m_85837_(0.0, Math.sin((double)f * Math.PI / 1.5) / 8.0, 0.0);
        }
        if (craftingOutputCooldown > 0) {
            extraDegrees = Mth.m_14179_((float)partialTicks, (float)table.getExtraSpinDegreesPrev(), (float)table.getExtraSpinDegrees());
        }
        matrixStack.m_85841_(scale, scale, scale);
        Direction facingDirection = (Direction)table.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        int degrees = facingDirection == Direction.NORTH || facingDirection == Direction.SOUTH ? 90 : 0;
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)(degrees + 45) + extraDegrees));
        BakedModel bakedModel = minecraft.m_91291_().m_174264_(itemStack, null, null, 0);
        minecraft.m_91291_().m_115143_(itemStack, ItemTransforms.TransformType.FIXED, true, matrixStack, buffer, lightLevel, overlay, bakedModel);
        matrixStack.m_85849_();
    }
}

