/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.AngelBlockTileEntity;
import iskallia.vault.entity.model.ModModelLayers;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.Level;

public class AngelBlockRenderer
implements BlockEntityRenderer<AngelBlockTileEntity> {
    public static final Material ANGEL_OUTTER = new Material(TextureAtlas.f_118259_, VaultMod.id("entity/angel/angel_outter"));
    public static final Material ANGEL_OUTTER2 = new Material(TextureAtlas.f_118259_, VaultMod.id("entity/angel/angel_outter2"));
    public static final Material ANGEL_WIND = new Material(TextureAtlas.f_118259_, VaultMod.id("entity/angel/angel_wind"));
    public static final Material ANGEL_WIND_VERTICAL = new Material(TextureAtlas.f_118259_, VaultMod.id("entity/angel/angel_wind_vertical"));
    public static final Material ANGEL_CENTER = new Material(TextureAtlas.f_118259_, VaultMod.id("entity/angel/angel_center"));
    private final ModelPart eye;
    private final ModelPart wind;
    private final ModelPart cage;
    private final BlockEntityRenderDispatcher renderer;

    public AngelBlockRenderer(BlockEntityRendererProvider.Context pContext) {
        this.renderer = pContext.m_173581_();
        this.eye = pContext.m_173582_(ModModelLayers.ANGEL_BLOCK_EYE);
        this.wind = pContext.m_173582_(ModModelLayers.ANGEL_BLOCK_WIND);
        this.cage = pContext.m_173582_(ModModelLayers.ANGEL_BLOCK_CAGE);
    }

    public ModelPart getCage() {
        return this.cage;
    }

    public ModelPart getWind() {
        return this.wind;
    }

    public ModelPart getEye() {
        return this.eye;
    }

    public static LayerDefinition createEyeLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("eye", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.01f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public static LayerDefinition createWindLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("wind", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public static LayerDefinition createCageLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("shell", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)16);
    }

    public void render(AngelBlockTileEntity pBlockEntity, float partialTicks, @Nonnull PoseStack pPoseStack, @Nonnull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Level world = pBlockEntity.m_58904_();
        pPackedLight = 0xF000F0;
        if (world == null) {
            return;
        }
        float f = (float)pBlockEntity.tickCount + partialTicks;
        float f1 = pBlockEntity.getActiveRotation(partialTicks) * 57.295776f;
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.5, 0.5, 0.5);
        Vector3f vector3f = new Vector3f(0.5f, 1.0f, 0.5f);
        vector3f.m_122278_();
        pPoseStack.m_85836_();
        pPoseStack.m_85845_(vector3f.m_122240_(f1));
        this.cage.m_104301_(pPoseStack, ANGEL_OUTTER.m_119194_(pBufferSource, RenderType::m_110458_), pPackedLight, pPackedOverlay);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        float scale = 1.5f;
        pPoseStack.m_85841_(scale, scale, scale);
        pPoseStack.m_85836_();
        pPoseStack.m_85845_(vector3f.m_122240_(-f1));
        this.cage.m_104301_(pPoseStack, ANGEL_OUTTER.m_119194_(pBufferSource, RenderType::m_110458_), pPackedLight, pPackedOverlay);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85841_(1.1f, 1.1f, 1.1f);
        pPoseStack.m_85845_(vector3f.m_122240_(-f1));
        this.cage.m_104301_(pPoseStack, ANGEL_OUTTER2.m_119194_(pBufferSource, RenderType::m_110458_), pPackedLight, pPackedOverlay);
        pPoseStack.m_85849_();
        pPoseStack.m_85849_();
        pPoseStack.m_85849_();
        boolean i = true;
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.5, 0.5, 0.5);
        pPoseStack.m_85845_(vector3f.m_122240_(-f1));
        pPoseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        VertexConsumer vertexconsumer = ANGEL_WIND_VERTICAL.m_119194_(pBufferSource, RenderType::m_110458_);
        this.wind.m_104301_(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        pPoseStack.m_85849_();
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.5, 0.5, 0.5);
        pPoseStack.m_85841_(0.875f, 0.875f, 0.875f);
        vertexconsumer = ANGEL_WIND.m_119194_(pBufferSource, RenderType::m_110458_);
        pPoseStack.m_85845_(vector3f.m_122240_(-f1));
        this.wind.m_104301_(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        pPoseStack.m_85849_();
        Camera camera = this.renderer.f_112249_;
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.5, 0.5, 0.5);
        pPoseStack.m_85841_(0.5f, 0.5f, 0.5f);
        float f3 = -camera.m_90590_();
        pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(f3));
        pPoseStack.m_85845_(Vector3f.f_122223_.m_122240_(camera.m_90589_()));
        pPoseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        float f4 = 1.3333334f;
        pPoseStack.m_85841_(f4, f4, f4);
        this.eye.m_104301_(pPoseStack, ANGEL_CENTER.m_119194_(pBufferSource, RenderType::m_110458_), pPackedLight, pPackedOverlay);
        pPoseStack.m_85849_();
    }
}

