/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.block.BlackMarketBlock;
import iskallia.vault.block.entity.AnimalPenTileEntity;
import iskallia.vault.client.gui.framework.text.TextBorder;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;

public class AnimalPenRenderer
implements BlockEntityRenderer<AnimalPenTileEntity> {
    public static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    private final Minecraft mc = Minecraft.m_91087_();
    private final BlockRenderDispatcher blockRenderer = this.mc.m_91289_();

    public AnimalPenRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(AnimalPenTileEntity animalPenTile, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Sheep sheep;
        int rot;
        ItemStack invItem;
        CompoundTag tag;
        Level world = animalPenTile.m_58904_();
        if (world == null) {
            return;
        }
        Direction dir = (Direction)animalPenTile.m_58900_().m_61143_((Property)BlackMarketBlock.f_54117_);
        Item item = animalPenTile.getInventory().m_8020_(1).m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            matrixStack.m_85836_();
            float scale = 0.625f;
            matrixStack.m_85841_(scale, 0.125f, scale);
            matrixStack.m_85837_((double)(0.1875f / scale), 0.015625, (double)(0.1875f / scale));
            AnimalPenRenderer.renderBlockState(blockItem.m_40614_().m_49966_(), matrixStack, buffer, this.blockRenderer, animalPenTile.m_58904_(), animalPenTile.m_58899_());
            matrixStack.m_85849_();
        }
        Animal animal = animalPenTile.getAnimalToReference();
        Animal dyingAnimal = animalPenTile.getDyingAnimalToReference();
        if (animal instanceof Bee) {
            int rotate = 0;
            if (dir == Direction.EAST) {
                rotate = 90;
            }
            if (dir == Direction.NORTH) {
                rotate = 180;
            }
            if (dir == Direction.WEST) {
                rotate = 270;
            }
            matrixStack.m_85836_();
            tag = animalPenTile.getInventory().m_8020_(0).m_41784_();
            int honeyLevel = 0;
            if (tag.m_128441_("honeyLevel")) {
                honeyLevel = tag.m_128451_("honeyLevel");
            }
            float offsetx = (float)Math.sin(Math.toRadians(rotate)) / 3.0f;
            float offsetz = (float)Math.cos(Math.toRadians(rotate)) / 3.0f;
            float scale = 0.5f;
            matrixStack.m_85841_(scale, scale, scale);
            matrixStack.m_85837_((double)(0.25f / scale - offsetx / scale), 0.28125, (double)(0.25f / scale - offsetz / scale));
            AnimalPenRenderer.renderBlockState(Blocks.f_50479_.m_49966_(), matrixStack, buffer, this.blockRenderer, animalPenTile.m_58904_(), animalPenTile.m_58899_());
            matrixStack.m_85837_(0.0, 0.75, 0.0);
            AnimalPenRenderer.renderBlockState((BlockState)((BlockState)Blocks.f_50718_.m_49966_().m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(honeyLevel))).m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)dir), matrixStack, buffer, this.blockRenderer, animalPenTile.m_58904_(), animalPenTile.m_58899_());
            matrixStack.m_85849_();
        }
        if ((invItem = animalPenTile.getInventory().m_8020_(0)).m_41782_() && !(tag = invItem.m_41784_()).m_128441_("turtleEggTimer") && animal instanceof Turtle) {
            int count = Mth.m_14045_((int)((tag.m_128451_("count") + 1) / 2), (int)1, (int)16);
            AnimalPenRenderer.renderTurtleEggs(dir, matrixStack, animalPenTile, buffer, this.blockRenderer, count);
        }
        this.mc.m_91290_().m_114468_(false);
        if (this.mc.f_91074_ != null && this.mc.f_91074_.m_6047_()) {
            matrixStack.m_85836_();
            Vec3 lookAngle = this.mc.f_91074_.m_20154_();
            if (this.mc.f_91075_ != null) {
                lookAngle = this.mc.f_91075_.m_20154_();
            }
            dir = Direction.m_122366_((double)lookAngle.f_82479_, (double)0.0, (double)lookAngle.f_82481_);
            rot = 0;
            if (dir == Direction.WEST) {
                rot = 90;
            }
            if (dir == Direction.SOUTH) {
                rot = 180;
            }
            if (dir == Direction.EAST) {
                rot = 270;
            }
            ArrayList<Object> components = new ArrayList<Object>();
            if (animal != null) {
                components.add(animal.m_6095_().m_20676_());
                if (invItem.m_41782_()) {
                    CompoundTag tag2 = invItem.m_41784_();
                    if (tag2.m_128441_("count")) {
                        components.add(new TextComponent("count: " + tag2.m_128451_("count")));
                    }
                    if (tag2.m_128441_("breedTimer")) {
                        int time = tag2.m_128451_("breedTimer");
                        components.add(new TextComponent("breed in: " + LocalTime.of(0, 0, 0).plusSeconds(time / 20).format(FORMATTER)));
                    }
                    if (tag2.m_128441_("shearTimer")) {
                        int time = tag2.m_128451_("shearTimer");
                        components.add(new TextComponent("wool in: " + LocalTime.of(0, 0, 0).plusSeconds(time / 20).format(FORMATTER)));
                    }
                    if (tag2.m_128441_("eggTimer")) {
                        int time = tag2.m_128451_("eggTimer");
                        components.add(new TextComponent("eggs in: " + LocalTime.of(0, 0, 0).plusSeconds(time / 20).format(FORMATTER)));
                    } else if (animal instanceof Chicken) {
                        components.add(new TextComponent("Eggs ready!"));
                        components.add(new TextComponent("(grab a bucket)"));
                    }
                    if (tag2.m_128441_("turtleEggTimer")) {
                        int time = tag2.m_128451_("turtleEggTimer");
                        components.add(new TextComponent("eggs in: " + LocalTime.of(0, 0, 0).plusSeconds(time / 20).format(FORMATTER)));
                    } else if (animal instanceof Turtle) {
                        components.add(new TextComponent("Eggs ready!"));
                        components.add(new TextComponent("(grab a bucket)"));
                    }
                    if (tag2.m_128441_("honeyLevel")) {
                        int level = tag2.m_128451_("honeyLevel");
                        components.add(new TextComponent("honey level: " + level));
                    }
                    if (tag2.m_128441_("honeyReady") && tag2.m_128471_("honeyReady")) {
                        components.add(new TextComponent("Honey ready!"));
                    } else if (tag2.m_128441_("pollenTimer")) {
                        int time = tag2.m_128451_("pollenTimer");
                        components.add(new TextComponent("gathering pollen: " + LocalTime.of(0, 0, 0).plusSeconds(time / 20).format(FORMATTER)));
                    }
                }
            } else {
                components.add(new TextComponent("No Animal"));
            }
            float offset = (float)components.size() * 0.1f - 0.1f;
            int animalCount = 0;
            if (animalPenTile.getInventory().m_8020_(0).m_41782_() && animalPenTile.getInventory().m_8020_(0).m_41784_().m_128441_("count")) {
                animalCount = animalPenTile.getInventory().m_8020_(0).m_41784_().m_128451_("count");
            }
            matrixStack.m_85837_(0.5, 0.65 + 0.65 * (double)((float)animalCount / 1000.0f), 0.5);
            matrixStack.m_85837_(0.0, 0.3333333432674408 + (double)offset, 0.046666666865348816);
            matrixStack.m_85841_(0.010416667f, -0.010416667f, 0.010416667f);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)rot));
            for (int i = 0; i < components.size(); ++i) {
                FormattedCharSequence $$25 = ((Component)components.get(i)).m_7532_();
                float $$26 = -TextBorder.DEFAULT_FONT.get().m_92724_($$25) / 2;
                TextBorder.DEFAULT_FONT.get().m_168645_($$25, $$26, (float)(i * 10 - 20), TextBorder.DEFAULT_COLOR.m_131265_(), TextBorder.DEFAULT_BORDER_COLOR.m_131265_(), matrixStack.m_85850_().m_85861_(), buffer, 0xF000F0);
            }
            matrixStack.m_85849_();
        }
        if (dyingAnimal != null) {
            List<Integer> deathTime;
            if (dyingAnimal instanceof Sheep) {
                sheep = (Sheep)dyingAnimal;
                sheep.m_29878_(invItem.m_41782_() && invItem.m_41783_().m_128441_("shearTimer"));
            }
            if (!(deathTime = animalPenTile.getDeathTime()).isEmpty()) {
                int rotate;
                dir = (Direction)animalPenTile.m_58900_().m_61143_((Property)BlackMarketBlock.f_54117_);
                rot = 0;
                if (dir == Direction.WEST) {
                    rot = 90;
                }
                if (dir == Direction.NORTH) {
                    rot = 180;
                }
                if (dir == Direction.EAST) {
                    rot = 270;
                }
                float yBodyRot = dyingAnimal.f_20883_;
                float yBodyRotO = dyingAnimal.f_20884_;
                float yRot = dyingAnimal.m_146908_();
                float xRot = dyingAnimal.m_146909_();
                float yHeadRotO = dyingAnimal.f_20886_;
                float yHeadRot = dyingAnimal.f_20885_;
                int count = 0;
                if (animalPenTile.getInventory().m_8020_(0).m_41782_() && animalPenTile.getInventory().m_8020_(0).m_41784_().m_128441_("count")) {
                    count = animalPenTile.getInventory().m_8020_(0).m_41784_().m_128451_("count");
                }
                float scale = 0.55f / dyingAnimal.m_20205_();
                scale = 0.55f + (scale - 0.55f) / 2.0f;
                scale += scale * ((float)count / 1000.0f);
                float offsetx = 0.0f;
                float offsety = 0.0f;
                float offsetz = 0.0f;
                if (animal instanceof Bee) {
                    rotate = 0;
                    if (dir == Direction.EAST) {
                        rotate = 90;
                    }
                    if (dir == Direction.NORTH) {
                        rotate = 180;
                    }
                    if (dir == Direction.WEST) {
                        rotate = 270;
                    }
                    offsetx = (float)Math.sin(Math.toRadians(rotate)) / 2.5f;
                    offsetz = (float)Math.cos(Math.toRadians(rotate)) / 2.5f;
                    offsety = 0.25f;
                }
                if (animal instanceof Turtle) {
                    rotate = 0;
                    if (dir == Direction.EAST) {
                        rotate = 90;
                    }
                    if (dir == Direction.NORTH) {
                        rotate = 180;
                    }
                    if (dir == Direction.WEST) {
                        rotate = 270;
                    }
                    offsetx = (float)(-Math.sin(Math.toRadians(rotate))) / 40.0f;
                    offsetz = (float)(-Math.cos(Math.toRadians(rotate))) / 40.0f;
                    offsety = 0.0f;
                    scale *= 0.65f;
                }
                dyingAnimal.f_20883_ = rot;
                dyingAnimal.f_20884_ = rot;
                dyingAnimal.m_146922_((float)rot);
                dyingAnimal.m_146926_(0.0f);
                dyingAnimal.f_19860_ = 0.0f;
                dyingAnimal.f_20885_ = dyingAnimal.m_146908_();
                dyingAnimal.f_20886_ = dyingAnimal.m_146908_();
                dyingAnimal.f_20923_ = 0.0f;
                dyingAnimal.f_20924_ = 0.0f;
                dyingAnimal.f_20925_ = 0.0f;
                dyingAnimal.f_19797_ = animalPenTile.getTickCount();
                matrixStack.m_85836_();
                matrixStack.m_85841_(scale, scale, scale);
                float finalScale = scale;
                float finalOffsetx = offsetx;
                float finalOffsetz = offsetz;
                float finalOffsety = offsety;
                deathTime.forEach(integer -> {
                    dyingAnimal.f_20919_ = integer;
                    Minecraft.m_91087_().m_91290_().m_114384_((Entity)dyingAnimal, (double)(0.5f / finalScale + finalOffsetx / finalScale), (double)(0.125f / finalScale + finalOffsety / finalScale), (double)(0.5f / finalScale + finalOffsetz / finalScale), 0.0f, Minecraft.m_91087_().m_91296_(), matrixStack, buffer, combinedLight);
                });
                matrixStack.m_85849_();
                dyingAnimal.f_20883_ = yBodyRot;
                dyingAnimal.f_20884_ = yBodyRotO;
                dyingAnimal.m_146922_(yRot);
                dyingAnimal.m_146926_(xRot);
                dyingAnimal.f_20886_ = yHeadRotO;
                dyingAnimal.f_20885_ = yHeadRot;
            }
        }
        if (animal == null) {
            return;
        }
        if (animal instanceof Sheep) {
            sheep = (Sheep)animal;
            sheep.m_29878_(invItem.m_41782_() && invItem.m_41783_().m_128441_("shearTimer"));
        }
        dir = (Direction)animalPenTile.m_58900_().m_61143_((Property)BlackMarketBlock.f_54117_);
        int rot2 = 0;
        if (dir == Direction.WEST) {
            rot2 = 90;
        }
        if (dir == Direction.NORTH) {
            rot2 = 180;
        }
        if (dir == Direction.EAST) {
            rot2 = 270;
        }
        float yBodyRot = animal.f_20883_;
        float yBodyRotO = animal.f_20884_;
        float yRot = animal.m_146908_();
        float xRot = animal.m_146909_();
        float yHeadRotO = animal.f_20886_;
        float yHeadRot = animal.f_20885_;
        int count = 0;
        if (animalPenTile.getInventory().m_8020_(0).m_41782_() && animalPenTile.getInventory().m_8020_(0).m_41784_().m_128441_("count")) {
            count = animalPenTile.getInventory().m_8020_(0).m_41784_().m_128451_("count");
        }
        float scale = 0.55f / animal.m_20205_();
        scale = 0.55f + (scale - 0.55f) / 2.0f;
        scale += scale * ((float)count / 1000.0f);
        float offsetx = 0.0f;
        float offsety = 0.0f;
        float offsetz = 0.0f;
        if (animal instanceof Bee) {
            Bee bee = (Bee)animal;
            int rotate = 0;
            if (dir == Direction.EAST) {
                rotate = 90;
            }
            if (dir == Direction.NORTH) {
                rotate = 180;
            }
            if (dir == Direction.WEST) {
                rotate = 270;
            }
            offsetx = (float)(-Math.sin(Math.toRadians(rotate))) / 20.0f;
            offsetz = (float)(-Math.cos(Math.toRadians(rotate))) / 20.0f;
            offsety = 0.25f;
        }
        if (animal instanceof Turtle) {
            int rotate = 0;
            if (dir == Direction.EAST) {
                rotate = 90;
            }
            if (dir == Direction.NORTH) {
                rotate = 180;
            }
            if (dir == Direction.WEST) {
                rotate = 270;
            }
            offsetx = (float)(-Math.sin(Math.toRadians(rotate))) / 40.0f;
            offsetz = (float)(-Math.cos(Math.toRadians(rotate))) / 40.0f;
            offsety = 0.0f;
            scale *= 0.65f;
        }
        animal.f_20883_ = rot2;
        animal.f_20884_ = rot2;
        animal.m_146922_((float)rot2);
        animal.m_146926_(0.0f);
        animal.f_19860_ = 0.0f;
        animal.f_20885_ = animal.m_146908_();
        animal.f_20886_ = animal.m_146908_();
        matrixStack.m_85836_();
        matrixStack.m_85841_(scale, scale, scale);
        animal.f_20919_ = 0;
        animal.f_20923_ = 0.0f;
        animal.f_20924_ = 0.0f;
        animal.f_20925_ = 0.0f;
        animal.f_19797_ = animalPenTile.getTickCount();
        this.mc.m_91290_().m_114384_((Entity)animal, (double)(0.5f / scale + offsetx / scale), (double)(0.125f / scale + offsety / scale), (double)(0.5f / scale + offsetz / scale), 0.0f, this.mc.m_91296_(), matrixStack, buffer, combinedLight);
        matrixStack.m_85849_();
        animal.f_20883_ = yBodyRot;
        animal.f_20884_ = yBodyRotO;
        animal.m_146922_(yRot);
        animal.m_146926_(xRot);
        animal.f_20886_ = yHeadRotO;
        animal.f_20885_ = yHeadRot;
        this.mc.m_91290_().m_114468_(true);
    }

    private static void renderBlockState(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, Level world, BlockPos pos) {
        try {
            for (RenderType type : RenderType.m_110506_()) {
                if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                AnimalPenRenderer.renderBlockState(state, matrixStack, buffer, blockRenderer, world, pos, type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderBlockState(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, Level world, BlockPos pos, RenderType type) {
        ForgeHooksClient.setRenderType((RenderType)type);
        blockRenderer.m_110937_().m_111047_((BlockAndTintGetter)world, blockRenderer.m_110910_(state), state, pos, matrixStack, buffer.m_6299_(type), false, world.f_46441_, 0L, OverlayTexture.f_118083_);
        ForgeHooksClient.setRenderType(null);
    }

    public static void renderTurtleEggs(Direction dir, PoseStack matrixStack, AnimalPenTileEntity animalPenTile, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, int count) {
        float scale;
        float offsetz;
        float offsetx;
        ArrayList<Integer> eggs = new ArrayList<Integer>();
        while (count > 0) {
            if (count >= 4) {
                eggs.add(4);
                count -= 4;
                continue;
            }
            eggs.add(count);
            count = 0;
        }
        int rotate = 0;
        if (dir == Direction.EAST) {
            rotate = 90;
        }
        if (dir == Direction.NORTH) {
            rotate = 180;
        }
        if (dir == Direction.WEST) {
            rotate = 270;
        }
        if (eggs.size() > 0 && (Integer)eggs.get(0) >= 0) {
            matrixStack.m_85836_();
            offsetx = (float)Math.sin(Math.toRadians(rotate - 30)) / 3.5f;
            offsetz = (float)Math.cos(Math.toRadians(rotate - 30)) / 3.5f;
            scale = 0.25f;
            matrixStack.m_85841_(scale, scale, scale);
            matrixStack.m_85837_((double)(0.375f / scale + offsetx / scale), 0.4375, (double)(0.375f / scale + offsetz / scale));
            AnimalPenRenderer.renderBlockState((BlockState)Blocks.f_50578_.m_49966_().m_61124_((Property)TurtleEggBlock.f_57754_, (Comparable)((Integer)eggs.get(0))), matrixStack, buffer, blockRenderer, animalPenTile.m_58904_(), animalPenTile.m_58899_());
            matrixStack.m_85849_();
        }
        if (eggs.size() > 1 && (Integer)eggs.get(1) >= 0) {
            offsetx = (float)Math.sin(Math.toRadians(rotate + 30)) / 3.5f;
            offsetz = (float)Math.cos(Math.toRadians(rotate + 30)) / 3.5f;
            scale = 0.25f;
            matrixStack.m_85836_();
            matrixStack.m_85841_(scale, scale, scale);
            matrixStack.m_85837_((double)(0.375f / scale + offsetx / scale), 0.4375, (double)(0.375f / scale + offsetz / scale));
            AnimalPenRenderer.renderBlockState((BlockState)Blocks.f_50578_.m_49966_().m_61124_((Property)TurtleEggBlock.f_57754_, (Comparable)((Integer)eggs.get(1))), matrixStack, buffer, blockRenderer, animalPenTile.m_58904_(), animalPenTile.m_58899_());
            matrixStack.m_85849_();
        }
        if (eggs.size() > 2 && (Integer)eggs.get(2) >= 0) {
            offsetx = (float)Math.sin(Math.toRadians(rotate - 60)) / 3.5f;
            offsetz = (float)Math.cos(Math.toRadians(rotate - 60)) / 3.5f;
            scale = 0.25f;
            matrixStack.m_85836_();
            matrixStack.m_85841_(scale, scale, scale);
            matrixStack.m_85837_((double)(0.375f / scale + offsetx / scale), 0.4375, (double)(0.375f / scale + offsetz / scale));
            AnimalPenRenderer.renderBlockState((BlockState)Blocks.f_50578_.m_49966_().m_61124_((Property)TurtleEggBlock.f_57754_, (Comparable)((Integer)eggs.get(2))), matrixStack, buffer, blockRenderer, animalPenTile.m_58904_(), animalPenTile.m_58899_());
            matrixStack.m_85849_();
        }
        if (eggs.size() > 3 && (Integer)eggs.get(3) >= 0) {
            offsetx = (float)Math.sin(Math.toRadians(rotate + 60)) / 3.5f;
            offsetz = (float)Math.cos(Math.toRadians(rotate + 60)) / 3.5f;
            scale = 0.25f;
            matrixStack.m_85836_();
            matrixStack.m_85841_(scale, scale, scale);
            matrixStack.m_85837_((double)(0.375f / scale + offsetx / scale), 0.4375, (double)(0.375f / scale + offsetz / scale));
            AnimalPenRenderer.renderBlockState((BlockState)Blocks.f_50578_.m_49966_().m_61124_((Property)TurtleEggBlock.f_57754_, (Comparable)((Integer)eggs.get(3))), matrixStack, buffer, blockRenderer, animalPenTile.m_58904_(), animalPenTile.m_58899_());
            matrixStack.m_85849_();
        }
    }
}

