/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.block.entity.BountyTableTileEntity;
import iskallia.vault.block.model.BountyBlockExclamationModel;
import iskallia.vault.block.model.BountyBlockQuestionModel;
import iskallia.vault.bounty.Bounty;
import iskallia.vault.bounty.BountyList;
import iskallia.vault.bounty.client.ClientBountyData;
import iskallia.vault.bounty.task.properties.TaskProperties;
import iskallia.vault.client.ClientExpertiseData;
import iskallia.vault.init.ModItems;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.expertise.type.BountyHunterExpertise;
import iskallia.vault.util.InventoryUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class BountyTableRenderer
implements BlockEntityRenderer<BountyTableTileEntity> {
    private final Minecraft mc = Minecraft.m_91087_();
    BountyBlockExclamationModel exclamationPoint;
    BountyBlockQuestionModel questionMark;

    public BountyTableRenderer(BlockEntityRendererProvider.Context context) {
        this.exclamationPoint = new BountyBlockExclamationModel(context.m_173582_(BountyBlockExclamationModel.LAYER_LOCATION));
        this.questionMark = new BountyBlockQuestionModel(context.m_173582_(BountyBlockQuestionModel.LAYER_LOCATION));
    }

    public void render(BountyTableTileEntity mobBarrierTile, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        VertexConsumer vertexConsumer;
        boolean canActivateAvailable;
        Level world = mobBarrierTile.m_58904_();
        if (world == null) {
            return;
        }
        if (this.mc.f_91074_ == null) {
            return;
        }
        BountyList bountyList = ClientBountyData.INSTANCE.getBounties();
        BountyList availableBountyList = ClientBountyData.INSTANCE.getAvailable();
        boolean hasCompleteBounty = false;
        boolean hasLegendary = false;
        for (Object bounty : bountyList) {
            if (((Bounty)bounty).getTask().isComplete()) {
                hasCompleteBounty = true;
            }
            if (!((TaskProperties)((Bounty)bounty).getTask().getProperties()).getRewardPool().equals("legendary")) continue;
            hasLegendary = true;
        }
        int maxActiveBounties = 1;
        for (TieredSkill learnedTalentNode : ClientExpertiseData.getLearnedTalentNodes()) {
            LearnableSkill learnableSkill = learnedTalentNode.getChild();
            if (!(learnableSkill instanceof BountyHunterExpertise)) continue;
            BountyHunterExpertise bountyHunterExpertise = (BountyHunterExpertise)learnableSkill;
            maxActiveBounties = bountyHunterExpertise.getMaxActive();
        }
        boolean hasLostBounty = InventoryUtil.findAllItems((Player)this.mc.f_91074_).stream().anyMatch(itemAccess -> itemAccess.getStack().m_150930_((Item)ModItems.LOST_BOUNTY));
        boolean bl = hasLegendary ? bountyList.size() - 1 < maxActiveBounties : (canActivateAvailable = bountyList.size() < maxActiveBounties);
        if (canActivateAvailable && !hasCompleteBounty && availableBountyList.size() > 0 || hasLostBounty && !hasLegendary) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 2.0 + Math.sin((float)this.mc.f_91074_.f_19797_ / 10.0f) / 20.0, 0.5);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)this.mc.f_91074_.f_19797_));
            matrixStack.m_85841_(0.75f, 0.75f, 0.75f);
            vertexConsumer = BountyBlockExclamationModel.MATERIAL.m_119194_(buffer, RenderType::m_110473_);
            this.exclamationPoint.m_7695_(matrixStack, vertexConsumer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        }
        if (hasCompleteBounty) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.5, 2.0 + Math.sin((float)this.mc.f_91074_.f_19797_ / 10.0f) / 20.0, 0.5);
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_((float)this.mc.f_91074_.f_19797_));
            matrixStack.m_85841_(0.75f, 0.75f, 0.75f);
            vertexConsumer = BountyBlockQuestionModel.MATERIAL.m_119194_(buffer, RenderType::m_110473_);
            this.questionMark.m_7695_(matrixStack, vertexConsumer, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        }
    }
}

