/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.block.CryoChamberBlock;
import iskallia.vault.block.entity.AncientCryoChamberTileEntity;
import iskallia.vault.block.entity.CryoChamberTileEntity;
import iskallia.vault.client.ClientEternalData;
import iskallia.vault.client.util.LightmapUtil;
import iskallia.vault.client.util.RenderTypeDecorator;
import iskallia.vault.entity.eternal.EternalDataSnapshot;
import iskallia.vault.entity.model.StatuePlayerModel;
import iskallia.vault.entity.renderer.EternalRenderer;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModShaders;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class CryoChamberRenderer
implements BlockEntityRenderer<CryoChamberTileEntity> {
    public static final Minecraft mc = Minecraft.m_91087_();
    public static final ResourceLocation INFUSED_PLAYER_SKIN = VaultMod.id("textures/entity/infusion_skin_white.png");
    public static StatuePlayerModel PLAYER_MODEL;
    public static RenderType wrapped;
    private final Color[] colors = new Color[]{Color.WHITE, Color.YELLOW, Color.MAGENTA, Color.GREEN};
    private int index = 0;
    private boolean wait = false;
    private Color currentColor = Color.WHITE;
    private float currentRed = 1.0f;
    private float currentGreen = 1.0f;
    private float currentBlue = 1.0f;
    private final float colorChangeDelay = 3.0f;

    public CryoChamberRenderer(BlockEntityRendererProvider.Context context) {
        PLAYER_MODEL = new StatuePlayerModel(context);
    }

    public VertexConsumer getPlayerVertexBuilder(ResourceLocation skinTexture, MultiBufferSource buffer) {
        RenderType renderType = PLAYER_MODEL.m_103119_(skinTexture);
        return buffer.m_6299_(renderType);
    }

    public void render(CryoChamberTileEntity tileEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (tileEntity.isInfusing()) {
            float maxTime = ModConfigs.CRYO_CHAMBER.getInfusionTime();
            float scale = Math.min((float)tileEntity.getInfusionTimeRemaining() / maxTime, 0.8f);
            tileEntity.updateSkin();
            VertexConsumer vertexBuilder = this.getPlayerVertexBuilder(INFUSED_PLAYER_SKIN, buffer);
            this.renderPlayerModel(matrixStack, tileEntity, scale, 0.5f, vertexBuilder, combinedLight, combinedOverlay);
        } else if (tileEntity.isGrowingEternal()) {
            float maxTime = ModConfigs.CRYO_CHAMBER.getGrowEternalTime();
            float scale = Math.min(1.0f - (float)tileEntity.getGrowEternalTimeRemaining() / maxTime, 0.8f);
            VertexConsumer vertexBuilder = this.getPlayerVertexBuilder(INFUSED_PLAYER_SKIN, buffer);
            this.renderPlayerModel(matrixStack, tileEntity, scale, 0.5f, vertexBuilder, combinedLight, combinedOverlay);
        } else if (tileEntity.getEternalId() != null) {
            EternalDataSnapshot snapshot = ClientEternalData.getSnapshot(tileEntity.getEternalId());
            if (snapshot != null && snapshot.getName() != null) {
                boolean flag;
                tileEntity.updateSkin();
                if (buffer instanceof MultiBufferSource.BufferSource) {
                    ((MultiBufferSource.BufferSource)buffer).m_109911_();
                }
                if (!snapshot.isAlive()) {
                    ModShaders.getGrayscalePositionTexShader().withGrayscale(0.0f).withBrightness(LightmapUtil.getLightmapBrightness(combinedLight)).enable();
                }
                ResourceLocation skinTexture = tileEntity.getSkin().getLocationSkin();
                boolean usingPlayerSkin = tileEntity.usingPlayerSkin;
                boolean bl = flag = tileEntity.variant != null;
                VertexConsumer vertexBuilder = this.getPlayerVertexBuilder(usingPlayerSkin ? skinTexture : (flag ? EternalRenderer.getLocationByVariant().get((Object)tileEntity.variant) : skinTexture), buffer);
                this.renderPlayerModel(matrixStack, tileEntity, 0.8f, 1.0f, vertexBuilder, combinedLight, combinedOverlay);
                if (buffer instanceof MultiBufferSource.BufferSource) {
                    ((MultiBufferSource.BufferSource)buffer).m_109911_();
                }
            }
        } else if (tileEntity instanceof AncientCryoChamberTileEntity) {
            boolean flag;
            tileEntity.updateSkin();
            ResourceLocation skinTexture = tileEntity.getSkin().getLocationSkin();
            boolean usingPlayerSkin = tileEntity.usingPlayerSkin;
            boolean bl = flag = tileEntity.variant != null;
            VertexConsumer vertexBuilder = this.getPlayerVertexBuilder(usingPlayerSkin ? skinTexture : (flag ? EternalRenderer.getLocationByVariant().get((Object)tileEntity.variant) : skinTexture), buffer);
            this.renderPlayerModel(matrixStack, tileEntity, 0.8f, 1.0f, vertexBuilder, combinedLight, combinedOverlay);
            if (buffer instanceof MultiBufferSource.BufferSource) {
                ((MultiBufferSource.BufferSource)buffer).m_109911_();
            }
        }
        this.renderLiquid(matrixStack, tileEntity, buffer, partialTicks);
        if (CryoChamberRenderer.mc.f_91077_ != null && CryoChamberRenderer.mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            String eternalName = null;
            EternalDataSnapshot snapshot = ClientEternalData.getSnapshot(tileEntity.getEternalId());
            if (snapshot != null && snapshot.getName() != null) {
                eternalName = snapshot.getName();
            }
            if (tileEntity instanceof AncientCryoChamberTileEntity) {
                eternalName = ((AncientCryoChamberTileEntity)tileEntity).getEternalName();
            }
            if (eternalName != null) {
                BlockHitResult result = (BlockHitResult)CryoChamberRenderer.mc.f_91077_;
                if (tileEntity.m_58899_().equals((Object)result.m_82425_()) || tileEntity.m_58899_().m_7494_().equals((Object)result.m_82425_())) {
                    this.renderLabel(matrixStack, buffer, combinedLight, new TextComponent(eternalName), -1, tileEntity.m_58904_().m_8055_(result.m_82425_()).m_61143_(CryoChamberBlock.HALF) == DoubleBlockHalf.UPPER);
                }
            }
        }
    }

    private void renderLabel(PoseStack matrixStack, MultiBufferSource buffer, int lightLevel, TextComponent text, int color, boolean topBlock) {
        Font fontRenderer = CryoChamberRenderer.mc.f_91062_;
        matrixStack.m_85836_();
        float scale = 0.02f;
        int opacity = 0x66000000;
        float offset = -fontRenderer.m_92852_((FormattedText)text) / 2;
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        matrixStack.m_85837_(0.5, (double)2.3f, 0.5);
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85845_(mc.m_91290_().m_114470_());
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        fontRenderer.m_92841_((Component)text, offset, 0.0f, color, false, matrix4f, buffer, true, opacity, lightLevel);
        fontRenderer.m_92841_((Component)text, offset, 0.0f, -1, false, matrix4f, buffer, false, 0, lightLevel);
        matrixStack.m_85849_();
    }

    public void renderPlayerModel(PoseStack matrixStack, CryoChamberTileEntity tileEntity, float scale, float alpha, VertexConsumer vertexBuilder, int combinedLight, int combinedOverlay) {
        BlockState blockState = tileEntity.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)CryoChamberBlock.FACING);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.3, 0.5);
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(direction.m_122435_() + 180.0f));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        PLAYER_MODEL.setSlim(tileEntity.getSkin().isSlim());
        CryoChamberRenderer.PLAYER_MODEL.f_102810_.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        CryoChamberRenderer.PLAYER_MODEL.f_102814_.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        CryoChamberRenderer.PLAYER_MODEL.f_102813_.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        CryoChamberRenderer.PLAYER_MODEL.f_102812_.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        CryoChamberRenderer.PLAYER_MODEL.f_102811_.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        CryoChamberRenderer.PLAYER_MODEL.f_103378_.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        CryoChamberRenderer.PLAYER_MODEL.f_103376_.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        CryoChamberRenderer.PLAYER_MODEL.f_103377_.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        CryoChamberRenderer.PLAYER_MODEL.f_103374_.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        CryoChamberRenderer.PLAYER_MODEL.f_103375_.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        CryoChamberRenderer.PLAYER_MODEL.f_102809_.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        CryoChamberRenderer.PLAYER_MODEL.f_102808_.m_104306_(matrixStack, vertexBuilder, combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, alpha);
        matrixStack.m_85849_();
    }

    private Quaternion getRotationFromDirection(Direction direction) {
        return switch (direction) {
            case Direction.NORTH, Direction.SOUTH -> Vector3f.f_122225_.m_122240_(direction.m_122424_().m_122435_());
            default -> Vector3f.f_122225_.m_122240_(direction.m_122435_());
        };
    }

    private double[] getRootTranslation(Direction direction) {
        double[] dArray;
        switch (direction) {
            case SOUTH: {
                double[] dArray2 = new double[3];
                dArray2[0] = -1.0;
                dArray2[1] = 0.0;
                dArray = dArray2;
                dArray2[2] = -1.0;
                break;
            }
            case WEST: {
                double[] dArray3 = new double[3];
                dArray3[0] = -1.0;
                dArray3[1] = 0.0;
                dArray = dArray3;
                dArray3[2] = 0.0;
                break;
            }
            case EAST: {
                double[] dArray4 = new double[3];
                dArray4[0] = 0.0;
                dArray4[1] = 0.0;
                dArray = dArray4;
                dArray4[2] = -1.0;
                break;
            }
            default: {
                double[] dArray5 = new double[3];
                dArray5[0] = 0.0;
                dArray5[1] = 0.0;
                dArray = dArray5;
                dArray5[2] = 0.0;
            }
        }
        return dArray;
    }

    private void renderLiquid(PoseStack matrixStack, CryoChamberTileEntity tileEntity, MultiBufferSource buffer, float partialTicks) {
        if (tileEntity.getMaxCores() == 0) {
            return;
        }
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110466_());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(Fluids.f_76193_.getAttributes().getStillTexture());
        BlockState blockState = tileEntity.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)CryoChamberBlock.FACING);
        float max = tileEntity.getMaxCores();
        float difference = (float)tileEntity.getCoreCount() - tileEntity.lastCoreCount;
        tileEntity.lastCoreCount += difference * 0.02f;
        float scale = tileEntity.lastCoreCount / max;
        this.updateIndex(CryoChamberRenderer.mc.f_91074_.f_19797_);
        this.updateColor(partialTicks, tileEntity);
        float r = (float)this.currentColor.getRed() / 255.0f;
        float g = (float)this.currentColor.getGreen() / 255.0f;
        float b = (float)this.currentColor.getBlue() / 255.0f;
        float minU = sprite.m_118367_(0.0);
        float maxU = sprite.m_118367_(16.0);
        float minV = sprite.m_118393_(0.0);
        float maxVBottom = sprite.m_118393_((double)scale < 0.5 ? (double)(scale * 2.0f) * 16.0 : 16.0);
        float maxVTop = sprite.m_118393_((double)scale >= 0.5 ? (double)(scale * 2.0f - 1.0f) * 16.0 : 0.0);
        float bottomHeight = scale < 0.5f ? scale * 2.0f : 1.0f;
        float topHeight = scale < 0.5f ? 0.0f : Math.min(scale * 2.0f, 1.9f);
        matrixStack.m_85836_();
        this.renderSides(matrixStack, builder, scale, r, g, b, minU, maxU, minV, maxVBottom, maxVTop, bottomHeight, topHeight, direction);
        this.renderTop(matrixStack, builder, scale, r, g, b, sprite.m_118409_(), sprite.m_118410_(), sprite.m_118411_(), sprite.m_118412_(), bottomHeight, topHeight);
        matrixStack.m_85849_();
    }

    private void renderTop(PoseStack matrixStack, VertexConsumer builder, float scale, float r, float g, float b, float minU, float maxU, float minV, float maxV, float bottomHeight, float topHeight) {
        this.addVertex(builder, matrixStack, this.p2f(1), scale < 0.5f ? bottomHeight : topHeight, this.p2f(1), minU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(1), scale < 0.5f ? bottomHeight : topHeight, this.p2f(9), maxU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), scale < 0.5f ? bottomHeight : topHeight, this.p2f(9), maxU, maxV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), scale < 0.5f ? bottomHeight : topHeight, this.p2f(1), minU, maxV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(1), scale < 0.5f ? bottomHeight : topHeight, this.p2f(9), minU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(4), scale < 0.5f ? bottomHeight : topHeight, this.p2f(15), maxU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(12), scale < 0.5f ? bottomHeight : topHeight, this.p2f(15), maxU, maxV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), scale < 0.5f ? bottomHeight : topHeight, this.p2f(9), minU, maxV, r, g, b, 1.0f);
    }

    private void renderSides(PoseStack matrixStack, VertexConsumer builder, float scale, float r, float g, float b, float minU, float maxU, float minV, float maxVBottom, float maxVTop, float bottomHeight, float topHeight, Direction direction) {
        double[] translation = this.getRootTranslation(direction);
        matrixStack.m_85845_(this.getRotationFromDirection(direction));
        matrixStack.m_85837_(translation[0], translation[1], translation[2]);
        this.addVertex(builder, matrixStack, this.p2f(4), this.p2f(1), this.p2f(15), minU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(12), this.p2f(1), this.p2f(15), maxU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(12), bottomHeight, this.p2f(15), maxU, maxVBottom, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(4), bottomHeight, this.p2f(15), minU, maxVBottom, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(1), this.p2f(1), this.p2f(9), minU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(4), this.p2f(1), this.p2f(15), maxU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(4), bottomHeight, this.p2f(15), maxU, maxVBottom, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(1), bottomHeight, this.p2f(9), minU, maxVBottom, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(12), this.p2f(1), this.p2f(15), minU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), this.p2f(1), this.p2f(9), maxU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), bottomHeight, this.p2f(9), maxU, maxVBottom, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(12), bottomHeight, this.p2f(15), minU, maxVBottom, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(1), this.p2f(1), this.p2f(1), minU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(1), this.p2f(1), this.p2f(9), maxU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(1), bottomHeight, this.p2f(9), maxU, maxVBottom, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(1), bottomHeight, this.p2f(1), minU, maxVBottom, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), this.p2f(1), this.p2f(9), minU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), this.p2f(1), this.p2f(1), maxU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), bottomHeight, this.p2f(1), maxU, maxVBottom, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), bottomHeight, this.p2f(9), minU, maxVBottom, r, g, b, 1.0f);
        if (scale < 0.5f) {
            return;
        }
        this.addVertex(builder, matrixStack, this.p2f(4), this.p2f(16), this.p2f(15), minU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(12), this.p2f(16), this.p2f(15), maxU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(12), topHeight, this.p2f(15), maxU, maxVTop, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(4), topHeight, this.p2f(15), minU, maxVTop, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(1), this.p2f(16), this.p2f(9), minU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(4), this.p2f(16), this.p2f(15), maxU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(4), topHeight, this.p2f(15), maxU, maxVTop, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(1), topHeight, this.p2f(9), minU, maxVTop, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(12), this.p2f(16), this.p2f(15), minU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), this.p2f(16), this.p2f(9), maxU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), topHeight, this.p2f(9), maxU, maxVTop, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(12), topHeight, this.p2f(15), minU, maxVTop, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(1), this.p2f(16), this.p2f(1), minU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(1), this.p2f(16), this.p2f(9), maxU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(1), topHeight, this.p2f(9), maxU, maxVTop, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(1), topHeight, this.p2f(1), minU, maxVTop, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), this.p2f(16), this.p2f(9), minU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), this.p2f(16), this.p2f(1), maxU, minV, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), topHeight, this.p2f(1), maxU, maxVTop, r, g, b, 1.0f);
        this.addVertex(builder, matrixStack, this.p2f(15), topHeight, this.p2f(9), minU, maxVTop, r, g, b, 1.0f);
    }

    private void addVertex(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float u, float v, float r, float g, float b, float a) {
        renderer.m_85982_(stack.m_85850_().m_85861_(), x, y, z).m_85950_(r, g, b, 0.5f).m_7421_(u, v).m_7120_(0, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    private float p2f(int pixel) {
        return 0.0625f * (float)pixel;
    }

    private void updateIndex(int ticksExisted) {
        if ((float)ticksExisted % 60.0f == 0.0f) {
            if (this.wait) {
                return;
            }
            this.wait = true;
            if (this.index++ == this.colors.length - 1) {
                this.index = 0;
            }
        } else {
            this.wait = false;
        }
    }

    private void updateColor(float partialTicks, CryoChamberTileEntity tileEntity) {
        if (tileEntity.m_58900_().m_61143_(CryoChamberBlock.CHAMBER_STATE) == CryoChamberBlock.ChamberState.RUSTY) {
            this.currentColor = new Color(139, 69, 19);
        } else {
            int nextIndex = this.index + 1;
            if (nextIndex == this.colors.length) {
                nextIndex = 0;
            }
            this.currentColor = this.getBlendedColor(this.colors[this.index], this.colors[nextIndex], partialTicks);
        }
    }

    private Color getBlendedColor(Color prev, Color next, float partialTicks) {
        float prevRed = (float)prev.getRed() / 255.0f;
        float prevGreen = (float)prev.getGreen() / 255.0f;
        float prevBlue = (float)prev.getBlue() / 255.0f;
        float nextRed = (float)next.getRed() / 255.0f;
        float nextGreen = (float)next.getGreen() / 255.0f;
        float nextBlue = (float)next.getBlue() / 255.0f;
        float percentage = 0.01f;
        float transitionTime = 0.90000004f;
        float red = Math.abs((nextRed - prevRed) * percentage / transitionTime * partialTicks);
        float green = Math.abs((nextGreen - prevGreen) * percentage / transitionTime * partialTicks);
        float blue = Math.abs((nextBlue - prevBlue) * percentage / transitionTime * partialTicks);
        this.currentRed = nextRed > prevRed ? this.currentRed + red : this.currentRed - red;
        this.currentGreen = nextGreen > prevGreen ? this.currentGreen + green : this.currentGreen - green;
        this.currentBlue = nextBlue > prevBlue ? this.currentBlue + blue : this.currentBlue - blue;
        this.currentRed = this.ensureRange(this.currentRed);
        this.currentGreen = this.ensureRange(this.currentGreen);
        this.currentBlue = this.ensureRange(this.currentBlue);
        return new Color(this.currentRed, this.currentGreen, this.currentBlue);
    }

    private float ensureRange(float value) {
        return Math.min(Math.max(value, 0.0f), 1.0f);
    }

    static {
        wrapped = RenderTypeDecorator.decorate(RenderType.m_110504_(), RenderSystem::m_69465_, () -> {});
    }
}

