/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import iskallia.vault.block.EternalPedestalBlock;
import iskallia.vault.block.entity.EternalPedestalTileEntity;
import iskallia.vault.client.ClientEternalData;
import iskallia.vault.client.gui.framework.text.TextBorder;
import iskallia.vault.dynamodel.model.armor.ArmorLayers;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.dynamodel.registry.DynamicModelRegistry;
import iskallia.vault.entity.eternal.EternalDataSnapshot;
import iskallia.vault.entity.renderer.EternalRenderer;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.renderer.VaultArmorRenderProperties;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.item.gear.VaultArmorItem;
import iskallia.vault.util.SkinProfile;
import java.awt.Color;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ForgeHooksClient;

public class EternalPedestalRenderer
implements BlockEntityRenderer<EternalPedestalTileEntity> {
    private final PlayerModel<Player> alexModel;
    private final PlayerModel<Player> steveModel;
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final HumanoidModel inner;
    private final HumanoidModel outer;

    public EternalPedestalRenderer(BlockEntityRendererProvider.Context context) {
        this.alexModel = new PlayerModel(context.m_173582_(ModelLayers.f_171166_), true);
        this.setupModelAttributes(this.alexModel);
        this.steveModel = new PlayerModel(context.m_173582_(ModelLayers.f_171162_), false);
        this.setupModelAttributes(this.steveModel);
        this.outer = new HumanoidModel(context.m_173582_(ModelLayers.f_171165_));
        this.setupModelAttributes((HumanoidModel<Player>)this.outer);
        this.inner = new HumanoidModel(context.m_173582_(ModelLayers.f_171164_));
        this.setupModelAttributes((HumanoidModel<Player>)this.inner);
    }

    private void setupModelAttributes(PlayerModel<Player> model) {
        model.f_102610_ = false;
        model.f_102810_.f_104201_ += 0.01f;
        model.f_103378_.f_104201_ += 0.01f;
        model.f_102808_.f_104201_ += 0.02f;
        model.f_102809_.f_104201_ += 0.02f;
        model.f_102812_.f_104200_ += 0.01f;
        model.f_103374_.f_104200_ += 0.01f;
        model.f_102811_.f_104200_ -= 0.01f;
        model.f_103375_.f_104200_ -= 0.01f;
        model.f_102814_.f_104200_ += 0.01f;
        model.f_103376_.f_104200_ += 0.01f;
        model.f_102813_.f_104200_ -= 0.01f;
        model.f_103377_.f_104200_ -= 0.01f;
    }

    private void setupModelAttributes(HumanoidModel<Player> model) {
        model.f_102610_ = false;
        model.f_102810_.f_104201_ += 0.01f;
        model.f_102808_.f_104201_ += 0.02f;
        model.f_102809_.f_104201_ += 0.02f;
        model.f_102812_.f_104202_ += 0.01f;
        model.f_102811_.f_104202_ -= 0.01f;
        model.f_102814_.f_104202_ += 0.01f;
        model.f_102813_.f_104202_ -= 0.01f;
    }

    public void render(EternalPedestalTileEntity championStatueBlockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        boolean shiftDown;
        SkinProfile skinProfile = championStatueBlockEntity.getSkinProfile();
        float scale = 1.0f;
        ResourceLocation skin = skinProfile.getLocationSkin();
        EternalDataSnapshot snapshot = ClientEternalData.getSnapshot(championStatueBlockEntity.getEternalId());
        PlayerModel<Player> model = skinProfile.isSlim() ? this.alexModel : this.steveModel;
        boolean usingVariant = false;
        if (snapshot != null && !snapshot.isUsingPlayerSkin()) {
            skin = EternalRenderer.getLocationByVariant().get((Object)snapshot.getVariant());
            model = this.steveModel;
            usingVariant = true;
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 2.0, 0.5);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        poseStack.m_85845_(this.getRotation((Direction)championStatueBlockEntity.m_58900_().m_61143_((Property)EternalPedestalBlock.FACING)));
        RenderType renderType = model.m_103119_(skin);
        poseStack.m_85841_(scale, scale, scale);
        if (!skinProfile.isEmpty() || usingVariant) {
            model.m_7695_(poseStack, buffer.m_6299_(renderType), packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (snapshot != null) {
            this.renderArmWithItem(snapshot.getEquipment(EquipmentSlot.MAINHAND), model, poseStack, buffer, packedLight, packedOverlay, HumanoidArm.RIGHT);
            this.renderArmWithItem(snapshot.getEquipment(EquipmentSlot.OFFHAND), model, poseStack, buffer, packedLight, packedOverlay, HumanoidArm.LEFT);
            this.renderArmor(poseStack, snapshot.getEquipment(EquipmentSlot.HEAD), packedLight, packedOverlay);
            this.renderArmor(poseStack, snapshot.getEquipment(EquipmentSlot.CHEST), packedLight, packedOverlay);
            this.renderArmor(poseStack, snapshot.getEquipment(EquipmentSlot.LEGS), packedLight, packedOverlay);
            this.renderArmor(poseStack, snapshot.getEquipment(EquipmentSlot.FEET), packedLight, packedOverlay);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.37, 0.5);
        poseStack.m_85845_(Vector3f.f_122224_.m_122240_(((Direction)championStatueBlockEntity.m_58900_().m_61143_((Property)EternalPedestalBlock.FACING)).m_122435_()));
        if (!skinProfile.isEmpty() && skinProfile.gameProfile.get() != null) {
            this.drawPlayerName(poseStack, skinProfile.gameProfile.get().getName());
        }
        boolean bl = shiftDown = Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_6144_();
        if (shiftDown && snapshot != null) {
            poseStack.m_85837_(0.0, -0.125, 0.0);
            this.drawVaultLevel(poseStack, snapshot.getLevel(), buffer);
        }
        poseStack.m_85849_();
    }

    public void addVertex(VertexConsumer builder, PoseStack matrixStack, float x, float y, float z, Color tint, float u, float v) {
        builder.m_85982_(matrixStack.m_85850_().m_85861_(), x / 16.0f, y / 16.0f, z / 16.0f).m_85950_((float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, 0.8f).m_7421_(u, v).m_7120_(0, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public void renderArmor(PoseStack matrixStack, ItemStack armorStack, int packedLight, int packedOverlay) {
        matrixStack.m_85836_();
        Optional<DynamicModelRegistry<?>> modelRegistry = ModDynamicModels.REGISTRIES.getAssociatedRegistry(armorStack.m_41720_());
        if (modelRegistry.isPresent()) {
            VaultGearData gearData = VaultGearData.read(armorStack);
            ArmorPieceModel armorPiece = gearData.getFirstValue(ModGearAttributes.GEAR_MODEL).flatMap(modelId -> ((DynamicModelRegistry)modelRegistry.get()).get((ResourceLocation)modelId)).filter(gearModel -> gearModel instanceof ArmorPieceModel).orElse(null);
            if (armorPiece != null) {
                VertexConsumer vertexconsumer;
                VaultArmorItem vaultArmorItem = VaultArmorItem.forSlot(armorPiece.getEquipmentSlot());
                ArmorLayers.BaseLayer baseLayer = VaultArmorRenderProperties.BAKED_LAYERS.get(armorPiece.getId());
                String baseTexture = vaultArmorItem.getArmorTexture(armorStack, null, armorPiece.getEquipmentSlot(), null);
                String overlayTexture = vaultArmorItem.getArmorTexture(armorStack, null, armorPiece.getEquipmentSlot(), "overlay");
                MultiBufferSource.BufferSource multiBufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
                float yRotTempHead = baseLayer.f_102808_.f_104204_;
                float zRotTempHead = baseLayer.f_102808_.f_104205_;
                float xRotTempHead = baseLayer.f_102808_.f_104203_;
                float xTempHead = baseLayer.f_102808_.f_104200_;
                float yTempHead = baseLayer.f_102808_.f_104201_;
                float zTempHead = baseLayer.f_102808_.f_104202_;
                baseLayer.f_102808_.f_104204_ = 0.0f;
                baseLayer.f_102808_.f_104205_ = 0.0f;
                baseLayer.f_102808_.f_104203_ = 0.0f;
                baseLayer.f_102808_.f_104201_ = 0.0f;
                baseLayer.f_102808_.f_104202_ = 0.0f;
                baseLayer.f_102808_.f_104200_ = 0.0f;
                float yRotTempBody = baseLayer.f_102810_.f_104204_;
                float zRotTempBody = baseLayer.f_102810_.f_104205_;
                float xRotTempBody = baseLayer.f_102810_.f_104203_;
                float xTempBody = baseLayer.f_102810_.f_104200_;
                float yTempBody = baseLayer.f_102810_.f_104201_;
                float zTempBody = baseLayer.f_102810_.f_104202_;
                baseLayer.f_102810_.f_104204_ = 0.0f;
                baseLayer.f_102810_.f_104205_ = 0.0f;
                baseLayer.f_102810_.f_104203_ = 0.0f;
                baseLayer.f_102810_.f_104201_ = 0.01f;
                baseLayer.f_102810_.f_104202_ = 0.01f;
                baseLayer.f_102810_.f_104200_ = 0.01f;
                float yRotTempRightArm = baseLayer.f_102811_.f_104204_;
                float zRotTempRightArm = baseLayer.f_102811_.f_104205_;
                float xRotTempRightArm = baseLayer.f_102811_.f_104203_;
                float xTempRightArm = baseLayer.f_102811_.f_104200_;
                float yTempRightArm = baseLayer.f_102811_.f_104201_;
                float zTempRightArm = baseLayer.f_102811_.f_104202_;
                baseLayer.f_102811_.f_104204_ = 0.0f;
                baseLayer.f_102811_.f_104205_ = 0.0f;
                baseLayer.f_102811_.f_104203_ = 0.0f;
                baseLayer.f_102811_.f_104201_ = 2.01f;
                baseLayer.f_102811_.f_104202_ = 0.01f;
                baseLayer.f_102811_.f_104200_ = -5.01f;
                float yRotTempLeftArm = baseLayer.f_102812_.f_104204_;
                float zRotTempLeftArm = baseLayer.f_102812_.f_104205_;
                float xRotTempLeftArm = baseLayer.f_102812_.f_104203_;
                float xTempLeftArm = baseLayer.f_102812_.f_104200_;
                float yTempLeftArm = baseLayer.f_102812_.f_104201_;
                float zTempLeftArm = baseLayer.f_102812_.f_104202_;
                baseLayer.f_102812_.f_104204_ = 0.0f;
                baseLayer.f_102812_.f_104205_ = 0.0f;
                baseLayer.f_102812_.f_104203_ = 0.0f;
                baseLayer.f_102812_.f_104201_ = 2.01f;
                baseLayer.f_102812_.f_104202_ = -0.01f;
                baseLayer.f_102812_.f_104200_ = 5.01f;
                float yRotTempRightLeg = baseLayer.f_102813_.f_104204_;
                float zRotTempRightLeg = baseLayer.f_102813_.f_104205_;
                float xRotTempRightLeg = baseLayer.f_102813_.f_104203_;
                float xTempRightLeg = baseLayer.f_102813_.f_104200_;
                float yTempRightLeg = baseLayer.f_102813_.f_104201_;
                float zTempRightLeg = baseLayer.f_102813_.f_104202_;
                baseLayer.f_102813_.f_104204_ = 0.0f;
                baseLayer.f_102813_.f_104205_ = 0.0f;
                baseLayer.f_102813_.f_104203_ = 0.0f;
                baseLayer.f_102813_.f_104201_ = 12.01f;
                baseLayer.f_102813_.f_104202_ = 0.11f;
                baseLayer.f_102813_.f_104200_ = -1.91f;
                float yRotTempLeftLeg = baseLayer.f_102814_.f_104204_;
                float zRotTempLeftLeg = baseLayer.f_102814_.f_104205_;
                float xRotTempLeftLeg = baseLayer.f_102814_.f_104203_;
                float xTempLeftLeg = baseLayer.f_102814_.f_104200_;
                float yTempLeftLeg = baseLayer.f_102814_.f_104201_;
                float zTempLeftLeg = baseLayer.f_102814_.f_104202_;
                baseLayer.f_102814_.f_104204_ = 0.0f;
                baseLayer.f_102814_.f_104205_ = 0.0f;
                baseLayer.f_102814_.f_104203_ = 0.0f;
                baseLayer.f_102814_.f_104201_ = 12.01f;
                baseLayer.f_102814_.f_104202_ = 0.09f;
                baseLayer.f_102814_.f_104200_ = 1.91f;
                matrixStack.m_85841_(1.01f, 1.01f, 1.01f);
                if (baseTexture != null) {
                    vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)new ResourceLocation(baseTexture)), (boolean)false, (boolean)armorStack.m_41790_());
                    baseLayer.m_7695_(matrixStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                if (overlayTexture != null) {
                    vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)new ResourceLocation(overlayTexture)), (boolean)false, (boolean)armorStack.m_41790_());
                    baseLayer.m_7695_(matrixStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                baseLayer.f_102808_.f_104204_ = yRotTempHead;
                baseLayer.f_102808_.f_104205_ = zRotTempHead;
                baseLayer.f_102808_.f_104203_ = xRotTempHead;
                baseLayer.f_102808_.f_104201_ = yTempHead;
                baseLayer.f_102808_.f_104202_ = zTempHead;
                baseLayer.f_102808_.f_104200_ = xTempHead;
                baseLayer.f_102810_.f_104204_ = yRotTempBody;
                baseLayer.f_102810_.f_104205_ = zRotTempBody;
                baseLayer.f_102810_.f_104203_ = xRotTempBody;
                baseLayer.f_102810_.f_104201_ = yTempBody;
                baseLayer.f_102810_.f_104202_ = zTempBody;
                baseLayer.f_102810_.f_104200_ = xTempBody;
                baseLayer.f_102812_.f_104204_ = yRotTempLeftArm;
                baseLayer.f_102812_.f_104205_ = zRotTempLeftArm;
                baseLayer.f_102812_.f_104203_ = xRotTempLeftArm;
                baseLayer.f_102812_.f_104201_ = yTempLeftArm;
                baseLayer.f_102812_.f_104202_ = zTempLeftArm;
                baseLayer.f_102812_.f_104200_ = xTempLeftArm;
                baseLayer.f_102811_.f_104204_ = yRotTempRightArm;
                baseLayer.f_102811_.f_104205_ = zRotTempRightArm;
                baseLayer.f_102811_.f_104203_ = xRotTempRightArm;
                baseLayer.f_102811_.f_104201_ = yTempRightArm;
                baseLayer.f_102811_.f_104202_ = zTempRightArm;
                baseLayer.f_102811_.f_104200_ = xTempRightArm;
                baseLayer.f_102814_.f_104204_ = yRotTempLeftLeg;
                baseLayer.f_102814_.f_104205_ = zRotTempLeftLeg;
                baseLayer.f_102814_.f_104203_ = xRotTempLeftLeg;
                baseLayer.f_102814_.f_104201_ = yTempLeftLeg;
                baseLayer.f_102814_.f_104202_ = zTempLeftLeg;
                baseLayer.f_102814_.f_104200_ = xTempLeftLeg;
                baseLayer.f_102813_.f_104204_ = yRotTempRightLeg;
                baseLayer.f_102813_.f_104205_ = zRotTempRightLeg;
                baseLayer.f_102813_.f_104203_ = xRotTempRightLeg;
                baseLayer.f_102813_.f_104201_ = yTempRightLeg;
                baseLayer.f_102813_.f_104202_ = zTempRightLeg;
                baseLayer.f_102813_.f_104200_ = xTempRightLeg;
                multiBufferSource.m_109911_();
            }
        } else if (armorStack.m_41720_() instanceof ArmorItem) {
            ArmorItem armoritem = (ArmorItem)armorStack.m_41720_();
            MultiBufferSource.BufferSource multiBufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            EquipmentSlot equipmentSlot = armoritem.m_40402_();
            boolean flag = this.usesInnerModel(equipmentSlot);
            this.setPartVisibility(flag ? this.inner : this.outer, equipmentSlot);
            Model model = this.getArmorModelHook((LivingEntity)Minecraft.m_91087_().f_91074_, armorStack, equipmentSlot, flag ? this.inner : this.outer);
            boolean flag1 = armorStack.m_41790_();
            if (armoritem instanceof DyeableLeatherItem) {
                int i = ((DyeableLeatherItem)armoritem).m_41121_(armorStack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderModel(matrixStack, (MultiBufferSource)multiBufferSource, 0xF000F0, flag1, model, f, f1, f2, this.getArmorResource((Entity)Minecraft.m_91087_().f_91074_, armorStack, equipmentSlot, null));
                this.renderModel(matrixStack, (MultiBufferSource)multiBufferSource, 0xF000F0, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)Minecraft.m_91087_().f_91074_, armorStack, equipmentSlot, "overlay"));
            } else {
                this.renderModel(matrixStack, (MultiBufferSource)multiBufferSource, 0xF000F0, flag1, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)Minecraft.m_91087_().f_91074_, armorStack, equipmentSlot, null));
            }
        }
        matrixStack.m_85849_();
    }

    protected void setPartVisibility(HumanoidModel<?> pModel, EquipmentSlot pSlot) {
        pModel.m_8009_(false);
        switch (pSlot) {
            case HEAD: {
                pModel.f_102808_.f_104207_ = true;
                pModel.f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                pModel.f_102810_.f_104207_ = true;
                pModel.f_102811_.f_104207_ = true;
                pModel.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                pModel.f_102810_.f_104207_ = true;
                pModel.f_102813_.f_104207_ = true;
                pModel.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                pModel.f_102813_.f_104207_ = true;
                pModel.f_102814_.f_104207_ = true;
            }
        }
    }

    private void renderModel(PoseStack p_117107_, MultiBufferSource p_117108_, int p_117109_, boolean p_117111_, Model p_117112_, float p_117114_, float p_117115_, float p_117116_, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)p_117108_, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)p_117111_);
        p_117112_.m_7695_(p_117107_, vertexconsumer, p_117109_, OverlayTexture.f_118083_, p_117114_, p_117115_, p_117116_, 1.0f);
    }

    protected Model getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlot slot, HumanoidModel<?> model) {
        return ForgeHooksClient.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlot)slot, model);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    private boolean usesInnerModel(EquipmentSlot pSlot) {
        return pSlot == EquipmentSlot.LEGS;
    }

    private void drawPlayerName(PoseStack poseStack, String playerIGN) {
        Font font = Minecraft.m_91087_().f_91065_.m_93082_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 0.501);
        poseStack.m_85841_(0.011f, -0.011f, 0.011f);
        float f = (float)(-font.m_92895_(playerIGN)) / 2.0f;
        Objects.requireNonNull(font);
        font.m_92883_(poseStack, playerIGN, f, (float)(-9) / 2.0f, ChatFormatting.GRAY.m_126665_().intValue());
        poseStack.m_85849_();
    }

    private void drawVaultLevel(PoseStack poseStack, int level, MultiBufferSource buffer) {
        Font font = Minecraft.m_91087_().f_91065_.m_93082_();
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.0, 0.501);
        poseStack.m_85841_(0.011f, -0.011f, 0.011f);
        FormattedCharSequence $$25 = new TranslatableComponent(String.valueOf(level)).m_7532_();
        float $$26 = -font.m_92724_($$25) / 2;
        Objects.requireNonNull(font);
        font.m_168645_($$25, $$26, (float)(-9) / 2.0f, TextColor.m_131268_((String)"#FFE637").m_131265_(), TextBorder.DEFAULT_BORDER_COLOR.m_131265_(), poseStack.m_85850_().m_85861_(), buffer, 0xF000F0);
        poseStack.m_85849_();
    }

    protected void renderArmWithItem(ItemStack item, PlayerModel<Player> model, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int packedOverlay, HumanoidArm arm) {
        if (!item.m_41619_()) {
            poseStack.m_85836_();
            model.m_6002_(arm, poseStack);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            boolean flag = arm == HumanoidArm.LEFT;
            poseStack.m_85837_((double)((float)(flag ? -1 : 1) / 16.0f), 0.125, -0.625);
            Minecraft mc = Minecraft.m_91087_();
            ItemTransforms.TransformType type = !flag ? ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND : ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
            mc.m_91291_().m_174242_((LivingEntity)mc.f_91074_, item, type, flag, poseStack, bufferSource, (Level)mc.f_91073_, combinedLight, packedOverlay, mc.f_91074_.m_142049_() + type.ordinal());
            poseStack.m_85849_();
        }
    }

    private ResourceLocation getPlayerSkin(EternalPedestalTileEntity championStatueBlockEntity) {
        return championStatueBlockEntity.getSkinProfile().getLocationSkin();
    }

    private Quaternion getRotation(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> Quaternion.f_80118_;
            case Direction.SOUTH -> Vector3f.f_122225_.m_122240_(180.0f);
            case Direction.WEST -> Vector3f.f_122225_.m_122240_(-90.0f);
            case Direction.EAST -> Vector3f.f_122225_.m_122240_(90.0f);
            case Direction.UP, Direction.DOWN -> Quaternion.f_80118_;
        };
    }
}

