/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import iskallia.vault.block.HeraldTrophyBlock;
import iskallia.vault.block.entity.HeraldTrophyTileEntity;
import iskallia.vault.util.McClientHelper;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class HeraldTrophyRenderer
implements BlockEntityRenderer<HeraldTrophyTileEntity> {
    public HeraldTrophyRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@Nonnull HeraldTrophyTileEntity tileEntity, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        ClientLevel world = (ClientLevel)tileEntity.m_58904_();
        if (world == null) {
            return;
        }
        BlockState blockState = tileEntity.m_58900_();
        Direction facing = (Direction)blockState.m_61143_((Property)HeraldTrophyBlock.FACING);
        String ownerNickname = McClientHelper.getOnlineProfile(tileEntity.getOwnerUUID()).map(GameProfile::getName).orElse(tileEntity.getOwnerNickname());
        if (ownerNickname != null) {
            this.drawNameplate(matrixStack, buffer, ownerNickname, facing, combinedLight, combinedOverlay);
        }
    }

    private void drawNameplate(PoseStack matrixStack, MultiBufferSource buffer, String displayName, Direction direction, int combinedLight, int combinedOverlay) {
        FormattedCharSequence text = new TextComponent(displayName).m_130940_(ChatFormatting.BLACK).m_7532_();
        Font fr = Minecraft.m_91087_().f_91062_;
        int width = fr.m_92724_(text);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.17, 0.5);
        matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(direction.m_122435_() + 180.0f));
        matrixStack.m_85837_(0.0, 0.0, 0.27);
        matrixStack.m_85841_(0.01f, -0.01f, 0.01f);
        fr.m_92733_(text, (float)(-width) / 2.0f, 0.0f, -16777216, false, matrixStack.m_85850_().m_85861_(), buffer, false, 0, combinedLight);
        matrixStack.m_85849_();
    }
}

