/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.block.IdentificationStandBlock;
import iskallia.vault.block.entity.IdentificationStandTileEntity;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.item.IdentifiableItem;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;

public class IdentificationStandRenderer
implements BlockEntityRenderer<IdentificationStandTileEntity> {
    public static final ResourceLocation BOOK_TEXTURE = VaultMod.id("entity/identification_tome");
    public static final Material BOOK_MATERIAL = new Material(TextureAtlas.f_118259_, BOOK_TEXTURE);
    private final BookModel bookModel;
    private final ItemRenderer itemRenderer;
    private List<ItemStack> cachedItemStacks = new LinkedList<ItemStack>();

    public IdentificationStandRenderer(BlockEntityRendererProvider.Context context) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.bookModel = new BookModel(context.m_173582_(ModelLayers.f_171271_));
        this.itemRenderer = minecraft.m_91291_();
    }

    public void render(@Nonnull IdentificationStandTileEntity tileEntity, float pPartialTick, @Nonnull PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float f1;
        Direction facingDirection = (Direction)tileEntity.m_58900_().m_61143_((Property)IdentificationStandBlock.FACING);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.01, 0.5);
        float f = (float)tileEntity.time + pPartialTick;
        poseStack.m_85837_((double)facingDirection.m_122424_().m_122429_() * 0.25, (double)(0.3f + Mth.m_14031_((float)(f * 0.1f)) * 0.01f), (double)facingDirection.m_122424_().m_122431_() * 0.25);
        for (f1 = tileEntity.rot - tileEntity.oRot; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
        }
        while (f1 < (float)(-Math.PI)) {
            f1 += (float)Math.PI * 2;
        }
        float f2 = tileEntity.oRot + f1 * pPartialTick;
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f + facingDirection.m_122406_().m_175235_().m_122260_()));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(65.0f));
        float f3 = Mth.m_14179_((float)pPartialTick, (float)tileEntity.oFlip, (float)tileEntity.flip);
        float f4 = Mth.m_14187_((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = Mth.m_14187_((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = Mth.m_14179_((float)pPartialTick, (float)tileEntity.oOpen, (float)tileEntity.open);
        this.bookModel.m_102292_(f, Mth.m_14036_((float)f4, (float)0.0f, (float)1.0f), Mth.m_14036_((float)f5, (float)0.0f, (float)1.0f), f6);
        VertexConsumer vertexconsumer = BOOK_MATERIAL.m_119194_(bufferSource, RenderType::m_110446_);
        this.bookModel.m_102316_(poseStack, vertexconsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        if (tileEntity.open != 0.0f) {
            BlockPos pos = tileEntity.m_58899_();
            Player player = tileEntity.m_58904_().m_45924_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 3.0, false);
            double sec = (double)System.currentTimeMillis() / 1000.0;
            if (player != null) {
                this.cachedItemStacks = this.getIdentifiableStacks(player.m_150109_());
            }
            if (this.cachedItemStacks.isEmpty()) {
                return;
            }
            ItemStack identifiableStack = this.cachedItemStacks.get((int)sec / 2 % this.cachedItemStacks.size());
            poseStack.m_85836_();
            poseStack.m_85837_(0.5 + (double)facingDirection.m_122424_().m_122429_() * 0.3, 1.3 + 0.5 * (double)f6 + Math.sin(sec) * (double)0.05f, 0.5 + (double)facingDirection.m_122424_().m_122431_() * 0.3);
            float scl = (float)(0.53 * (double)f6);
            poseStack.m_85841_(scl, scl, scl);
            poseStack.m_85845_(Vector3f.f_122225_.m_122270_(-f2));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)((double)(90.0f * f6) + 20.0 * (sec % 360.0))));
            this.itemRenderer.m_174269_(identifiableStack, ItemTransforms.TransformType.FIXED, packedLight, packedOverlay, poseStack, bufferSource, 0);
            poseStack.m_85849_();
        }
    }

    private List<ItemStack> getIdentifiableStacks(Inventory inventory) {
        return inventory.f_35974_.stream().filter(itemStack -> {
            IdentifiableItem identifiableItem;
            Item patt5475$temp = itemStack.m_41720_();
            return patt5475$temp instanceof IdentifiableItem && (identifiableItem = (IdentifiableItem)patt5475$temp).getState((ItemStack)itemStack) == VaultGearState.UNIDENTIFIED;
        }).map(ItemStack::m_41777_).toList();
    }
}

