/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Vector3f;
import iskallia.vault.block.MonolithBlock;
import iskallia.vault.block.entity.MonolithTileEntity;
import iskallia.vault.core.vault.modifier.VaultModifierStack;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.overlay.ModifiersRenderer;
import iskallia.vault.task.renderer.context.RendererContext;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;

public class MonolithRenderer
implements BlockEntityRenderer<MonolithTileEntity> {
    private final Font font;

    public MonolithRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.m_173586_();
    }

    public void render(MonolithTileEntity tileEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlayIn) {
        MutableComponent shadow;
        RenderSystem.m_69482_();
        matrixStack.m_85836_();
        float scale = 0.02f;
        matrixStack.m_85837_(0.5, 2.5, 0.5);
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85845_(Minecraft.m_91087_().m_91290_().m_114470_());
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85837_(-65.0, -11.0, 0.0);
        RendererContext context = new RendererContext(matrixStack, partialTicks, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()), this.font);
        MonolithBlock.State state = (MonolithBlock.State)((Object)tileEntity.m_58900_().m_61143_(MonolithBlock.STATE));
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        ArrayList description = new ArrayList();
        ArrayList<VaultModifierStack> stack = new ArrayList<VaultModifierStack>();
        if (tileEntity.isOverStacking() && state == MonolithBlock.State.EXTINGUISHED) {
            lines.add(new TextComponent("Pillage for Loot").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE)));
        }
        tileEntity.getModifiers().forEach((id, count) -> VaultModifierRegistry.getOpt(id).ifPresent(modifier -> {
            lines.add((MutableComponent)modifier.getChatDisplayNameComponent((int)count));
            description.add(new TextComponent(modifier.getDisplayDescriptionFormatted((int)count)).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
            stack.add(VaultModifierStack.of(modifier, count));
        }));
        Collections.reverse(lines);
        Collections.reverse(stack);
        for (Component component : description) {
            shadow = new TextComponent("").m_130946_(component.getString()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLACK));
            context.renderText((Component)shadow, 66.0f, 68.0f, true, true);
            context.renderText(component, 65.0f, 67.0f, true, true);
            context.translate(0.0, -11.0, 0.0);
        }
        for (Component component : lines) {
            shadow = new TextComponent("").m_130946_(component.getString()).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLACK));
            context.renderText((Component)shadow, 66.0f, 66.0f, true, true);
            context.renderText(component, 65.0f, 65.0f, true, true);
            context.translate(0.0, -11.0, 0.0);
        }
        Minecraft minecraft = Minecraft.m_91087_();
        double d = stack.size() > 1 ? 82.5 + (double)(stack.size() * 5) : 82.5;
        matrixStack.m_85837_(d, 73.0, 0.0);
        matrixStack.m_85836_();
        int right = minecraft.m_91268_().m_85445_();
        int bottom = minecraft.m_91268_().m_85446_();
        matrixStack.m_85837_((double)(-right), (double)(-bottom), 0.0);
        ModifiersRenderer.renderVaultModifiersWithDepth(stack, matrixStack);
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }
}

