/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.block.entity.PylonTileEntity;
import iskallia.vault.block.model.PylonCrystalModel;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.ForgeHooksClient;

public class PylonRenderer
implements BlockEntityRenderer<PylonTileEntity> {
    protected final PylonCrystalModel crystalModel;
    private final Minecraft mc = Minecraft.m_91087_();
    private final BlockRenderDispatcher blockRenderer = this.mc.m_91289_();

    public PylonRenderer(BlockEntityRendererProvider.Context context) {
        this.crystalModel = new PylonCrystalModel(context.m_173582_(PylonCrystalModel.MODEL_LOCATION));
    }

    public void render(@Nonnull PylonTileEntity tileEntity, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packetLight, int packetOverlay) {
        int color = tileEntity.config == null ? -1 : tileEntity.config.getColor();
        int a = tileEntity.isConsumed() ? 32 : color >>> 24 & 0xFF;
        int r = color >>> 16 & 0xFF;
        int g = color >>> 8 & 0xFF;
        int b = color & 0xFF;
        if (tileEntity.config != null && tileEntity.config.getUber()) {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.0, 0.5);
            poseStack.m_85845_(Vector3f.f_122224_.m_122240_(45.0f));
            poseStack.m_85837_(-0.5, -0.125, -0.5);
            PylonRenderer.renderBlockState(tileEntity.m_58900_(), poseStack, bufferSource, this.blockRenderer, tileEntity.m_58904_(), tileEntity.m_58899_());
            poseStack.m_85849_();
        }
        VertexConsumer vertexConsumer = PylonCrystalModel.MATERIAL.m_119194_(bufferSource, RenderType::m_110473_);
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 1.5, 0.5);
        poseStack.m_85845_(Vector3f.f_122227_.m_122270_((float)Math.PI));
        this.crystalModel.setupAnimations();
        this.crystalModel.m_7695_(poseStack, vertexConsumer, packetLight, packetOverlay, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
        poseStack.m_85849_();
        Minecraft minecraft = Minecraft.m_91087_();
        if (!tileEntity.isConsumed() && minecraft.f_91077_ != null && minecraft.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult result = (BlockHitResult)minecraft.f_91077_;
            if (tileEntity.m_58899_().equals((Object)result.m_82425_()) && tileEntity.config != null) {
                String text = tileEntity.config.getDescription();
                MutableComponent progressText = new TextComponent(text == null ? "" : text).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)tileEntity.config.getColor())));
                this.renderLabel(poseStack, 0.5f, 1.5f, 0.5f, bufferSource, packetLight, (Component)progressText);
            }
        }
    }

    private static void renderBlockState(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, Level world, BlockPos pos) {
        try {
            for (RenderType type : RenderType.m_110506_()) {
                if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                PylonRenderer.renderBlockState(state, matrixStack, buffer, blockRenderer, world, pos, type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderBlockState(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, Level world, BlockPos pos, RenderType type) {
        ForgeHooksClient.setRenderType((RenderType)type);
        blockRenderer.m_110937_().m_111047_((BlockAndTintGetter)world, blockRenderer.m_110910_(state), state, pos, matrixStack, buffer.m_6299_(type), false, world.f_46441_, 0L, OverlayTexture.f_118083_);
        ForgeHooksClient.setRenderType(null);
    }

    public void renderLabel(PoseStack matrixStack, float x, float y, float z, MultiBufferSource buffer, int lightLevel, Component text) {
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        matrixStack.m_85836_();
        float scale = 0.02f;
        int opacity = 0x66000000;
        float offset = -fontRenderer.m_92852_((FormattedText)text) / 2;
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        matrixStack.m_85837_((double)x, (double)y, (double)z);
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85845_(minecraft.m_91290_().m_114470_());
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        fontRenderer.m_92841_(text, offset, 0.0f, -1, false, matrix4f, buffer, true, opacity, lightLevel);
        fontRenderer.m_92841_(text, offset, 0.0f, -1, false, matrix4f, buffer, false, 0, lightLevel);
        matrixStack.m_85849_();
    }
}

