/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.block.SkillAltarBlock;
import iskallia.vault.block.entity.SkillAltarTileEntity;
import iskallia.vault.client.ClientSkillAltarData;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.helper.Easing;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModTextureAtlases;
import iskallia.vault.world.data.SkillAltarData;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;

public class SkillAltarRenderer
implements BlockEntityRenderer<SkillAltarTileEntity> {
    public static final String TALENT_ICON_PREFIX = "talent/";
    public static final String ABILITY_ICON_PREFIX = "ability/";
    private static final int MIN_ICON_SWITCH_TIME = 5000;
    private static final int MAX_ICON_SWITCH_TIME = 10000;
    private static final int EASING_TIME = 600;
    private static final int MAX_ALPHA = 208;

    public SkillAltarRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SkillAltarTileEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (blockEntity.m_58904_() == null) {
            return;
        }
        List<SkillAltarData.SkillIcon> skillAltarIconKeys = ClientSkillAltarData.getAbilityIconKeys(blockEntity.getOwnerId());
        float alphaMultiplier = 1.0f;
        int iconKeyIndex = blockEntity.getRenderIconKeyIndex();
        if (iconKeyIndex < 0 && !skillAltarIconKeys.isEmpty()) {
            iconKeyIndex = 0;
            blockEntity.switchToNextIcon(iconKeyIndex, System.currentTimeMillis(), System.currentTimeMillis() + (long)blockEntity.m_58904_().f_46441_.nextInt(5000, 10000));
        }
        if (skillAltarIconKeys.size() > 1) {
            long lastIconSwitchTime = blockEntity.getLastIconSwitchTime();
            long nextIconSwitchTime = blockEntity.getNextIconSwitchTime();
            if (System.currentTimeMillis() >= nextIconSwitchTime) {
                iconKeyIndex = (iconKeyIndex + 1) % skillAltarIconKeys.size();
                lastIconSwitchTime = System.currentTimeMillis();
                nextIconSwitchTime = System.currentTimeMillis() + (long)blockEntity.m_58904_().f_46441_.nextInt(5000, 10000);
                blockEntity.switchToNextIcon(iconKeyIndex, lastIconSwitchTime, nextIconSwitchTime);
            }
            if (System.currentTimeMillis() - lastIconSwitchTime < 600L) {
                int sinceLastSwitch = (int)(System.currentTimeMillis() - lastIconSwitchTime);
                float progress = (float)sinceLastSwitch / 600.0f;
                alphaMultiplier = Easing.EASE_OUT_BOUNCE.calc(progress);
            } else if (nextIconSwitchTime - System.currentTimeMillis() < 600L) {
                int sinceNextSwitch = (int)(nextIconSwitchTime - System.currentTimeMillis());
                float progress = (float)sinceNextSwitch / 600.0f;
                alphaMultiplier = Easing.EASE_OUT_BOUNCE.calc(progress);
            }
        }
        this.renderIcon(blockEntity, poseStack, bufferSource, packedLight, skillAltarIconKeys, alphaMultiplier, iconKeyIndex);
    }

    private void renderIcon(SkillAltarTileEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, List<SkillAltarData.SkillIcon> skillAltarIconKeys, float alphaMultiplier, int iconKeyIndex) {
        TextureAtlasSprite icon;
        ResourceLocation atlasResourceLocation;
        if (skillAltarIconKeys.isEmpty() || iconKeyIndex < 0 || iconKeyIndex >= skillAltarIconKeys.size() || skillAltarIconKeys.get(iconKeyIndex).key().equals("")) {
            atlasResourceLocation = ScreenTextures.TAB_ICON_ABILITIES.atlas().get().getAtlasResourceLocation();
            icon = ScreenTextures.TAB_ICON_ABILITIES.getSprite();
        } else if (skillAltarIconKeys.get(iconKeyIndex).isTalent()) {
            atlasResourceLocation = ModTextureAtlases.SKILLS.get().getAtlasResourceLocation();
            icon = ModTextureAtlases.SKILLS.get().getSprite(ModConfigs.TALENTS_GUI.getStyles().get((Object)skillAltarIconKeys.get((int)iconKeyIndex).key()).icon);
        } else {
            atlasResourceLocation = ModTextureAtlases.ABILITIES.get().getAtlasResourceLocation();
            icon = ModTextureAtlases.ABILITIES.get().getSprite(ModConfigs.ABILITIES_GUI.getIcon(skillAltarIconKeys.get(iconKeyIndex).key()));
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.925, 0.5);
        poseStack.m_85845_(Vector3f.f_122224_.m_122240_(((Direction)blockEntity.m_58900_().m_61143_((Property)SkillAltarBlock.FACING)).m_122424_().m_122435_()));
        poseStack.m_85837_(0.25, 0.0, 0.0);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)atlasResourceLocation));
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_85861_();
        Matrix3f normal = pose.m_85864_();
        float f15 = 1.0f;
        float f16 = 0.0f;
        float f17 = 1.0f;
        float f18 = 0.0f;
        float uMin = icon.m_118409_();
        float uMax = icon.m_118410_();
        float vMin = icon.m_118411_();
        float vMax = icon.m_118412_();
        int alpha = (int)(alphaMultiplier * 208.0f);
        this.vertex(matrix4f, normal, vertexconsumer, f15, f18, uMax, vMin, 0.0f, 0, 0, 0, packedLight, alpha);
        this.vertex(matrix4f, normal, vertexconsumer, f16, f18, uMin, vMin, 0.0f, 0, 0, 0, packedLight, alpha);
        this.vertex(matrix4f, normal, vertexconsumer, f16, f17, uMin, vMax, 0.0f, 0, 0, 0, packedLight, alpha);
        this.vertex(matrix4f, normal, vertexconsumer, f15, f17, uMax, vMax, 0.0f, 0, 0, 0, packedLight, alpha);
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bs = (MultiBufferSource.BufferSource)bufferSource;
            bs.m_109911_();
        }
        poseStack.m_85849_();
    }

    private void vertex(Matrix4f matrix4f, Matrix3f normal, VertexConsumer vertexConsumer, float x, float y, float u, float v, float z, int normalX, int normalY, int normalZ, int light, int alpha) {
        vertexConsumer.m_85982_(matrix4f, x, y, z).m_6122_(255, 255, 255, alpha).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(normal, (float)normalX, (float)normalY, (float)normalZ).m_5752_();
    }
}

