/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.block.SoulPlaqueBlock;
import iskallia.vault.block.entity.SoulPlaqueTileEntity;
import iskallia.vault.client.util.LightmapUtil;
import iskallia.vault.entity.model.StatuePlayerModel;
import iskallia.vault.init.ModShaders;
import iskallia.vault.task.renderer.context.RendererContext;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SoulPlaqueRenderer
implements BlockEntityRenderer<SoulPlaqueTileEntity> {
    private final Font font;
    private final ItemRenderer itemRenderer;
    private final StatuePlayerModel model;

    public SoulPlaqueRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.m_173586_();
        this.itemRenderer = Minecraft.m_91087_().m_91291_();
        this.model = new StatuePlayerModel(context);
    }

    public void render(SoulPlaqueTileEntity entity, float pPartialTick, PoseStack matrices, MultiBufferSource buffer, int pPackedLight, int pPackedOverlay) {
        ResourceLocation skinLocation = entity.getSkin().getLocationSkin();
        RenderType renderType = this.model.m_103119_(skinLocation);
        VertexConsumer vertexBuilder = buffer.m_6299_(renderType);
        BlockState blockState = entity.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)SoulPlaqueBlock.FACING);
        matrices.m_85836_();
        Color color = new Color(-6646101);
        ModShaders.getColorizePositionTexShader().withColorize((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f).withBrightness(LightmapUtil.getLightmapBrightness(pPackedLight)).withGrayscale(0.45f).enable();
        matrices.m_85837_(0.5, 0.5, 0.5);
        matrices.m_85845_(Vector3f.f_122224_.m_122240_(direction.m_122435_() + 180.0f));
        float headScale = 1.05f;
        matrices.m_85841_(headScale, headScale, 0.35f);
        matrices.m_85837_(0.0, (double)-0.15f, (double)1.1f);
        matrices.m_85841_(-1.0f, -1.0f, 1.0f);
        this.model.f_102809_.m_104306_(matrices, vertexBuilder, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        this.model.f_102808_.m_104306_(matrices, vertexBuilder, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        if (buffer instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)buffer).m_109912_(renderType);
        }
        matrices.m_85836_();
        matrices.m_85841_(0.02f, 0.02f, 1.0f);
        matrices.m_85837_(0.0, 5.0, (double)-0.05f);
        RendererContext context = new RendererContext(matrices, pPartialTick, MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_()), this.font);
        context.renderText((Component)new TextComponent("" + entity.getScore()), 0.0f, 5.0f, true, true);
        matrices.m_85849_();
        matrices.m_85849_();
    }
}

