/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.SparkTileEntity;
import iskallia.vault.block.model.WendarrSparkSourceModel;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;

public class SparkRenderer
implements BlockEntityRenderer<SparkTileEntity> {
    public static final float CORNERS = 0.9375f;
    public static final float HEIGHT = 1.0f;
    public static final float MIN_Y = 0.0f;
    public static final float MAX_Y = 0.9375f;
    WendarrSparkSourceModel source;
    public static final ResourceLocation TEXTURE_LOCATION = VaultMod.id("block/wendarr_sand");

    public SparkRenderer(BlockEntityRendererProvider.Context context) {
        this.source = new WendarrSparkSourceModel(context.m_173582_(WendarrSparkSourceModel.LAYER_LOCATION));
    }

    public void render(SparkTileEntity tile, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level world = tile.m_58904_();
        if (world == null) {
            return;
        }
        float t = tile.getLifeTimePercentage();
        float t2 = tile.getLifeTimePercentageOld();
        float t3 = Mth.m_14179_((float)partialTicks, (float)t2, (float)t);
        if (t3 == 0.0f) {
            return;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(3600.0f * ((1.0f - t3) * (1.0f - t3)) + (float)tile.getOffsetTicks()));
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(2400.0f * ((1.0f - t3) * (1.0f - t3)) + (float)tile.getOffsetTicks()));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(1600.0f * ((1.0f - t3) * (1.0f - t3)) + (float)tile.getOffsetTicks()));
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer vertexConsumer = WendarrSparkSourceModel.MATERIAL.m_119194_(buffer, RenderType::m_110473_);
        this.source.m_7695_(matrixStack, vertexConsumer, 0xF000F0, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110472_());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(TEXTURE_LOCATION);
        float time = t3 * 14.0f / 16.0f;
        float height = 0.9375f * time;
        float minU = sprite.m_118367_(15.0);
        float maxU = sprite.m_118367_(1.0);
        float minV = sprite.m_118393_(15.0);
        float maxV = sprite.m_118393_(1.0);
        float minUHeight = sprite.m_118367_((double)(1.0f * time * 16.0f));
        float maxUHeight = sprite.m_118367_((double)(0.0f * time * 16.0f));
        float minVHeight = sprite.m_118393_(15.0);
        float maxVHeight = sprite.m_118393_(1.0);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        float shading = 1.0f;
        vertexBuilder.m_85982_(matrix, 0.0625f, height + 0.0625f, 0.0625f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(minU, minV).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.0625f, height + 0.0625f, 0.9375f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(minU, maxV).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.9375f, height + 0.0625f, 0.9375f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(maxU, maxV).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.9375f, height + 0.0625f, 0.0625f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(maxU, minV).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.9375f, 0.0625f, 0.0625f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(minU, minV).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.9375f, 0.0625f, 0.9375f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(minU, maxV).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.0625f, 0.0625f, 0.9375f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(maxU, maxV).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.0625f, 0.0625f, 0.0625f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(maxU, minV).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.9375f, height + 0.0625f, 0.0625f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(minUHeight, minVHeight).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.9375f, height + 0.0625f, 0.9375f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(minUHeight, maxVHeight).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.9375f, 0.0625f, 0.9375f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(maxUHeight, maxVHeight).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.9375f, 0.0625f, 0.0625f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(maxUHeight, minVHeight).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.0625f, height + 0.0625f, 0.0625f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(minUHeight, minVHeight).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.9375f, height + 0.0625f, 0.0625f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(minUHeight, maxVHeight).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.9375f, 0.0625f, 0.0625f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(maxUHeight, maxVHeight).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.0625f, 0.0625f, 0.0625f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(maxUHeight, minVHeight).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.0625f, height + 0.0625f, 0.9375f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(minUHeight, minVHeight).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.0625f, height + 0.0625f, 0.0625f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(minUHeight, maxVHeight).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.0625f, 0.0625f, 0.0625f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(maxUHeight, maxVHeight).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.0625f, 0.0625f, 0.9375f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(maxUHeight, minVHeight).m_85969_(combinedLight).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.9375f, height + 0.0625f, 0.9375f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(minUHeight, minVHeight).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.0625f, height + 0.0625f, 0.9375f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(minUHeight, maxVHeight).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.0625f, 0.0625f, 0.9375f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(maxUHeight, maxVHeight).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        vertexBuilder.m_85982_(matrix, 0.9375f, 0.0625f, 0.9375f).m_85950_(1.0f * shading, 1.0f * shading, 1.0f * shading, 1.0f).m_7421_(maxUHeight, minVHeight).m_85969_(combinedLight).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
    }

    private static void renderBlockState(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, Level world, BlockPos pos) {
        try {
            for (RenderType type : RenderType.m_110506_()) {
                if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                SparkRenderer.renderBlockState(state, matrixStack, buffer, blockRenderer, world, pos, type);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderBlockState(BlockState state, PoseStack matrixStack, MultiBufferSource buffer, BlockRenderDispatcher blockRenderer, Level world, BlockPos pos, RenderType type) {
        ForgeHooksClient.setRenderType((RenderType)type);
        blockRenderer.m_110937_().m_111047_((BlockAndTintGetter)world, blockRenderer.m_110910_(state), state, pos, matrixStack, buffer.m_6299_(type), false, world.f_46441_, 0L, OverlayTexture.f_118083_);
        ForgeHooksClient.setRenderType(null);
    }
}

