/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import iskallia.vault.block.SpiritExtractorBlock;
import iskallia.vault.block.entity.SpiritExtractorTileEntity;
import iskallia.vault.entity.renderer.PlayerSkinUpdater;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.properties.Property;

public class SpiritExtractorRenderer
implements BlockEntityRenderer<SpiritExtractorTileEntity> {
    private final PlayerModel<Player> alexModel;
    private final PlayerModel<Player> steveModel;
    private final PlayerSkinUpdater playerSkinUpdater = new PlayerSkinUpdater();

    public SpiritExtractorRenderer(BlockEntityRendererProvider.Context context) {
        this.alexModel = new PlayerModel(context.m_173582_(ModelLayers.f_171166_), true);
        this.setupModelAttributes(this.alexModel);
        this.steveModel = new PlayerModel(context.m_173582_(ModelLayers.f_171162_), false);
        this.setupModelAttributes(this.steveModel);
    }

    private void setupModelAttributes(PlayerModel<Player> model) {
        model.f_102610_ = false;
        model.f_102810_.f_104201_ += 0.01f;
        model.f_103378_.f_104201_ += 0.01f;
        model.f_102808_.f_104201_ += 0.02f;
        model.f_102809_.f_104201_ += 0.02f;
        model.f_102812_.f_104200_ += 0.01f;
        model.f_103374_.f_104200_ += 0.01f;
        model.f_102811_.f_104200_ -= 0.01f;
        model.f_103375_.f_104200_ -= 0.01f;
        model.f_102814_.f_104200_ += 0.01f;
        model.f_103376_.f_104200_ += 0.01f;
        model.f_102813_.f_104200_ -= 0.01f;
        model.f_103377_.f_104200_ -= 0.01f;
    }

    public void render(SpiritExtractorTileEntity spiritExtractorTileEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (spiritExtractorTileEntity.getGameProfile().isEmpty()) {
            return;
        }
        ResourceLocation playerSkin = this.getPlayerSkin(spiritExtractorTileEntity);
        PlayerModel<Player> model = spiritExtractorTileEntity.hasSlimSkin() ? this.alexModel : this.steveModel;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 2.02, 0.5);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        poseStack.m_85845_(this.getRotation((Direction)spiritExtractorTileEntity.m_58900_().m_61143_((Property)SpiritExtractorBlock.FACING)));
        RenderType renderType = model.m_103119_(playerSkin);
        model.m_7695_(poseStack, buffer.m_6299_(renderType), packedLight, packedOverlay, 0.5f, 0.5f, 0.5f, 0.5f);
        poseStack.m_85849_();
    }

    private ResourceLocation getPlayerSkin(SpiritExtractorTileEntity spiritExtractorTileEntity) {
        return spiritExtractorTileEntity.getSkinLocation().orElseGet(() -> spiritExtractorTileEntity.getGameProfile().map(gp -> this.playerSkinUpdater.updatePlayerSkin(spiritExtractorTileEntity, (GameProfile)gp)).orElse(DefaultPlayerSkin.m_118626_()));
    }

    private Quaternion getRotation(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> Quaternion.f_80118_;
            case Direction.SOUTH -> Vector3f.f_122225_.m_122240_(180.0f);
            case Direction.WEST -> Vector3f.f_122225_.m_122240_(-90.0f);
            case Direction.EAST -> Vector3f.f_122225_.m_122240_(90.0f);
            case Direction.UP, Direction.DOWN -> Quaternion.f_80118_;
        };
    }
}

