/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import iskallia.vault.block.entity.TotemTileEntity;
import iskallia.vault.block.render.TotemRenderer;
import iskallia.vault.init.ModRenderTypes;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TotemGlowRenderer<T extends TotemTileEntity>
extends TotemRenderer<T> {
    private final BlockRenderDispatcher blockRenderDispatcher = Minecraft.m_91087_().m_91289_();

    public TotemGlowRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void render(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        super.render(blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        BlockPos blockPos = blockEntity.m_58899_();
        ModelBlockRenderer modelRenderer = this.blockRenderDispatcher.m_110937_();
        BlockState glowBlockState = this.getGlowBlockState();
        VertexConsumer glowVertexConsumer = bufferSource.m_6299_(ModRenderTypes.TOTEM_GLOW_LAYER);
        modelRenderer.m_111047_((BlockAndTintGetter)level, this.blockRenderDispatcher.m_110910_(glowBlockState), glowBlockState, blockPos, poseStack, glowVertexConsumer, false, level.f_46441_, 0L, OverlayTexture.f_118083_);
    }

    @Nonnull
    protected abstract BlockState getGlowBlockState();
}

