/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import iskallia.vault.altar.AltarInfusionRecipe;
import iskallia.vault.altar.RequiredItems;
import iskallia.vault.block.entity.VaultAltarTileEntity;
import iskallia.vault.init.ModItems;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class VaultAltarRenderer
implements BlockEntityRenderer<VaultAltarTileEntity> {
    private final Minecraft mc = Minecraft.m_91087_();

    public VaultAltarRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(VaultAltarTileEntity altar, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (altar.getAltarState() == null || altar.getAltarState() == VaultAltarTileEntity.AltarState.IDLE) {
            return;
        }
        Level level = altar.m_58904_();
        if (level == null) {
            return;
        }
        LocalPlayer player = this.mc.f_91074_;
        if (player == null) {
            return;
        }
        int lightLevel = this.getLightAtPos(altar.m_58904_(), altar.m_58899_().m_7494_());
        this.renderItem(new ItemStack((ItemLike)ModItems.VAULT_ROCK), new double[]{0.5, 1.35, 0.5}, Vector3f.f_122225_.m_122240_(180.0f - player.m_146908_()), matrixStack, buffer, partialTicks, combinedOverlay, lightLevel);
        if (altar.getRecipe() == null || altar.getRecipe().getRequiredItems().isEmpty()) {
            return;
        }
        AltarInfusionRecipe recipe = altar.getRecipe();
        List<RequiredItems> items = recipe.getRequiredItems();
        HashMap itemMap = new HashMap();
        items.forEach(requiredItems -> itemMap.put(requiredItems.getPoolId(), requiredItems));
        for (int idIndex = 0; idIndex < itemMap.keySet().size(); ++idIndex) {
            String id = (String)itemMap.keySet().toArray()[idIndex];
            RequiredItems requiredItems2 = (RequiredItems)itemMap.get(id);
            double[] translation = this.getTranslation(idIndex);
            List<ItemStack> stacks = requiredItems2.getItems();
            TextComponent text = new TextComponent(String.valueOf(requiredItems2.getAmountRequired() - requiredItems2.getCurrentAmount()));
            int textColor = 0xFFFFFF;
            if (requiredItems2.isComplete()) {
                text = new TextComponent("Complete");
                textColor = 65280;
            }
            if (stacks.isEmpty() || altar.getDisplayedIndex().isEmpty() || !altar.getDisplayedIndex().containsKey(id)) continue;
            int index = altar.getDisplayedIndex().get(id);
            ItemStack toRender = ItemStack.f_41583_;
            if (index >= 0 && index < stacks.size()) {
                toRender = stacks.get(index);
            }
            this.renderItem(toRender, translation, Vector3f.f_122225_.m_122240_(this.getAngle(player, partialTicks) * 5.0f), matrixStack, buffer, partialTicks, combinedOverlay, lightLevel);
            this.renderLabel(toRender, matrixStack, buffer, lightLevel, translation, text, textColor);
        }
    }

    private void renderItem(ItemStack stack, double[] translation, Quaternion rotation, PoseStack matrixStack, MultiBufferSource buffer, float partialTicks, int combinedOverlay, int lightLevel) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(translation[0], translation[1], translation[2]);
        matrixStack.m_85845_(rotation);
        if (stack.m_41720_() != ModItems.VAULT_ROCK) {
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        }
        BakedModel ibakedmodel = this.mc.m_91291_().m_174264_(stack, null, null, 0);
        this.mc.m_91291_().m_115143_(stack, ItemTransforms.TransformType.GROUND, true, matrixStack, buffer, lightLevel, combinedOverlay, ibakedmodel);
        matrixStack.m_85849_();
    }

    private void renderLabel(ItemStack stack, PoseStack matrixStack, MultiBufferSource buffer, int lightLevel, double[] corner, TextComponent text, int color) {
        Font fontRenderer = this.mc.f_91062_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        matrixStack.m_85836_();
        float scale = 0.01f;
        int opacity = 0x66000000;
        float offset = -fontRenderer.m_92852_((FormattedText)text) / 2;
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        matrixStack.m_85837_(corner[0], corner[1] + 0.25, corner[2]);
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_85845_(this.mc.m_91290_().m_114470_());
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        fontRenderer.m_92841_((Component)text, offset, 0.0f, color, false, matrix4f, buffer, false, opacity, lightLevel);
        if (player.m_6144_()) {
            Component itemName = stack.m_41786_();
            offset = -fontRenderer.m_92852_((FormattedText)itemName) / 2;
            matrixStack.m_85837_(0.0, (double)1.4f, 0.0);
            matrix4f.m_27648_(new Vector3f(0.0f, 0.15f, 0.0f));
            fontRenderer.m_92841_(stack.m_41786_(), offset, 0.0f, color, false, matrix4f, buffer, false, opacity, lightLevel);
        }
        matrixStack.m_85849_();
    }

    private float getAngle(LocalPlayer player, float partialTicks) {
        float currentTick = player.f_19797_;
        return (currentTick + partialTicks) % 360.0f;
    }

    private int getLightAtPos(Level world, BlockPos pos) {
        int blockLight = world.m_45517_(LightLayer.BLOCK, pos);
        int skyLight = world.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)blockLight, (int)skyLight);
    }

    private double[] getTranslation(int index) {
        double[] dArray;
        switch (index) {
            case 0: {
                double[] dArray2 = new double[3];
                dArray2[0] = 0.95;
                dArray2[1] = 1.35;
                dArray = dArray2;
                dArray2[2] = 0.05;
                break;
            }
            case 1: {
                double[] dArray3 = new double[3];
                dArray3[0] = 0.95;
                dArray3[1] = 1.35;
                dArray = dArray3;
                dArray3[2] = 0.95;
                break;
            }
            case 2: {
                double[] dArray4 = new double[3];
                dArray4[0] = 0.05;
                dArray4[1] = 1.35;
                dArray = dArray4;
                dArray4[2] = 0.95;
                break;
            }
            default: {
                double[] dArray5 = new double[3];
                dArray5[0] = 0.05;
                dArray5[1] = 1.35;
                dArray = dArray5;
                dArray5[2] = 0.05;
            }
        }
        return dArray;
    }
}

