/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.block.VaultChestBlock;
import iskallia.vault.block.model.VaultChestModel;
import iskallia.vault.init.ModBlocks;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class VaultChestRenderer<T extends ChestBlockEntity>
extends ChestRenderer<T> {
    public static final Map<Block, Material> NORMAL_MATERIAL_MAP = Map.ofEntries(Map.entry(ModBlocks.WOODEN_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_chest"))), Map.entry(ModBlocks.GILDED_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_gilded_chest"))), Map.entry(ModBlocks.LIVING_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_mossy_chest"))), Map.entry(ModBlocks.ORNATE_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_ornate_chest"))), Map.entry(ModBlocks.TREASURE_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_treasure_chest"))), Map.entry(ModBlocks.ALTAR_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_altar_chest"))), Map.entry(ModBlocks.HARDENED_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_hardened_chest"))), Map.entry(ModBlocks.ENIGMA_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_enigma_chest"))), Map.entry(ModBlocks.FLESH_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_flesh_chest"))), Map.entry(ModBlocks.GILDED_STRONGBOX, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_gilded_strongbox"))), Map.entry(ModBlocks.ORNATE_STRONGBOX, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_ornate_strongbox"))), Map.entry(ModBlocks.LIVING_STRONGBOX, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_living_strongbox"))), Map.entry(ModBlocks.WOODEN_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_chest"))), Map.entry(ModBlocks.GILDED_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_gilded_chest"))), Map.entry(ModBlocks.LIVING_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_mossy_chest"))), Map.entry(ModBlocks.ORNATE_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_ornate_chest"))), Map.entry(ModBlocks.TREASURE_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_treasure_chest"))), Map.entry(ModBlocks.ALTAR_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_altar_chest"))), Map.entry(ModBlocks.HARDENED_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_hardened_chest"))), Map.entry(ModBlocks.ENIGMA_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_enigma_chest"))), Map.entry(ModBlocks.FLESH_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_flesh_chest"))));
    public static final Map<Block, Material> PRESENT_MATERIAL_MAP = Map.ofEntries(Map.entry(ModBlocks.WOODEN_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/orange"))), Map.entry(ModBlocks.GILDED_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/yellow"))), Map.entry(ModBlocks.LIVING_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/green"))), Map.entry(ModBlocks.ORNATE_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/red"))), Map.entry(ModBlocks.TREASURE_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/pink"))), Map.entry(ModBlocks.ALTAR_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/cyan"))), Map.entry(ModBlocks.HARDENED_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/orange"))), Map.entry(ModBlocks.ENIGMA_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/orange"))), Map.entry(ModBlocks.FLESH_CHEST, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/orange"))), Map.entry(ModBlocks.ORNATE_STRONGBOX, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_ornate_strongbox"))), Map.entry(ModBlocks.GILDED_STRONGBOX, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_gilded_strongbox"))), Map.entry(ModBlocks.LIVING_STRONGBOX, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/vault_living_strongbox"))), Map.entry(ModBlocks.WOODEN_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/orange"))), Map.entry(ModBlocks.GILDED_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/yellow"))), Map.entry(ModBlocks.LIVING_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/green"))), Map.entry(ModBlocks.ORNATE_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/red"))), Map.entry(ModBlocks.TREASURE_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/pink"))), Map.entry(ModBlocks.ALTAR_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/cyan"))), Map.entry(ModBlocks.HARDENED_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/orange"))), Map.entry(ModBlocks.ENIGMA_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/orange"))), Map.entry(ModBlocks.FLESH_CHEST_PLACEABLE, new Material(Sheets.f_110740_, VaultMod.id("entity/chest/present/orange"))));
    private static final Map<Block, VaultChestModel> NORMAL_MODEL_MAP = new HashMap<Block, VaultChestModel>();
    private static final Map<Block, VaultChestModel> PRESENT_MODEL_MAP = new HashMap<Block, VaultChestModel>();

    protected Map<Block, Material> getMaterialMap(BlockState blockState) {
        VaultChestBlock.Variant variant = blockState.m_61145_(VaultChestBlock.VARIANT).orElse(VaultChestBlock.Variant.NORMAL);
        return switch (variant) {
            default -> throw new IncompatibleClassChangeError();
            case VaultChestBlock.Variant.NORMAL -> NORMAL_MATERIAL_MAP;
            case VaultChestBlock.Variant.PRESENT -> PRESENT_MATERIAL_MAP;
        };
    }

    protected Map<Block, VaultChestModel> getModelMap(BlockState blockState) {
        VaultChestBlock.Variant variant = blockState.m_61145_(VaultChestBlock.VARIANT).orElse(VaultChestBlock.Variant.NORMAL);
        return switch (variant) {
            default -> throw new IncompatibleClassChangeError();
            case VaultChestBlock.Variant.NORMAL -> NORMAL_MODEL_MAP;
            case VaultChestBlock.Variant.PRESENT -> PRESENT_MODEL_MAP;
        };
    }

    public VaultChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        VaultChestModel treasureChest = new VaultChestModel(context.m_173582_(VaultChestModel.TREASURE_LOCATION));
        VaultChestModel livingChest = new VaultChestModel(context.m_173582_(VaultChestModel.MOSSY_LOCATION));
        VaultChestModel strongbox = new VaultChestModel(context.m_173582_(VaultChestModel.STRONGBOX_LOCATION));
        VaultChestModel livingStrongbox = new VaultChestModel(context.m_173582_(VaultChestModel.LIVING_STRONGBOX_LOCATION));
        VaultChestModel scavengerChest = new VaultChestModel(context.m_173582_(VaultChestModel.SCAVENGER_LOCATION));
        VaultChestModel presentChest = new VaultChestModel(context.m_173582_(VaultChestModel.PRESENT_LOCATION));
        VaultChestModel hardenedChest = new VaultChestModel(context.m_173582_(VaultChestModel.HARDENED_LOCATION));
        VaultChestModel fleshChest = new VaultChestModel(context.m_173582_(VaultChestModel.FLESH_LOCATION));
        NORMAL_MODEL_MAP.put(ModBlocks.TREASURE_CHEST, treasureChest);
        NORMAL_MODEL_MAP.put(ModBlocks.ORNATE_CHEST, livingChest);
        NORMAL_MODEL_MAP.put(ModBlocks.ALTAR_CHEST, livingChest);
        NORMAL_MODEL_MAP.put(ModBlocks.WOODEN_CHEST, livingChest);
        NORMAL_MODEL_MAP.put(ModBlocks.GILDED_CHEST, livingChest);
        NORMAL_MODEL_MAP.put(ModBlocks.LIVING_CHEST, livingChest);
        NORMAL_MODEL_MAP.put(ModBlocks.HARDENED_CHEST, hardenedChest);
        NORMAL_MODEL_MAP.put(ModBlocks.ENIGMA_CHEST, hardenedChest);
        NORMAL_MODEL_MAP.put(ModBlocks.FLESH_CHEST, fleshChest);
        NORMAL_MODEL_MAP.put(ModBlocks.TREASURE_CHEST_PLACEABLE, treasureChest);
        NORMAL_MODEL_MAP.put(ModBlocks.ORNATE_CHEST_PLACEABLE, livingChest);
        NORMAL_MODEL_MAP.put(ModBlocks.ALTAR_CHEST_PLACEABLE, livingChest);
        NORMAL_MODEL_MAP.put(ModBlocks.WOODEN_CHEST_PLACEABLE, livingChest);
        NORMAL_MODEL_MAP.put(ModBlocks.GILDED_CHEST_PLACEABLE, livingChest);
        NORMAL_MODEL_MAP.put(ModBlocks.LIVING_CHEST_PLACEABLE, livingChest);
        NORMAL_MODEL_MAP.put(ModBlocks.HARDENED_CHEST_PLACEABLE, hardenedChest);
        NORMAL_MODEL_MAP.put(ModBlocks.ENIGMA_CHEST_PLACEABLE, hardenedChest);
        NORMAL_MODEL_MAP.put(ModBlocks.FLESH_CHEST_PLACEABLE, fleshChest);
        NORMAL_MODEL_MAP.put(ModBlocks.ORNATE_STRONGBOX, strongbox);
        NORMAL_MODEL_MAP.put(ModBlocks.GILDED_STRONGBOX, strongbox);
        NORMAL_MODEL_MAP.put(ModBlocks.LIVING_STRONGBOX, livingStrongbox);
        PRESENT_MODEL_MAP.put(ModBlocks.TREASURE_CHEST, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.ORNATE_CHEST, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.ALTAR_CHEST, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.WOODEN_CHEST, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.GILDED_CHEST, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.LIVING_CHEST, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.HARDENED_CHEST, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.ENIGMA_CHEST, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.FLESH_CHEST, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.TREASURE_CHEST_PLACEABLE, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.ORNATE_CHEST_PLACEABLE, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.ALTAR_CHEST_PLACEABLE, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.WOODEN_CHEST_PLACEABLE, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.GILDED_CHEST_PLACEABLE, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.LIVING_CHEST_PLACEABLE, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.HARDENED_CHEST_PLACEABLE, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.ENIGMA_CHEST_PLACEABLE, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.FLESH_CHEST_PLACEABLE, presentChest);
        PRESENT_MODEL_MAP.put(ModBlocks.ORNATE_STRONGBOX, strongbox);
        PRESENT_MODEL_MAP.put(ModBlocks.GILDED_STRONGBOX, strongbox);
        PRESENT_MODEL_MAP.put(ModBlocks.LIVING_STRONGBOX, livingStrongbox);
    }

    @Nonnull
    protected Material getMaterial(T tileEntity, ChestType chestType) {
        BlockState blockState = tileEntity.m_58900_();
        Material m = this.getMaterialMap(blockState).get(blockState.m_60734_());
        if (m != null) {
            return m;
        }
        return super.getMaterial(tileEntity, chestType);
    }

    public void render(T blockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        BlockState blockState = blockEntity.m_58900_();
        VaultChestModel model = this.getModelMap(blockState).get(blockState.m_60734_());
        if (model != null) {
            this.customRender(model, blockEntity, pPartialTick, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay);
            return;
        }
        super.m_6922_(blockEntity, pPartialTick, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay);
    }

    public void customRender(VaultChestModel model, T tileEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level level = tileEntity.m_58904_();
        BlockState blockState = tileEntity.m_58900_();
        boolean flag = level != null;
        Direction dir = flag ? (Direction)blockState.m_61143_((Property)ChestBlock.f_51478_) : Direction.SOUTH;
        float hAngle = dir.m_122435_();
        DoubleBlockCombiner.NeighborCombineResult lidCallback = DoubleBlockCombiner.Combiner::m_6502_;
        float lidRotation = ((Float2FloatFunction)lidCallback.m_5649_(ChestBlock.m_51517_(tileEntity))).get(partialTicks);
        lidRotation = 1.0f - lidRotation;
        lidRotation = 1.0f - lidRotation * lidRotation * lidRotation;
        model.setLidAngle(lidRotation);
        VaultChestBlock.Variant variant = (VaultChestBlock.Variant)((Object)blockState.m_61143_(VaultChestBlock.VARIANT));
        if (variant == VaultChestBlock.Variant.PRESENT) {
            model.setLidAngle(-lidRotation);
        }
        int combinedLidLight = ((Int2IntFunction)lidCallback.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(combinedLight);
        Material material = this.getMaterial(tileEntity, null);
        VertexConsumer vb = material.m_119194_(buffer, RenderType::m_110452_);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-hAngle));
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        model.m_7695_(matrixStack, vb, combinedLidLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }
}

