/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import iskallia.vault.VaultMod;
import iskallia.vault.block.entity.VelvetBedTileEntity;
import iskallia.vault.init.ModBlocks;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VelvetBedRenderer
implements BlockEntityRenderer<VelvetBedTileEntity> {
    public static final ModelLayerLocation HEAD_LAYER_LOCATION = new ModelLayerLocation(VaultMod.id("head_layer_location"), "main");
    public static final ModelLayerLocation FOOT_LAYER_LOCATION = new ModelLayerLocation(VaultMod.id("foot_layer_location"), "main");
    private final ModelPart headRoot;
    private final ModelPart footRoot;
    public static final ResourceLocation TEXTURE_LOCATION = VaultMod.id("entity/bed/velvet");
    public static final Material MATERIAL = new Material(TextureAtlas.f_118259_, TEXTURE_LOCATION);

    public VelvetBedRenderer(BlockEntityRendererProvider.Context pContext) {
        this.headRoot = pContext.m_173582_(HEAD_LAYER_LOCATION);
        this.footRoot = pContext.m_173582_(FOOT_LAYER_LOCATION);
    }

    public ModelPart getHeadRoot() {
        return this.headRoot;
    }

    public ModelPart getFootRoot() {
        return this.footRoot;
    }

    public static LayerDefinition createHeadLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition bb_main = partdefinition.m_171599_("bb_main", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -24.0f, 0.0f, 16.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition pillow_r1 = bb_main.m_171599_("pillow_r1", CubeListBuilder.m_171558_().m_171514_(29, 44).m_171488_(-6.0f, 0.5f, -3.25f, 12.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)8.0f, (float)-17.5f, (float)-2.25f, (float)1.309f, (float)0.0f, (float)3.1416f));
        PartDefinition blacket_fluff_r1 = bb_main.m_171599_("blacket_fluff_r1", CubeListBuilder.m_171558_().m_171514_(0, 52).m_171488_(-15.0f, -8.0f, 6.5f, 17.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(0, 44).m_171488_(-11.5f, -10.5f, -1.5f, 10.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-22.5f, (float)7.5f, (float)1.5708f, (float)0.0f, (float)3.1416f));
        PartDefinition right_leg_r1 = bb_main.m_171599_("right_leg_r1", CubeListBuilder.m_171558_().m_171514_(50, 12).m_171488_(-14.5f, 0.5f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-22.5f, (float)-4.5f, (float)1.5708f, (float)0.0f, (float)3.1416f));
        PartDefinition left_leg_r1 = bb_main.m_171599_("left_leg_r1", CubeListBuilder.m_171558_().m_171514_(50, 12).m_171488_(-1.5f, 0.5f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-22.5f, (float)-4.5f, (float)1.5708f, (float)0.0f, (float)1.5708f));
        PartDefinition right_leg_r2 = bb_main.m_171599_("right_leg_r2", CubeListBuilder.m_171558_().m_171514_(50, 0).m_171488_(-14.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-22.5f, (float)7.5f, (float)1.5708f, (float)0.0f, (float)3.1416f));
        PartDefinition left_leg_r2 = bb_main.m_171599_("left_leg_r2", CubeListBuilder.m_171558_().m_171514_(50, 0).m_171488_(-1.5f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-22.5f, (float)7.5f, (float)1.5708f, (float)0.0f, (float)1.5708f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public static LayerDefinition createFootLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("main", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 6.0f), PartPose.f_171404_);
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(50, 0).m_171481_(0.0f, 6.0f, -16.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171430_((float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(50, 12).m_171481_(-16.0f, 6.0f, -16.0f, 3.0f, 3.0f, 3.0f), PartPose.m_171430_((float)1.5707964f, (float)0.0f, (float)4.712389f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(VelvetBedTileEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Material material = MATERIAL;
        Level level = pBlockEntity.m_58904_();
        if (level != null) {
            BlockState blockstate = pBlockEntity.m_58900_();
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = DoubleBlockCombiner.m_52822_(ModBlocks.VELVET_BED_TILE_ENTITY, BedBlock::m_49559_, BedBlock::m_49557_, (DirectionProperty)ChestBlock.f_51478_, (BlockState)blockstate, (LevelAccessor)level, (BlockPos)pBlockEntity.m_58899_(), (p_112202_, p_112203_) -> false);
            int i = ((Int2IntFunction)neighborcombineresult.m_5649_((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(pPackedLight);
            this.renderPiece(pPoseStack, pBufferSource, blockstate.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD ? this.headRoot : this.footRoot, (Direction)blockstate.m_61143_((Property)BedBlock.f_54117_), material, i, pPackedOverlay, false);
        } else {
            this.renderPiece(pPoseStack, pBufferSource, this.headRoot, Direction.SOUTH, material, pPackedLight, pPackedOverlay, false);
            this.renderPiece(pPoseStack, pBufferSource, this.footRoot, Direction.SOUTH, material, pPackedLight, pPackedOverlay, true);
        }
    }

    private void renderPiece(PoseStack pPoseStack, MultiBufferSource pBufferSource, ModelPart pModelPart, Direction pDirection, Material pMaterial, int pPackedLight, int pPackedOverlay, boolean pFoot) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.0, 0.5625, pFoot ? -1.0 : 0.0);
        pPoseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        pPoseStack.m_85837_(0.5, 0.5, 0.5);
        pPoseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f + pDirection.m_122435_()));
        pPoseStack.m_85837_(-0.5, -0.5, -0.5);
        VertexConsumer vertexconsumer = pMaterial.m_119194_(pBufferSource, RenderType::m_110446_);
        pModelPart.m_104301_(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        pPoseStack.m_85849_();
    }
}

