/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty;

import iskallia.vault.bounty.task.Task;
import java.time.Instant;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class Bounty
implements INBTSerializable<CompoundTag> {
    private UUID id;
    private UUID playerId;
    private Task<?> task;
    private long expiration;

    public Bounty(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public Bounty(UUID id, UUID playerId, Task<?> task) {
        this.id = id;
        this.playerId = playerId;
        this.task = task;
    }

    public Task<?> getTask() {
        return this.task;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public boolean isExpired() {
        return Instant.now().toEpochMilli() >= this.getExpiration();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("id", this.id);
        tag.m_128362_("playerId", this.playerId);
        tag.m_128365_("task", (Tag)this.task.serializeNBT());
        tag.m_128356_("expiration", this.expiration);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.id = tag.m_128342_("id");
        this.playerId = tag.m_128342_("playerId");
        this.task = Task.fromTag(tag.m_128469_("task"));
        this.expiration = tag.m_128454_("expiration");
    }
}

