/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty.task;

import iskallia.vault.bounty.TaskRegistry;
import iskallia.vault.bounty.TaskReward;
import iskallia.vault.bounty.task.Task;
import iskallia.vault.bounty.task.properties.CompletionProperties;
import iskallia.vault.core.data.key.SupplierKey;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objective;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.core.vault.stat.StatsCollector;
import iskallia.vault.event.event.VaultJoinEvent;
import iskallia.vault.event.event.VaultLeaveEvent;
import iskallia.vault.world.data.BountyData;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CompletionTask
extends Task<CompletionProperties> {
    public CompletionTask(UUID bountyId, CompletionProperties properties, TaskReward taskReward) {
        super(TaskRegistry.COMPLETION, bountyId, properties, taskReward);
    }

    public CompletionTask(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    @Override
    public boolean inValidDimension(ServerPlayer serverPlayer) {
        return true;
    }

    @Override
    protected <E> boolean doValidate(ServerPlayer player, E event) {
        if (!(event instanceof VaultLeaveEvent)) {
            return false;
        }
        VaultLeaveEvent e = (VaultLeaveEvent)((Object)event);
        Objectives objectives = e.getVault().get(Vault.OBJECTIVES);
        String objectiveId = objectives.get(Objectives.KEY);
        if (!((CompletionProperties)this.getProperties()).getId().equals("vault") && !((CompletionProperties)this.getProperties()).getId().equalsIgnoreCase(objectiveId)) {
            return false;
        }
        if (e.getVault().has(Vault.STATS)) {
            StatsCollector statCollector = e.getVault().get(Vault.STATS);
            StatCollector stats = statCollector.get(player.m_142081_());
            return stats.getCompletion() == Completion.COMPLETED;
        }
        return false;
    }

    @Override
    public boolean isComplete() {
        return this.amountObtained >= ((CompletionProperties)this.properties).getAmount();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("properties", (Tag)((CompletionProperties)this.properties).serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.properties = new CompletionProperties(tag.m_128469_("properties"));
    }

    @SubscribeEvent
    public static void onVaultLeave(VaultLeaveEvent event) {
        List<Task> legendary = BountyData.get().getAllLegendaryById(event.getPlayer(), TaskRegistry.COMPLETION).stream().filter(task -> !task.isComplete()).toList();
        for (Task task2 : legendary) {
            if (!task2.validate(event.getPlayer(), event)) continue;
            task2.increment(1.0);
            if (task2.isComplete()) {
                task2.complete(event.getPlayer());
            }
            return;
        }
        List<Task> active = BountyData.get().getAllActiveById(event.getPlayer(), TaskRegistry.COMPLETION).stream().filter(task -> !task.isComplete()).toList();
        for (Task task3 : active) {
            if (!task3.validate(event.getPlayer(), event)) continue;
            task3.increment(1.0);
            if (task3.isComplete()) {
                task3.complete(event.getPlayer());
            }
            return;
        }
    }

    @SubscribeEvent
    public static void onVaultEnter(VaultJoinEvent event) {
    }

    private static boolean isValidObjective(ResourceLocation id, Objective objective) {
        SupplierKey key = objective.getKey();
        ResourceLocation objectiveId = key.getId();
        return objectiveId.equals((Object)id);
    }
}

