/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty.task;

import iskallia.vault.bounty.TaskRegistry;
import iskallia.vault.bounty.TaskReward;
import iskallia.vault.bounty.task.Task;
import iskallia.vault.bounty.task.properties.DamageProperties;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.data.BountyData;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class DamageTask
extends Task<DamageProperties> {
    public DamageTask(UUID bountyId, DamageProperties properties, TaskReward taskReward) {
        super(TaskRegistry.DAMAGE_ENTITY, bountyId, properties, taskReward);
    }

    public DamageTask(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    @Override
    protected <E> boolean doValidate(ServerPlayer player, E event) {
        if (!(event instanceof LivingHurtEvent)) {
            return false;
        }
        LivingHurtEvent e = (LivingHurtEvent)event;
        ResourceLocation entityId = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)e.getEntity().m_6095_());
        if (entityId == null) {
            return false;
        }
        if (entityId.equals((Object)((DamageProperties)this.getProperties()).getEntityId())) {
            return true;
        }
        return ModConfigs.BOUNTY_ENTITIES.getValidEntities(((DamageProperties)this.getProperties()).getEntityId()).contains(entityId);
    }

    @Override
    public boolean isComplete() {
        return this.amountObtained >= ((DamageProperties)this.properties).getAmount();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("properties", (Tag)((DamageProperties)this.properties).serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.properties = new DamageProperties(tag.m_128469_("properties"));
    }

    @SubscribeEvent
    public static void onDamageEntity(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        List<Task> legendary = BountyData.get().getAllLegendaryById(player, TaskRegistry.DAMAGE_ENTITY).stream().filter(task -> !task.isComplete()).toList();
        for (Task task2 : legendary) {
            if (!task2.validate(player, event)) continue;
            task2.increment(event.getAmount());
            if (task2.isComplete()) {
                task2.complete(player);
            }
            return;
        }
        List<Task> active = BountyData.get().getAllActiveById(player, TaskRegistry.DAMAGE_ENTITY).stream().filter(task -> !task.isComplete()).toList();
        for (Task task3 : active) {
            if (!task3.validate(player, event)) continue;
            task3.increment(event.getAmount());
            if (task3.isComplete()) {
                task3.complete(player);
            }
            return;
        }
    }
}

