/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty.task;

import iskallia.vault.bounty.TaskRegistry;
import iskallia.vault.bounty.TaskReward;
import iskallia.vault.bounty.task.Task;
import iskallia.vault.bounty.task.properties.KillEntityProperties;
import iskallia.vault.world.data.BountyData;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class KillEntityTask
extends Task<KillEntityProperties> {
    public KillEntityTask(UUID bountyId, KillEntityProperties properties, TaskReward taskReward) {
        super(TaskRegistry.KILL_ENTITY, bountyId, properties, taskReward);
    }

    public KillEntityTask(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    @Override
    protected <E> boolean doValidate(ServerPlayer player, E event) {
        if (!(event instanceof LivingDeathEvent)) {
            return false;
        }
        LivingDeathEvent e = (LivingDeathEvent)event;
        return ((KillEntityProperties)this.getProperties()).getFilter().test(e.getEntity());
    }

    @Override
    public boolean isComplete() {
        return this.amountObtained >= ((KillEntityProperties)this.properties).getAmount();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("properties", (Tag)((KillEntityProperties)this.properties).serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.properties = new KillEntityProperties(tag.m_128469_("properties"));
    }

    @SubscribeEvent
    public static void onKillEntity(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        List<Task> legendary = BountyData.get().getAllLegendaryById(player, TaskRegistry.KILL_ENTITY).stream().filter(task -> !task.isComplete()).toList();
        for (Task task2 : legendary) {
            if (!task2.validate(player, event)) continue;
            task2.increment(1.0);
            if (task2.isComplete()) {
                task2.complete(player);
            }
            return;
        }
        List<Task> active = BountyData.get().getAllActiveById(player, TaskRegistry.KILL_ENTITY).stream().filter(task -> !task.isComplete()).toList();
        for (Task task3 : active) {
            if (!task3.validate(player, event)) continue;
            task3.increment(1.0);
            if (task3.isComplete()) {
                task3.complete(player);
            }
            return;
        }
    }
}

