/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty.task;

import iskallia.vault.block.VaultOreBlock;
import iskallia.vault.bounty.TaskRegistry;
import iskallia.vault.bounty.TaskReward;
import iskallia.vault.bounty.task.Task;
import iskallia.vault.bounty.task.properties.MiningProperties;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.data.BountyData;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class MiningTask
extends Task<MiningProperties> {
    public MiningTask(UUID bountyId, MiningProperties properties, TaskReward taskReward) {
        super(TaskRegistry.MINING, bountyId, properties, taskReward);
    }

    public MiningTask(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    @Override
    protected <E> boolean doValidate(ServerPlayer player, E event) {
        block5: {
            VaultOreBlock block;
            block7: {
                block6: {
                    if (!(event instanceof BlockEvent.BreakEvent)) break block5;
                    BlockEvent.BreakEvent e = (BlockEvent.BreakEvent)event;
                    BlockState state = e.getState();
                    Block block2 = state.m_60734_();
                    if (!(block2 instanceof VaultOreBlock)) break block6;
                    block = (VaultOreBlock)block2;
                    if (((Boolean)state.m_61143_((Property)VaultOreBlock.GENERATED)).booleanValue()) break block7;
                }
                return false;
            }
            ResourceLocation id = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
            if (id == null) {
                return false;
            }
            if (id.equals((Object)((MiningProperties)this.getProperties()).getBlockId())) {
                return true;
            }
            return ModConfigs.BOUNTY_ORES.getValidOres(((MiningProperties)this.getProperties()).getBlockId()).contains(id);
        }
        return false;
    }

    @Override
    public boolean isComplete() {
        return this.amountObtained >= ((MiningProperties)this.getProperties()).getAmount();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128365_("properties", (Tag)((MiningProperties)this.properties).serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.properties = new MiningProperties(tag.m_128469_("properties"));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onOreBroken(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        List<Task> legendary = BountyData.get().getAllLegendaryById(player2, TaskRegistry.MINING).stream().filter(task -> !task.isComplete()).toList();
        for (Task task2 : legendary) {
            if (!task2.validate(player2, event)) continue;
            task2.increment(1.0);
            if (task2.isComplete()) {
                task2.complete(player2);
            }
            return;
        }
        List<Task> active = BountyData.get().getAllActiveById(player2, TaskRegistry.MINING).stream().filter(task -> !task.isComplete()).toList();
        for (Task task3 : active) {
            if (!task3.validate(player2, event)) continue;
            task3.increment(1.0);
            if (task3.isComplete()) {
                task3.complete(player2);
            }
            return;
        }
    }
}

