/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty.task;

import iskallia.vault.bounty.TaskRegistry;
import iskallia.vault.bounty.TaskReward;
import iskallia.vault.bounty.task.CompletionTask;
import iskallia.vault.bounty.task.DamageTask;
import iskallia.vault.bounty.task.ItemDiscoveryTask;
import iskallia.vault.bounty.task.ItemSubmissionTask;
import iskallia.vault.bounty.task.KillEntityTask;
import iskallia.vault.bounty.task.MiningTask;
import iskallia.vault.bounty.task.properties.TaskProperties;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.bounty.ClientboundBountyCompleteMessage;
import iskallia.vault.world.data.BountyData;
import iskallia.vault.world.data.ServerVaults;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkDirection;

public abstract class Task<P extends TaskProperties>
implements INBTSerializable<CompoundTag> {
    protected ResourceLocation taskType;
    protected UUID bountyId;
    protected P properties;
    protected TaskReward taskReward;
    protected double amountObtained;

    protected Task(ResourceLocation taskType, UUID bountyId, P properties, TaskReward taskReward) {
        this.taskType = taskType;
        this.bountyId = bountyId;
        this.properties = properties;
        this.taskReward = taskReward;
    }

    protected Task() {
    }

    protected abstract <E> boolean doValidate(ServerPlayer var1, E var2);

    public <E> boolean validate(ServerPlayer player, E event) {
        return this.inValidDimension(player) && this.doValidate(player, event);
    }

    public void increment(double amount) {
        this.doIncrement(amount);
        BountyData.get().m_77762_();
    }

    protected void doIncrement(double amount) {
        this.amountObtained = (int)Math.min(((TaskProperties)this.properties).getAmount(), this.amountObtained + amount);
    }

    public abstract boolean isComplete();

    protected void complete(ServerPlayer player) {
        ModNetwork.CHANNEL.sendTo((Object)new ClientboundBountyCompleteMessage(this.taskType), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        BountyData.syncBounties(player);
    }

    public UUID getBountyId() {
        return this.bountyId;
    }

    public ResourceLocation getTaskType() {
        return this.taskType;
    }

    public P getProperties() {
        return this.properties;
    }

    public TaskReward getTaskReward() {
        return this.taskReward;
    }

    public double getAmountObtained() {
        return this.amountObtained;
    }

    public boolean inValidDimension(ServerPlayer serverPlayer) {
        if (((TaskProperties)this.getProperties()).isVaultOnly()) {
            return this.getTaskType().equals((Object)TaskRegistry.COMPLETION) || ServerVaults.get(serverPlayer.f_19853_).isPresent();
        }
        return ((TaskProperties)this.getProperties()).getValidDimensions().isEmpty() || ((TaskProperties)this.getProperties()).getValidDimensions().contains(serverPlayer.m_183503_().m_46472_().m_135782_());
    }

    public static <T extends Task<P>, P extends TaskProperties> T fromTag(CompoundTag tag) {
        ResourceLocation id = new ResourceLocation(tag.m_128461_("taskType"));
        if (id.equals((Object)TaskRegistry.KILL_ENTITY)) {
            return (T)new KillEntityTask(tag);
        }
        if (id.equals((Object)TaskRegistry.DAMAGE_ENTITY)) {
            return (T)new DamageTask(tag);
        }
        if (id.equals((Object)TaskRegistry.COMPLETION)) {
            return (T)new CompletionTask(tag);
        }
        if (id.equals((Object)TaskRegistry.ITEM_SUBMISSION)) {
            return (T)new ItemSubmissionTask(tag);
        }
        if (id.equals((Object)TaskRegistry.ITEM_DISCOVERY)) {
            return (T)new ItemDiscoveryTask(tag);
        }
        if (id.equals((Object)TaskRegistry.MINING)) {
            return (T)new MiningTask(tag);
        }
        throw new IllegalArgumentException("No task found based on the taskType: " + id);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("taskType", this.taskType.toString());
        tag.m_128359_("bountyId", this.bountyId.toString());
        tag.m_128365_("reward", (Tag)this.taskReward.serializeNBT());
        tag.m_128347_("amountObtained", this.amountObtained);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.taskType = new ResourceLocation(tag.m_128461_("taskType"));
        this.bountyId = UUID.fromString(tag.m_128461_("bountyId"));
        this.taskReward = new TaskReward(tag.m_128469_("reward"));
        this.amountObtained = tag.m_128459_("amountObtained");
    }
}

