/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.bounty.task.properties;

import iskallia.vault.util.nbt.NBTHelper;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class TaskProperties
implements INBTSerializable<CompoundTag> {
    protected ResourceLocation taskType;
    protected List<ResourceLocation> validDimensions;
    private boolean vaultOnly;
    private double amount;
    private String rewardPool;

    protected TaskProperties(ResourceLocation taskType, List<ResourceLocation> validDimensions, boolean vaultOnly, double amount) {
        this.taskType = taskType;
        this.validDimensions = validDimensions;
        this.vaultOnly = vaultOnly;
        this.amount = amount;
    }

    public TaskProperties setRewardPool(String rewardPool) {
        this.rewardPool = rewardPool;
        return this;
    }

    public String getRewardPool() {
        return this.rewardPool == null || this.rewardPool.equals("") ? "common" : this.rewardPool;
    }

    public TaskProperties(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public ResourceLocation getTaskType() {
        return this.taskType;
    }

    public boolean isVaultOnly() {
        return this.vaultOnly;
    }

    public double getAmount() {
        return this.amount;
    }

    public List<ResourceLocation> getValidDimensions() {
        return this.validDimensions;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("taskType", this.taskType.toString());
        NBTHelper.writeCollection(tag, "validDimensions", this.validDimensions, StringTag.class, id -> StringTag.m_129297_((String)id.toString()));
        tag.m_128379_("vaultOnly", this.vaultOnly);
        tag.m_128347_("amount", this.amount);
        tag.m_128359_("rewardPool", this.rewardPool == null ? "common" : this.rewardPool);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.taskType = new ResourceLocation(nbt.m_128461_("taskType"));
        this.validDimensions = NBTHelper.readList(nbt, "validDimensions", StringTag.class, stringTag -> new ResourceLocation(stringTag.m_7916_()));
        this.vaultOnly = nbt.m_128471_("vaultOnly");
        this.amount = nbt.m_128459_("amount");
        this.rewardPool = nbt.m_128441_("rewardPool") ? nbt.m_128461_("rewardPool") : "common";
    }
}

